/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int rawOffset;
    private boolean useDaylight;
    private int dstSavings;
    private int startYear;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private int startMode;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endMode;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private byte[] monthLength;
    private static final byte[] monthArr = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int serialVersionOnStream;
    private static final long serialVersionUID = -403250971215465050L;

    private /* synthetic */ void finit$() {
        this.dstSavings = 3600000;
        this.monthLength = monthArr;
        this.serialVersionOnStream = 1;
    }

    public SimpleTimeZone(int rawOffset, String id) {
        this.finit$();
        this.rawOffset = rawOffset;
        this.setID(id);
        this.useDaylight = false;
        this.startYear = 0;
    }

    public SimpleTimeZone(int rawOffset, String id, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime) {
        this.finit$();
        this.rawOffset = rawOffset;
        this.setID(id);
        this.useDaylight = true;
        this.setStartRule(startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime);
        if (startMonth == endMonth) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
    }

    public SimpleTimeZone(int rawOffset, String id, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime, int dstSavings) {
        this(rawOffset, id, startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime, endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime);
        this.dstSavings = dstSavings;
    }

    public void setStartYear(int year) {
        this.startYear = year;
        this.useDaylight = true;
    }

    private int checkRule(int month, int day, int dayOfWeek) {
        int daysInMonth = this.getDaysInMonth(month, 1);
        if (dayOfWeek == 0) {
            if (day <= 0 || day > daysInMonth) {
                throw new IllegalArgumentException("day out of range");
            }
            return 1;
        }
        if (dayOfWeek > 0) {
            if (Math.abs(day) > (daysInMonth + 6) / 7) {
                throw new IllegalArgumentException("dayOfWeekInMonth out of range");
            }
            if (dayOfWeek > 7) {
                throw new IllegalArgumentException("dayOfWeek out of range");
            }
            return 2;
        }
        if (day == 0 || Math.abs(day) > daysInMonth) {
            throw new IllegalArgumentException("day out of range");
        }
        if (dayOfWeek < -7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (day < 0) {
            return 4;
        }
        return 3;
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time) {
        this.startMode = this.checkRule(month, day, dayOfWeek);
        this.startMonth = month;
        this.startDay = Math.abs(day);
        this.startDayOfWeek = Math.abs(dayOfWeek);
        this.startTime = time;
        this.useDaylight = true;
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time) {
        this.endMode = this.checkRule(month, day, dayOfWeek);
        this.endMonth = month;
        this.endDay = Math.abs(day);
        this.endDayOfWeek = Math.abs(dayOfWeek);
        this.endTime = time;
        this.useDaylight = true;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        int daylightSavings = 0;
        if (this.useDaylight && era == 1 && year >= this.startYear) {
            boolean afterStart = this.isBefore(year, month, day, dayOfWeek, millis, this.startMode, this.startMonth, this.startDay, this.startDayOfWeek, this.startTime) ^ true;
            boolean beforeEnd = this.isBefore(year, month, day, dayOfWeek, millis, this.endMode, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
            daylightSavings = this.startMonth < this.endMonth ? (afterStart && beforeEnd ? this.dstSavings : 0) : (beforeEnd || afterStart ? this.dstSavings : 0);
        }
        return this.rawOffset + daylightSavings;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private int getDaysInMonth(int month, int year) {
        if (month == 1) {
            if ((year & 3) == 0 && (year % 100 != 0 || year % 400 == 0)) {
                return 29;
            }
            return 28;
        }
        if (month < 7) {
            return 31 - (month & 1);
        }
        return 30 + (month & 1);
    }

    private boolean isBefore(int calYear, int calMonth, int calDayOfMonth, int calDayOfWeek, int calMillis, int mode, int month, int day, int dayOfWeek, int millis) {
        if (calMonth != month) {
            return calMonth < month;
        }
        switch (mode) {
            case 1: {
                if (calDayOfMonth == day) break;
                return calDayOfMonth < day;
            }
            case 2: {
                calDayOfMonth += dayOfWeek - calDayOfWeek;
                calDayOfMonth = day < 0 ? (calDayOfMonth -= this.getDaysInMonth(calMonth, calYear) + 7) : (calDayOfMonth += 6);
                int week = calDayOfMonth / 7;
                if (week != day) {
                    return week < day;
                }
                if (calDayOfWeek == dayOfWeek) break;
                return calDayOfWeek < dayOfWeek;
            }
            case 4: {
                day -= 6;
            }
            case 3: {
                if ((calDayOfMonth -= (calDayOfWeek < dayOfWeek ? 7 : 0) + calDayOfWeek - dayOfWeek) < day) {
                    return true;
                }
                if (calDayOfWeek == dayOfWeek && calDayOfMonth < day + 7) break;
                return false;
            }
        }
        return calMillis < millis;
    }

    public boolean inDaylightTime(Date date) {
        Calendar cal = Calendar.getInstance(this);
        cal.setTime(date);
        return cal.get(16) != 0;
    }

    public synchronized int hashCode() {
        return this.rawOffset ^ (this.useDaylight ? this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime : 0);
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone zone = (SimpleTimeZone)o;
        if (zone.hashCode() != this.hashCode() || !this.getID().equals(zone.getID()) || this.rawOffset != zone.rawOffset || this.useDaylight != zone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        return this.startYear == zone.startYear && this.startMonth == zone.startMonth && this.startDay == zone.startDay && this.startDayOfWeek == zone.startDayOfWeek && this.startTime == zone.startTime && this.endMonth == zone.endMonth && this.endDay == zone.endDay && this.endDayOfWeek == zone.endDayOfWeek && this.endTime == zone.endTime;
    }

    public boolean hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone zone = (SimpleTimeZone)other;
        if (zone.hashCode() != this.hashCode() || this.rawOffset != zone.rawOffset || this.useDaylight != zone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        return this.startYear == zone.startYear && this.startMonth == zone.startMonth && this.startDay == zone.startDay && this.startDayOfWeek == zone.startDayOfWeek && this.startTime == zone.startTime && this.endMonth == zone.endMonth && this.endDay == zone.endDay && this.endDayOfWeek == zone.endDayOfWeek && this.endTime == zone.endTime;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime : "") + "]";
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        if (this.serialVersionOnStream == 0) {
            this.dstSavings = 3600000;
            this.endMode = 2;
            this.startMode = 2;
            this.serialVersionOnStream = 1;
        } else {
            int length = input.readInt();
            byte[] byteArray = new byte[length];
            input.read(byteArray, 0, length);
            if (length >= 4) {
                this.startDay = byteArray[0];
                this.startDayOfWeek = byteArray[1];
                this.endDay = byteArray[2];
                this.endDayOfWeek = byteArray[3];
            }
        }
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        byte[] byteArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        switch (this.startMode) {
            case 1: {
                this.startDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.startDay = (this.startDay + 6) / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.endDay = (this.endDay + 6) / 7;
            }
        }
        output.defaultWriteObject();
        output.writeInt(byteArray.length);
        output.write(byteArray, 0, byteArray.length);
    }
}

