/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private String inputString;
    private char[] chArray;
    private String delimiters;
    private boolean returnDelimiters;
    private int inputStringIndex;

    public StringTokenizer(String str) {
        this(str, " \t\n\r", false);
    }

    public StringTokenizer(String str, String delims) {
        this(str, delims, false);
    }

    public StringTokenizer(String str, String delims, boolean retDelim) {
        this.inputString = str;
        this.delimiters = delims;
        this.returnDelimiters = retDelim;
        this.inputStringIndex = 0;
        this.chArray = new char[this.inputString.length()];
        this.inputString.getChars(0, this.inputString.length(), this.chArray, 0);
    }

    public int countTokens() {
        int count = 0;
        int delimiterCount = 0;
        boolean tokenFound = false;
        int offset = this.inputStringIndex;
        while (offset < this.chArray.length) {
            if (this.isDelimiter(this.chArray[offset++])) {
                if (tokenFound) {
                    ++count;
                    tokenFound = false;
                }
                ++delimiterCount;
                continue;
            }
            tokenFound = true;
            while (offset < this.chArray.length && !this.isDelimiter(this.chArray[offset])) {
                ++offset;
            }
        }
        if (tokenFound) {
            ++count;
        }
        if (this.returnDelimiters) {
            return count + delimiterCount;
        }
        return count;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        int offset = this.inputStringIndex;
        while (offset < this.chArray.length) {
            if (this.isDelimiter(this.chArray[offset++]) && !this.returnDelimiters) continue;
            this.inputStringIndex = --offset;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        int offset = this.inputStringIndex;
        int startSubstr = -1;
        while (offset < this.chArray.length && startSubstr < 0) {
            if (!this.isDelimiter(this.chArray[offset++])) {
                startSubstr = offset - 1;
                continue;
            }
            if (!this.returnDelimiters) continue;
            this.inputStringIndex = offset;
            return this.inputString.substring(offset - 1, this.inputStringIndex);
        }
        while (offset < this.chArray.length) {
            if (!this.isDelimiter(this.chArray[offset++])) continue;
            this.inputStringIndex = offset - 1;
            return this.inputString.substring(startSubstr, this.inputStringIndex);
        }
        if (startSubstr < 0) {
            throw new NoSuchElementException();
        }
        this.inputStringIndex = offset;
        return this.inputString.substring(startSubstr, this.inputStringIndex);
    }

    public String nextToken(String delims) {
        this.delimiters = delims;
        return this.nextToken();
    }

    private boolean isDelimiter(char ch) {
        return this.delimiters.indexOf(ch, 0) >= 0;
    }
}

