/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private final Manifest manifest = this.readManifest();
    private boolean verify;

    public JarFile(String fileName) throws IOException, FileNotFoundException {
        this(fileName, true);
    }

    public JarFile(String fileName, boolean verify) throws IOException, FileNotFoundException {
        super(fileName);
        if (verify) {
            this.verify();
        }
    }

    public JarFile(File file) throws IOException, FileNotFoundException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException, FileNotFoundException {
        super(file);
        if (verify) {
            this.verify();
        }
    }

    public JarFile(File file, boolean verify, int mode) throws IOException, FileNotFoundException {
        super(file, mode);
        if (verify) {
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry manEntry = super.getEntry(MANIFEST_NAME);
            if (manEntry != null) {
                InputStream in = super.getInputStream(manEntry);
                return new Manifest(in);
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Enumeration entries() {
        return new JarEnumeration(this, super.entries());
    }

    public ZipEntry getEntry(String name) {
        ZipEntry entry = super.getEntry(name);
        if (entry != null) {
            JarEntry jarEntry = new JarEntry(entry);
            if (this.manifest != null) {
                jarEntry.attr = this.manifest.getAttributes(name);
            }
            return jarEntry;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry entry) throws IOException, ZipException {
        return super.getInputStream(entry);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    class JarEnumeration
    implements Enumeration {
        private /* synthetic */ JarFile this$0;
        private final Enumeration entries;

        JarEnumeration(JarFile this$0, Enumeration e) {
            this.this$0 = this$0;
            this.entries = e;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            ZipEntry zip = (ZipEntry)this.entries.nextElement();
            JarEntry jar = new JarEntry(zip);
            if (this.this$0.manifest != null) {
                jar.attr = this.this$0.manifest.getAttributes(jar.getName());
            }
            return jar;
        }
    }
}

