/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sound.midi.Sequence;
import javax.sound.sampled.Clip;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Runner
extends JPanel
implements ActionListener,
ChangeListener,
Runnable {
    boolean STOP;
    boolean NOTIFY;
    int numRuns = 1;
    Hashtable modules = new Hashtable();
    Hashtable audio = new Hashtable();
    Thread thread;
    JTabbedPane tabPane;
    int index;
    JButton startStopB;
    JTextArea textarea;
    PrintWriter fileOut;

    public Runner(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        Object object3;
        this.setLayout(new BorderLayout());
        this.loadModules();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("Run=")) {
                object3 = stringArray[n].substring(stringArray[n].indexOf(61) + 1);
                this.numRuns = Integer.valueOf(object3);
            } else if (stringArray[n].startsWith("QuickLook")) {
                bl = true;
                object3 = this.modules.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ModuleData)object3.nextElement();
                    ((DataProperties)object2).setSelected(true);
                    ((MethodData)((ModuleData)object2).methods.get("Test_QuickLook")).setSelected(true);
                }
            } else if (stringArray[n].indexOf(".") != -1) {
                object3 = stringArray[n];
                bl = true;
                object2 = ((String)object3).substring(0, ((String)object3).indexOf(46));
                object = (ModuleData)this.modules.get(object2);
                ((DataProperties)object).setSelected(true);
                string = ((String)object3).substring(((String)object3).indexOf(46) + 1, ((String)object3).length());
                ((MethodData)((ModuleData)object).methods.get(string)).setSelected(true);
            } else if (stringArray[n].startsWith("Juke") || stringArray[n].startsWith("Groove") || stringArray[n].startsWith("MidiSynth") || stringArray[n].startsWith("CapturePlayback")) {
                bl = true;
                ((ModuleData)this.modules.get(stringArray[n])).setMethodsSelected(true);
            } else if (stringArray[n].startsWith("File")) {
                this.openOutputStream(stringArray[n]);
            } else {
                object3 = new File(stringArray[n]);
                if (object3 != null && ((File)object3).exists() && ((File)object3).isDirectory()) {
                    object2 = (JukeModule)((ModuleData)this.modules.get((Object)"Juke")).module;
                    this.loadAudio(stringArray[n]);
                    ((Juke)object2).startB.setEnabled(true);
                    ((Juke)object2).loadJuke(stringArray[n]);
                    ((Juke)object2).jukeTable.tableChanged();
                }
            }
            ++n;
        }
        if (!bl) {
            object3 = this.modules.elements();
            while (object3.hasMoreElements()) {
                ((ModuleData)object3.nextElement()).setMethodsSelected(true);
            }
        }
        if (this.fileOut == null) {
            this.openOutputStream("results.txt");
        }
        object3 = new JPanel(new BorderLayout());
        ((JComponent)object3).setBorder(new EmptyBorder(5, 5, 5, 5));
        this.textarea = new JTextArea();
        this.textarea.setFont(new Font("TimesRoman", 0, 14));
        this.textarea.setForeground(Color.black);
        this.textarea.setBackground(Color.lightGray);
        this.textarea.setEditable(false);
        this.textarea.setAutoscrolls(true);
        object2 = new JScrollPane();
        ((JScrollPane)object2).getViewport().add(this.textarea);
        ((Container)object3).add((Component)object2);
        object = new JSplitPane(1, new SelectionUI(), (Component)object3);
        ((JSplitPane)object).setContinuousLayout(true);
        this.add("Center", (Component)object);
        object3 = new JPanel(new BorderLayout());
        this.startStopB = this.addButton("Start", (JPanel)object3);
        ((Container)object3).add(this.startStopB);
        this.add("South", (Component)object3);
        string = "\n\nJava Sound Runner\njava version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n" + new Date().toString() + "\n";
        this.print(string);
    }

    private JButton addButton(String string, JPanel jPanel) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jButton;
    }

    private void loadModules() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu("File"));
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevelBorder = new BevelBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, bevelBorder);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 90, 0)));
        JukeModule jukeModule = new JukeModule(null);
        jPanel.add(jukeModule);
        this.modules.put("Juke", new ModuleData(jukeModule, 0));
        this.tabPane.addTab("Juke Box", jPanel);
        CapturePlaybackModule capturePlaybackModule = new CapturePlaybackModule();
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 90, 0)));
        this.modules.put("CapturePlayback", new ModuleData(capturePlaybackModule, 1));
        jPanel.add(capturePlaybackModule);
        this.tabPane.addTab("Capture/Playback", jPanel);
        MidiSynthModule midiSynthModule = new MidiSynthModule();
        this.modules.put("MidiSynth", new ModuleData(midiSynthModule, 2));
        this.tabPane.addTab("Midi Synthesizer", midiSynthModule);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 5, 20)));
        GrooveModule grooveModule = new GrooveModule();
        jPanel.add(grooveModule);
        this.modules.put("Groove", new ModuleData(grooveModule, 3));
        this.tabPane.addTab("Groove Box", jPanel);
        JFrame jFrame = new JFrame("Java Sound Demo");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("North", jMenuBar);
        jFrame.getContentPane().add("Center", this.tabPane);
        int n = 760;
        int n2 = 500;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.pack();
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setSize(n, n2);
        ((Component)jFrame).setVisible(true);
    }

    private void addSound(File file) {
        String string = file.getName();
        if (string.endsWith(".au") || string.endsWith(".rmf") || string.endsWith(".mid") || string.endsWith(".wav") || string.endsWith(".aif") || string.endsWith(".aiff")) {
            this.audio.put(string, file);
        }
    }

    public void loadAudio(String string) {
        File file = new File(string);
        if (file != null && file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file.getAbsolutePath(), stringArray[n]);
                if (file2.isDirectory()) {
                    this.loadAudio(file2.getAbsolutePath());
                } else {
                    this.addSound(file2);
                }
                ++n;
            }
        } else if (file != null && file.exists()) {
            this.addSound(file);
        }
    }

    private void openOutputStream(String string) {
        try {
            File file = new File(string);
            if (file.canWrite()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.fileOut = new PrintWriter(fileOutputStream);
            }
        }
        catch (Exception exception) {
            System.out.println("Error creating results file " + exception.toString());
            return;
        }
    }

    public void print(String string) {
        System.out.println(string);
        this.textarea.append(string + "\n");
        int n = this.textarea.getPreferredSize().height;
        this.textarea.scrollRectToVisible(new Rectangle(0, n, 1, 1));
        if (this.fileOut != null) {
            this.fileOut.print(string);
            this.fileOut.flush();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton.equals(this.startStopB)) {
            if (jButton.getText().equals("Start")) {
                this.STOP = false;
                this.start();
                jButton.setText("Stop");
            } else if (jButton.getText().equals("Stop")) {
                this.STOP = true;
                this.stop();
                jButton.setText("Start");
                this.print("Finished!\n");
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.close();
        System.gc();
        this.index = this.tabPane.getSelectedIndex();
        this.open();
        this.NOTIFY = true;
    }

    public void close() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ModuleData moduleData = (ModuleData)enumeration.nextElement();
            if (moduleData.index != this.index) continue;
            ((ControlContext)moduleData.module).close();
            break;
        }
    }

    public void open() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ModuleData moduleData = (ModuleData)enumeration.nextElement();
            if (moduleData.index != this.index) continue;
            ((ControlContext)moduleData.module).open();
            break;
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("Java Sound Runner");
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public void run() {
        int n = 0;
        while (n < this.numRuns && !this.STOP) {
            this.print("\nInitiating Run #" + n);
            Enumeration enumeration = this.modules.elements();
            while (enumeration.hasMoreElements() && !this.STOP) {
                ModuleData moduleData = (ModuleData)enumeration.nextElement();
                if (!moduleData.isSelected()) continue;
                this.print(moduleData.name);
                if (moduleData.index != this.tabPane.getSelectedIndex()) {
                    this.NOTIFY = false;
                    this.tabPane.setSelectedIndex(moduleData.index);
                    while (!this.NOTIFY && !this.STOP) {
                        try {
                            Thread.sleep(99L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(999L);
                    }
                    catch (Exception exception) {}
                } else {
                    ((ControlContext)moduleData.module).open();
                }
                Enumeration enumeration2 = moduleData.methods.elements();
                while (enumeration2.hasMoreElements() && !this.STOP) {
                    MethodData methodData = (MethodData)enumeration2.nextElement();
                    if (!methodData.isSelected()) continue;
                    String string = methodData.method.getName();
                    this.print("    " + string);
                    try {
                        methodData.method.invoke(moduleData.module, null);
                        Thread.sleep(999L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            ++n;
        }
        if (this.thread != null) {
            this.startStopB.doClick();
        }
        if (this.fileOut != null) {
            this.fileOut.close();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-h") || stringArray[n].startsWith("-help")) {
                object = "Run through all the tests once : \n    java -cp JavaSound.jar Runner Run \n\nRun through all the tests twenty times : \n    java -cp JavaSound.jar Runner Run=20 \n\nRun through all the QuickLook tests : \n    java -cp JavaSound.jar Runner QuickLook \n\nRun through all the Juke tests : \n    java -cp JavaSound.jar Runner Juke \n\nRun through one of the Juke tests : \n    java -cp JavaSound.jar Runner Juke.Test_QuickLook \n\nPass several directories to Runner : \n    java -cp JavaSound.jar Runner audio1 audio2 \nRun with a named file : \n    java -cp JavaSound.jar Runner File=JDK13-A.results \n";
                System.out.println("\n" + (String)object);
                System.exit(0);
            }
            ++n;
        }
        object = new Runner(stringArray);
        JFrame jFrame = new JFrame("Java Sound Runner");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", (Component)object);
        jFrame.pack();
        ((Component)jFrame).setLocation(0, 0);
        ((Component)jFrame).setSize(new Dimension(420, 300));
        ((Component)jFrame).setVisible(true);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("Run")) {
                ((Runner)object).startStopB.doClick();
            }
            ++n2;
        }
    }

    class GrooveModule
    extends Groove {
        public void Test_QuickLook() {
            this.tempoDial.setTempo(120.0f);
            this.startB.doClick();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void Test_Tempo() {
            if (!this.loopB.isSelected()) {
                this.loopB.doClick();
            }
            this.startB.doClick();
            int n = 40;
            while (n < 180 && !Runner.this.STOP) {
                this.tempoDial.setTempo(n);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    break;
                }
                n += 10;
            }
            this.startB.doClick();
            this.loopB.doClick();
        }

        public void Test_Beats() {
            if (!this.loopB.isSelected()) {
                this.loopB.doClick();
            }
            this.startB.doClick();
            int n = 0;
            while (n < this.combo.getItemCount() && !Runner.this.STOP) {
                this.combo.setSelectedIndex(n);
                try {
                    Thread.sleep(9000L);
                }
                catch (Exception exception) {
                    break;
                }
                ++n;
            }
            this.startB.doClick();
            this.loopB.doClick();
        }
    }

    class MidiSynthModule
    extends MidiSynth {
        public void Test_QuickLook() {
            this.playWhiteKeys();
        }

        public void Test_RecordSave() {
            this.controls.recordB.doClick();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                return;
            }
            this.recordFrame.recordB.doClick();
            this.playWhiteKeys();
            this.recordFrame.recordB.doClick();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                return;
            }
            this.recordFrame.playB.doClick();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                return;
            }
            String string = System.getProperty("user.home");
            File file = new File(string, "test.mid");
            this.recordFrame.saveMidiFile(file);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                return;
            }
            ModuleData moduleData = (ModuleData)Runner.this.modules.get("Juke");
            JukeModule jukeModule = (JukeModule)moduleData.module;
            Runner.this.tabPane.setSelectedIndex(moduleData.index);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                return;
            }
            if (jukeModule.sounds.size() == 0) {
                jukeModule.startB.setEnabled(true);
            }
            jukeModule.loadJuke("test.mid");
            jukeModule.jukeTable.tableChanged();
            int n = jukeModule.sounds.size() - 1;
            jukeModule.table.getSelectionModel().setSelectionInterval(n, n);
            if (jukeModule.loopB.isSelected()) {
                jukeModule.loopB.doClick();
            }
            jukeModule.startB.doClick();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                return;
            }
            int n2 = ((ModuleData)Runner.this.modules.get((Object)"MidiSynth")).index;
            Runner.this.tabPane.setSelectedIndex(n2);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void Test_AllInstruments() {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            ListSelectionModel listSelectionModel2 = this.table.getColumnModel().getSelectionModel();
            int n = 0;
            while (n < this.table.getColumnCount() && !Runner.this.STOP) {
                listSelectionModel2.setSelectionInterval(0, n);
                int n2 = 0;
                while (n2 < this.table.getRowCount() && !Runner.this.STOP) {
                    listSelectionModel.setSelectionInterval(n, n2);
                    this.playWhiteKeys();
                    ++n2;
                }
                ++n;
            }
        }

        private void playWhiteKeys() {
            int n = 0;
            while (n < this.whiteKeys.size() && !Runner.this.STOP) {
                MidiSynth.Key key = (MidiSynth.Key)this.whiteKeys.get(n);
                this.piano.mousePressed(new MouseEvent(this.piano, 501, 0L, 0, key.x + 1, key.y + 70, 1, false));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Runner.this.STOP = true;
                    break;
                }
                this.piano.mouseReleased(new MouseEvent(this.piano, 502, 0L, 0, key.x + 1, key.y + 70, 1, false));
                ++n;
            }
        }
    }

    class CapturePlaybackModule
    extends CapturePlayback {
        public void Test_QuickLook() {
            this.captB.doClick();
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                return;
            }
            this.captB.doClick();
            int n = 0;
            while (n < 60 && this.audioInputStream == null && !Runner.this.STOP) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
                ++n;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.playB.doClick();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void Test_LoadSaveFile() {
            File file;
            if (Runner.this.audio.size() == 0) {
                Runner.this.loadAudio("../jfc/Java2D/media");
                Runner.this.loadAudio("audio");
            }
            if ((file = (File)Runner.this.audio.get("22-new.aif")) != null && file.exists()) {
                this.createAudioInputStream(file, true);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    return;
                }
                this.playB.doClick();
                try {
                    Thread.sleep(6000L);
                }
                catch (Exception exception) {
                    return;
                }
                String string = System.getProperty("user.home");
                String string2 = String.valueOf(System.getProperty("file.separator").toCharArray()[0]);
                String string3 = string + string2 + "untitled.au";
                this.textField.setText(string3);
                this.auB.doClick();
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    return;
                }
                file = new File(string3);
                if (file != null && file.exists()) {
                    this.createAudioInputStream(file, true);
                }
                this.playB.doClick();
                try {
                    Thread.sleep(6000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class JukeModule
    extends Juke {
        public JukeModule(String string) {
            super(string);
        }

        public void Test_QuickLook() {
            if (this.loopB.isSelected()) {
                this.loopB.doClick();
            }
            if (this.sounds.size() == 0) {
                this.loadJuke("../jfc/Java2D/media");
                this.loadJuke("audio");
                if (this.sounds.size() != 0) {
                    this.jukeTable.tableChanged();
                    this.startB.setEnabled(true);
                    Runner.this.loadAudio("../jfc/Java2D/media");
                    Runner.this.loadAudio("audio");
                    try {
                        this.getThread();
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.sounds.size() != 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
                this.startB.doClick();
                do {
                    this.playForDuration(4);
                } while (this.getThread() != null && !Runner.this.STOP);
            }
        }

        private void playForDuration(int n) {
            int n2;
            int n3 = 0;
            while (n3 < 40 && this.currentSound == null && !Runner.this.STOP) {
                try {
                    this.getThread();
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
                ++n3;
            }
            try {
                this.getThread();
                Thread.sleep(99L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream && this.getThread() != null) {
                int n4 = 0;
                while (!(this.midiEOM || this.getThread() == null || this.bump || Runner.this.STOP || n4 >= n)) {
                    n2 = 0;
                    while (!(this.midiEOM || this.getThread() == null || this.bump || Runner.this.STOP || n2 >= 10)) {
                        try {
                            this.getThread();
                            Thread.sleep(90L);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        ++n2;
                    }
                    ++n4;
                }
            } else if (this.currentSound instanceof Clip && this.getThread() != null) {
                Clip clip = (Clip)this.currentSound;
                n2 = 0;
                while ((this.paused || clip.isActive()) && this.getThread() != null && !Runner.this.STOP && !this.bump && n2 < n) {
                    int n5 = 0;
                    while ((this.paused || clip.isActive()) && this.getThread() != null && !Runner.this.STOP && !this.bump && n5 < 10) {
                        try {
                            this.getThread();
                            Thread.sleep(90L);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        ++n5;
                    }
                    ++n2;
                }
            }
            this.bump = true;
            int n6 = 0;
            while (n6 < 20 && this.currentSound != null && !Runner.this.STOP) {
                try {
                    this.getThread();
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
                ++n6;
            }
            this.bump = false;
        }
    }

    class SelectionUI
    extends JPanel {
        private JTree tree;
        MouseListener ml = new MouseAdapter(this){
            private final /* synthetic */ SelectionUI this$1;
            {
                this.this$1 = selectionUI;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    TreePath treePath = SelectionUI.access$000(this.this$1).getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object[] objectArray = treePath.getPath();
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    if (objectArray.length == 1 && n2 <= 20 || objectArray.length == 2 && n >= 20 || objectArray.length == 3 && n >= 40) {
                        DefaultMutableTreeNode defaultMutableTreeNode;
                        DataProperties dataProperties = (DataProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                        SelectionUI.access$100(this.this$1, defaultMutableTreeNode, !dataProperties.isSelected());
                        SelectionUI.access$000(this.this$1).treeDidChange();
                    }
                }
            }
        };

        public SelectionUI() {
            Object object;
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setPreferredSize(new Dimension(180, 200));
            DataProperties dataProperties = new DataProperties("tests", true);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataProperties);
            Enumeration enumeration = Runner.this.modules.elements();
            while (enumeration.hasMoreElements()) {
                object = (ModuleData)enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                Enumeration enumeration2 = ((ModuleData)object).methods.elements();
                while (enumeration2.hasMoreElements()) {
                    MethodData methodData = (MethodData)enumeration2.nextElement();
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(methodData));
                }
            }
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setBackground(Color.lightGray);
            this.tree.addMouseListener(this.ml);
            this.tree.setCellRenderer(new TreeRenderer());
            object = new JScrollPane();
            ((JScrollPane)object).getViewport().add(this.tree);
            this.add((Component)object);
        }

        private void modifySelected(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
            DataProperties dataProperties = (DataProperties)defaultMutableTreeNode.getUserObject();
            dataProperties.setSelected(bl);
            if (!defaultMutableTreeNode.isLeaf()) {
                TreeModel treeModel = this.tree.getModel();
                int n = treeModel.getChildCount(defaultMutableTreeNode);
                int n2 = 0;
                while (n2 < n) {
                    this.modifySelected((DefaultMutableTreeNode)treeModel.getChild(defaultMutableTreeNode, n2), bl);
                    ++n2;
                }
            }
        }

        static /* synthetic */ JTree access$000(SelectionUI selectionUI) {
            return selectionUI.tree;
        }

        static /* synthetic */ void access$100(SelectionUI selectionUI, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
            selectionUI.modifySelected(defaultMutableTreeNode, bl);
        }

        class TreeRenderer
        extends JCheckBox
        implements TreeCellRenderer {
            TreeRenderer() {
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                this.setBackground(Color.lightGray);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                DataProperties dataProperties = (DataProperties)defaultMutableTreeNode.getUserObject();
                this.setText(dataProperties.getName());
                this.setSelected(dataProperties.isSelected());
                return this;
            }
        }
    }

    class MethodData
    extends DataProperties {
        Method method;

        public MethodData(Method method) {
            this.method = method;
            this.setName(method.getName());
        }
    }

    class ModuleData
    extends DataProperties {
        Object module;
        Hashtable methods = new Hashtable();
        int index;

        public ModuleData(Object object, int n) {
            this.module = object;
            this.index = n;
            String string = object.getClass().getName();
            string = string.substring(string.indexOf(36) + 1);
            this.setName(string.substring(0, string.indexOf("Module")));
            Method[] methodArray = object.getClass().getDeclaredMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().startsWith("Test_")) {
                    this.methods.put(methodArray[n2].getName(), new MethodData(methodArray[n2]));
                }
                ++n2;
            }
        }

        public void setMethodsSelected(boolean bl) {
            this.isSelected = bl;
            Enumeration enumeration = this.methods.elements();
            while (enumeration.hasMoreElements()) {
                ((MethodData)enumeration.nextElement()).setSelected(bl);
            }
        }
    }

    public class DataProperties {
        String name;
        boolean isSelected;

        public DataProperties() {
        }

        public DataProperties(String string, boolean bl) {
            this.name = string;
            this.isSelected = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }
}

