/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.Vector;
import javax.sound.midi.Sequencer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TempoDial
extends JPanel {
    private int dotSize = 6;
    private Ellipse2D ellipse;
    private Vector data;
    private Data currentData;
    private Sequencer sequencer;

    public TempoDial() {
        Object object;
        this.setBackground(new Color(20, 20, 20));
        this.ellipse = new Ellipse2D.Float(2.0f, 20.0f, 92.0f, 120.0f);
        Vector<Ellipse2D.Float> vector = new Vector<Ellipse2D.Float>();
        PathIterator pathIterator = this.ellipse.getPathIterator(null, 0.9);
        while (!pathIterator.isDone()) {
            object = new float[6];
            switch (pathIterator.currentSegment((float[])object)) {
                case 0: 
                case 1: {
                    vector.add(new Ellipse2D.Float(object[0], object[1], this.dotSize, this.dotSize));
                }
            }
            pathIterator.next();
        }
        object = new Vector();
        int n = 0;
        while (n < vector.size()) {
            if (((Ellipse2D)vector.get(n)).getY() >= this.ellipse.getHeight() / 2.0) {
                ((Vector)object).add(vector.get(n));
            }
            ++n;
        }
        vector.removeAll((Collection<?>)object);
        float f = (float)(this.ellipse.getX() + this.ellipse.getWidth() / 2.0);
        float f2 = (float)(this.ellipse.getY() + this.ellipse.getHeight() / 2.0);
        Vector<GeneralPath> vector2 = new Vector<GeneralPath>(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            GeneralPath generalPath = new GeneralPath(1);
            generalPath.moveTo(f, f2);
            Ellipse2D ellipse2D = (Ellipse2D)vector.get(n2);
            generalPath.lineTo((float)ellipse2D.getX(), (float)ellipse2D.getY());
            if (n2 + 1 < vector.size()) {
                Ellipse2D ellipse2D2 = (Ellipse2D)vector.get(n2 + 1);
                generalPath.lineTo((float)ellipse2D2.getX(), (float)ellipse2D2.getY());
            }
            generalPath.closePath();
            vector2.add(generalPath);
            ++n2;
        }
        this.data = new Vector(vector2.size());
        int n3 = 0;
        int n4 = 40;
        while (n3 < vector2.size()) {
            this.data.add(new Data(n4, vector.get(n3), vector2.get(n3)));
            if (n4 == 120) {
                this.currentData = (Data)this.data.lastElement();
            }
            ++n3;
            n4 += 10;
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                TempoDial.this.processMouse(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TempoDial.this.processMouse(mouseEvent);
            }
        });
    }

    private void processMouse(MouseEvent mouseEvent) {
        if (this.ellipse.contains(mouseEvent.getPoint())) {
            int n = 0;
            while (n < this.data.size()) {
                this.currentData = (Data)this.data.get(n);
                if (this.currentData.path.contains(mouseEvent.getPoint())) break;
                ++n;
            }
            this.repaint();
            if (this.sequencer != null) {
                this.sequencer.setTempoInBPM(this.getTempo());
            }
        }
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public float getTempo() {
        return this.currentData.tempo;
    }

    public void setTempo(float f) {
        int n = 0;
        while (n < this.data.size()) {
            this.currentData = (Data)this.data.get(n);
            if ((float)this.currentData.tempo == f) break;
            ++n;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(this.getBackground());
        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = this.ellipse.getWidth() / 2.0 + this.ellipse.getX() + (double)(this.dotSize / 2);
        double d2 = this.ellipse.getHeight() / 2.0;
        double d3 = this.currentData.dot.getX() + (double)(this.dotSize / 2);
        double d4 = this.currentData.dot.getY() + (double)(this.dotSize / 2);
        Ellipse2D.Double double_ = new Ellipse2D.Double(d - 5.0, d2 - 5.0, 10.0, 10.0);
        Color color = new Color(204, 204, 255);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(new Line2D.Double(((RectangularShape)double_).getX() + 5.0, ((RectangularShape)double_).getY() + 5.0, d3, d4));
        graphics2D.fill(double_);
        graphics2D.setFont(new Font("serif", 1, 12));
        graphics2D.drawString(String.valueOf(this.currentData.tempo) + " bpm", 2, 12);
        graphics2D.fill(this.currentData.dot);
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.setColor(color.darker());
        int n = 0;
        while (n < this.data.size()) {
            graphics2D.draw(((Data)this.data.get((int)n)).dot);
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(105, 70);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Tempo Dial");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", new TempoDial());
        jFrame.pack();
        ((Component)jFrame).setSize(new Dimension(200, 140));
        ((Component)jFrame).setVisible(true);
    }

    class Data {
        int tempo;
        Ellipse2D dot;
        GeneralPath path;

        public Data(int n, Object object, Object object2) {
            this.tempo = n;
            this.dot = (Ellipse2D)object;
            this.path = (GeneralPath)object2;
        }
    }
}

