/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.ScrollPane;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

class Font2DCanvas
extends Canvas
implements Printable {
    Font font;
    int charHeight;
    int charWidth;
    int charBase;
    int drawMethod;
    int displayType;
    int pageImgHeight;
    int pageHeight;
    Object antialias;
    Object fracMetrics;
    BufferedImage offscr;
    boolean hasChanged;
    Vector dispText;
    Vector userText;
    Vector resourceText;
    Font2DTest font2dtest;
    static final int DRAW_CHARS = 0;
    static final int DRAW_STRING_STRING = 1;
    static final int DRAW_STRING_ITERATOR = 2;
    static final int DRAW_GLYPH_VECTOR = 3;
    static final int DRAW_BYTES = 4;
    static final int DRAW_TEXT_LAYOUT = 5;
    static final int DISPLAY_RANGE = 0;
    static final int DISPLAY_TEXT = 1;
    static final int DISPLAY_GLYPHS = 2;
    static final int DISPLAY_RESOURCES = 3;

    public Font2DCanvas(Font2DTest font2DTest, Font font, int n) {
        this.font2dtest = font2DTest;
        this.font = font;
        this.charWidth = 1;
        this.charHeight = 1;
        this.pageImgHeight = 0;
        this.pageHeight = 0;
        this.charBase = n;
        this.hasChanged = true;
        this.antialias = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.fracMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.dispText = new Vector();
        this.dispText.add("This is Java 2D!");
        this.userText = this.dispText;
        this.drawMethod = 0;
        this.displayType = 0;
        this.setupResourceStrings();
        this.repaint();
    }

    public void setBase(int n) {
        this.charBase = n;
        this.hasChanged = true;
        this.repaint();
    }

    public void setFont(Font font, String string) {
        this.font = font;
        if (!string.equals("None")) {
            this.setFontTransform(string);
        }
        this.hasChanged = true;
        this.resizeCanvas(false);
        this.repaint();
    }

    public void setFontTransform(String string) {
        AffineTransform affineTransform = new AffineTransform();
        if (string.equals("Translate")) {
            affineTransform.translate(10.0, 10.0);
        } else if (string.equals("Rotate")) {
            affineTransform.rotate(0.5235987755982988);
        } else if (string.equals("Scale")) {
            affineTransform.scale(2.0, 2.0);
        } else if (string.equals("Shear")) {
            affineTransform.shear(0.4, 0.0);
        }
        this.font = this.font.deriveFont(affineTransform);
    }

    public void setMethod(String string) {
        if (string.equals("drawChars()")) {
            this.drawMethod = 0;
        } else if (string.equals("drawString(String)")) {
            this.drawMethod = 1;
        } else if (string.equals("drawString(Iterator)")) {
            this.drawMethod = 2;
        } else if (string.equals("drawGlyphVector()")) {
            this.drawMethod = 3;
        } else if (string.equals("drawBytes()")) {
            this.drawMethod = 4;
        } else if (string.equals("TextLayout.draw()")) {
            this.drawMethod = 5;
        }
        this.hasChanged = true;
        this.repaint();
    }

    public void setDisplayType(String string) {
        if (string.equals("Unicode Range")) {
            this.displayType = 0;
        } else if (string.equals("User Text")) {
            this.dispText = this.userText;
            this.displayType = 1;
        } else if (string.equals("All Glyphs")) {
            this.displayType = 2;
        } else if (string.equals("Resource Text")) {
            this.displayType = 1;
            this.userText = this.dispText;
            this.dispText = this.resourceText;
        }
        this.hasChanged = true;
        this.repaint();
    }

    public void setDisplayText(Vector vector) {
        this.dispText = this.userText = vector;
        if (this.displayType == 1) {
            this.hasChanged = true;
            this.repaint();
        }
    }

    protected void setupResourceStrings() {
        String string = "./resources/resource.data";
        this.resourceText = new Vector();
        File file = new File(string);
        if (!file.exists()) {
            this.resourceText.add("Valid resource.data file needed for resource text");
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() < 5) continue;
                ResourceBundle resourceBundle = ResourceBundle.getBundle("resources.TextResources", new Locale(string2.substring(0, 2), string2.substring(3, 5)));
                this.resourceText.add(resourceBundle.getString("string"));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.resourceText.add("Error reading resource text from file: " + string);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceText.add("Missing resource files... (*.properties files)");
        }
    }

    public void setAntialiasing(boolean bl) {
        this.antialias = bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.hasChanged = true;
        this.repaint();
    }

    public void setFractionalMetrics(boolean bl) {
        this.fracMetrics = bl ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.hasChanged = true;
        this.repaint();
    }

    public void resizeCanvas(boolean bl) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            int n = 0;
            int n2 = 0;
            graphics2D.setFont(this.font);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias);
            renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracMetrics);
            graphics2D.setRenderingHints(renderingHints);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = graphics2D.getFont().getMaxCharBounds(fontRenderContext);
            if (this.displayType == 0) {
                this.charWidth = (int)rectangle2D.getWidth() + 4;
                this.charHeight = (int)rectangle2D.getHeight() + 3;
                n = this.charWidth * 21 + 10;
                n2 = this.charHeight * 16 + this.getParentHeight();
            } else if (this.displayType == 1) {
                int n3 = 1;
                this.charWidth = (int)rectangle2D.getWidth();
                this.charHeight = (int)rectangle2D.getHeight() + 2;
                int n4 = 0;
                while (n4 < this.dispText.size()) {
                    String string = (String)this.dispText.elementAt(n4);
                    if (string.length() > n3) {
                        n3 = string.length();
                    }
                    ++n4;
                }
                n = this.charWidth * n3;
                n2 = this.charHeight * this.dispText.size() + this.getParentHeight();
            } else {
                int n5 = graphics2D.getFont().getNumGlyphs();
                this.charWidth = (int)rectangle2D.getWidth() + 4;
                this.charHeight = (int)rectangle2D.getHeight() + 3;
                n = this.charWidth * 21 + 10;
                n2 = this.charHeight * (n5 / 16 + 1) + this.getParentHeight();
            }
            if (!bl) {
                this.setSize(n, n2);
                this.resizeParent();
            }
        }
    }

    public void resizeParent() {
        Container container = this.getParent();
        if (container instanceof ScrollPane) {
            ((Component)container).validate();
        }
    }

    public int getParentHeight() {
        Container container = this.getParent();
        if (container != null) {
            return container.getHeight();
        }
        return 0;
    }

    public void writeSymbolImage(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedImage bufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            Graphics graphics = bufferedImage.getGraphics();
            this.paint(graphics);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            graphics.dispose();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
        }
        catch (IOException iOException) {
            System.err.println("Could not write file: " + string);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.offscr == null || this.hasChanged) {
            this.hasChanged = false;
            this.resizeCanvas(false);
            Dimension dimension = this.getSize();
            this.offscr = (BufferedImage)this.createImage(dimension.width, dimension.height);
            Graphics2D graphics2D2 = this.offscr.createGraphics();
            graphics2D2.setColor(this.getBackground());
            graphics2D2.fill(new Rectangle(0, 0, dimension.width, dimension.height));
            graphics2D2.setFont(this.font);
            graphics2D2.setColor(Color.black);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias);
            renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracMetrics);
            graphics2D2.setRenderingHints(renderingHints);
            if (this.displayType == 0) {
                this.paintRangeOffscreen(graphics2D2, 0, false);
            } else if (this.displayType == 1) {
                this.paintTextOffscreen(graphics2D2, 0, false);
            } else {
                this.paintGlyphsOffscreen(graphics2D2, 0, false);
            }
        }
        graphics2D.drawImage((Image)this.offscr, 0, 0, null);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.resizeCanvas(true);
        this.pageImgHeight = (int)pageFormat.getImageableHeight();
        this.pageHeight = (int)pageFormat.getHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.setFont(this.font);
        graphics2D.setColor(Color.black);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias);
        renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracMetrics);
        graphics2D.setRenderingHints(renderingHints);
        if (this.displayType == 0) {
            return this.paintRangeOffscreen(graphics2D, n, true);
        }
        if (this.displayType == 1) {
            return this.paintTextOffscreen(graphics2D, n, true);
        }
        return this.paintGlyphsOffscreen(graphics2D, n, true);
    }

    public int paintRangeOffscreen(Graphics2D graphics2D, int n, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("Monospaced", 0, 12);
        char[] cArray = new char[1];
        int n2 = this.charBase;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.charHeight;
        int n6 = this.getHeaderLineHeight(graphics2D) * 4;
        int n7 = (this.pageImgHeight - n6 - this.charHeight) * n;
        int n8 = (this.pageImgHeight - n6 - this.charHeight) * (n + 1);
        boolean bl2 = false;
        graphics2D.setFont(font);
        int n9 = (int)graphics2D.getFont().getStringBounds("0000", fontRenderContext).getWidth() + this.charWidth;
        graphics2D.setFont(this.font);
        int n10 = 0;
        while (n10 < 16) {
            block10: {
                block11: {
                    block8: {
                        block9: {
                            if (!bl) break block8;
                            if (n5 >= n8) {
                                return 0;
                            }
                            if (n5 >= n7) break block9;
                            n5 += this.charHeight;
                            n2 += 16;
                            break block10;
                        }
                        if (!bl2) {
                            this.paintHeader(graphics2D, n);
                            n4 = n6 + this.charHeight;
                        } else {
                            n4 += this.charHeight;
                        }
                        bl2 = true;
                        break block11;
                    }
                    n4 = n5;
                }
                graphics2D.setFont(font);
                graphics2D.drawString(Integer.toHexString(n2), 10, n4);
                graphics2D.setFont(this.font);
                n3 = n9;
                int n11 = 0;
                while (n11 < 16) {
                    cArray[0] = (char)n2++;
                    if (graphics2D.getFont().canDisplay(cArray[0]) || bl) {
                        this.paintString(graphics2D, new String(cArray, 0, 1), n3, n4);
                    } else {
                        graphics2D.setColor(Color.red);
                        this.paintString(graphics2D, new String(cArray, 0, 1), n3, n4);
                        graphics2D.setColor(Color.black);
                    }
                    n3 += this.charWidth;
                    ++n11;
                }
                n5 += this.charHeight;
            }
            ++n10;
        }
        if (bl2) {
            return 0;
        }
        return 1;
    }

    public int paintTextOffscreen(Graphics2D graphics2D, int n, boolean bl) {
        int n2 = 0;
        int n3 = this.charHeight;
        int n4 = this.getHeaderLineHeight(graphics2D) * 4;
        int n5 = (this.pageImgHeight - n4 - this.charHeight) * n;
        int n6 = (this.pageImgHeight - n4 - this.charHeight) * (n + 1);
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < this.dispText.size()) {
            block7: {
                block8: {
                    block5: {
                        block6: {
                            if (!bl) break block5;
                            if (n3 >= n6) {
                                return 0;
                            }
                            if (n3 >= n5) break block6;
                            n3 += this.charHeight;
                            break block7;
                        }
                        if (!bl2) {
                            this.paintHeader(graphics2D, n);
                            n2 = n4 + this.charHeight;
                        } else {
                            n2 += this.charHeight;
                        }
                        bl2 = true;
                        break block8;
                    }
                    n2 = n3;
                }
                String string = (String)this.dispText.elementAt(n7);
                this.paintString(graphics2D, string, this.charWidth, n2);
                n3 += this.charHeight;
            }
            ++n7;
        }
        if (bl2) {
            return 0;
        }
        return 1;
    }

    public int paintGlyphsOffscreen(Graphics2D graphics2D, int n, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        int[] nArray = new int[1];
        int n2 = graphics2D.getFont().getNumGlyphs();
        int n3 = n2 % 16 == 0 ? n2 / 16 : n2 / 16 + 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.charHeight;
        int n7 = this.getHeaderLineHeight(graphics2D) * 4;
        int n8 = (this.pageImgHeight - n7 - this.charHeight) * n;
        int n9 = (this.pageImgHeight - n7 - this.charHeight) * (n + 1);
        Font font2 = new Font("Monospaced", 0, 12);
        boolean bl2 = false;
        graphics2D.setFont(font2);
        int n10 = (int)graphics2D.getFont().getStringBounds("0000", fontRenderContext).getWidth() + this.charWidth;
        graphics2D.setFont(font);
        int n11 = 0;
        while (n11 < n3) {
            block10: {
                block11: {
                    block8: {
                        block9: {
                            if (!bl) break block8;
                            if (n6 >= n9) {
                                return 0;
                            }
                            if (n6 >= n8) break block9;
                            n6 += this.charHeight;
                            break block10;
                        }
                        if (!bl2) {
                            this.paintHeader(graphics2D, n);
                            n5 = n7 + this.charHeight;
                        } else {
                            n5 += this.charHeight;
                        }
                        bl2 = true;
                        break block11;
                    }
                    n5 = n6;
                }
                graphics2D.setFont(font2);
                graphics2D.drawString(Integer.toHexString(n11 * 16), 10, n5);
                graphics2D.setFont(font);
                n4 = n10;
                int n12 = 0;
                while (n12 < 16) {
                    GlyphVector glyphVector;
                    if (n2 > n11 * 16 + n12) {
                        nArray[0] = n11 * 16 + n12;
                        glyphVector = font.createGlyphVector(fontRenderContext, nArray);
                        graphics2D.drawGlyphVector(glyphVector, n4, n5);
                    } else {
                        graphics2D.setColor(Color.red);
                        nArray[0] = font.getMissingGlyphCode();
                        glyphVector = font.createGlyphVector(fontRenderContext, nArray);
                        graphics2D.drawGlyphVector(glyphVector, n4, n5);
                        graphics2D.setColor(Color.black);
                    }
                    n4 += this.charWidth;
                    ++n12;
                }
                n6 += this.charHeight;
            }
            ++n11;
        }
        if (bl2) {
            return 0;
        }
        return 1;
    }

    protected int getHeaderLineHeight(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font("Monospaced", 0, 12));
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics2D.getFont().getMaxCharBounds(fontRenderContext);
        graphics2D.setFont(font);
        return (int)rectangle2D.getHeight() + 2;
    }

    public int paintHeader(Graphics2D graphics2D, int n) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font("Serif", 0, 12));
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics2D.getFont().getMaxCharBounds(fontRenderContext);
        int n2 = this.getHeaderLineHeight(graphics2D);
        String string = this.font2dtest.fontList.getSelectedItem();
        if (string.startsWith("*")) {
            string = string.substring(1, string.length());
        }
        String string2 = "Font: " + string + " (" + this.font2dtest.styleList.getSelectedItem() + " " + this.font2dtest.tfFontSize.getText() + ")";
        graphics2D.drawString(string2, 5, n2);
        string2 = "Properties: " + (this.font2dtest.cbAntialias.getState() ? "AAOn, " : "AAOff, ") + (this.font2dtest.cbFracMetrics.getState() ? "FMOn, " : "FMOff, ") + this.font2dtest.transformList.getSelectedItem();
        graphics2D.drawString(string2, 5, n2 * 2);
        string2 = "Description: " + this.font2dtest.methodList.getSelectedItem() + " of " + this.font2dtest.displayList.getSelectedItem();
        if (this.displayType == 0) {
            string2 = string2 + " for " + this.font2dtest.rangeList.getSelectedItem() + " (0x" + this.font2dtest.tfBaseText.getText() + ")";
        }
        graphics2D.drawString(string2, 5, n2 * 3);
        string2 = "Page: " + (n + 1);
        graphics2D.drawString(string2, 5, n2 * 4);
        graphics2D.setFont(font);
        return n2 * 4;
    }

    public void paintString(Graphics2D graphics2D, String string, int n, int n2) {
        int n3 = string.length();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        switch (this.drawMethod) {
            case 3: {
                GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(fontRenderContext, string);
                graphics2D.drawGlyphVector(glyphVector, n, n2);
                break;
            }
            case 1: {
                graphics2D.drawString(string, n, n2);
                break;
            }
            case 2: {
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                graphics2D.drawString(attributedCharacterIterator, n, n2);
                break;
            }
            case 0: {
                char[] cArray = new char[1024];
                if (n3 <= 0) break;
                string.getChars(0, n3, cArray, 0);
                graphics2D.drawChars(cArray, 0, n3, n, n2);
                break;
            }
            case 4: {
                if (n3 <= 0) break;
                byte[] byArray = string.getBytes();
                graphics2D.drawBytes(byArray, 0, n3, n, n2);
                break;
            }
            case 5: {
                TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
                textLayout.draw(graphics2D, n, n2);
                break;
            }
        }
    }
}

