/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.oneone;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.oneone.Html11Writer;
import java.io.IOException;
import java.util.List;

public class AbstractIndex11Writer
extends Html11Writer {
    protected IndexBuilder indexbuilder;

    protected AbstractIndex11Writer(String string, IndexBuilder indexBuilder) throws IOException {
        super(string);
        this.indexbuilder = indexBuilder;
    }

    protected void generateContents(Character c, List list) {
        this.anchor("_" + c + "_");
        this.h2();
        this.bold(c.toString());
        this.h2End();
        this.dl();
        int n = 0;
        while (n < list.size()) {
            Doc doc = (Doc)list.get(n);
            if (doc instanceof MemberDoc) {
                this.printDescription((MemberDoc)doc);
            } else if (doc instanceof PackageDoc) {
                this.printDescription((PackageDoc)doc);
            } else if (doc instanceof ClassDoc) {
                this.printDescription((ClassDoc)doc);
            }
            ++n;
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(PackageDoc packageDoc) {
        this.dt();
        this.printPackageLink(packageDoc);
        this.print(' ');
        this.print("package " + packageDoc.name());
        this.dd();
        this.print(this.firstSentence(packageDoc.commentText()));
    }

    protected void printDescription(ClassDoc classDoc) {
        this.dt();
        this.printClassLink(classDoc);
        this.print(' ');
        this.printClassInfo(classDoc);
        this.dd();
        this.print(this.firstSentence(classDoc.commentText()));
    }

    protected void printClassInfo(ClassDoc classDoc) {
        if (classDoc.isOrdinaryClass()) {
            this.printText("doclet.class");
        } else if (classDoc.isInterface()) {
            this.printText("doclet.interface");
        } else if (classDoc.isException()) {
            this.printText("doclet.exception");
        } else {
            this.printText("doclet.error");
        }
        this.print(' ');
        this.printPreQualifiedClassLink(classDoc);
        this.print('.');
    }

    protected void printDescription(MemberDoc memberDoc) {
        String string = memberDoc.name();
        ClassDoc classDoc = memberDoc.containingClass();
        String string2 = classDoc.qualifiedName();
        String string3 = classDoc.name();
        this.dt();
        this.printDocLink(memberDoc, string);
        if (memberDoc instanceof ExecutableMemberDoc) {
            this.print(((ExecutableMemberDoc)memberDoc).flatSignature());
        }
        this.println('.');
        this.printMemberDesc(memberDoc);
        this.print(' ');
        this.printText(classDoc.isInterface() ? "doclet.interface" : "doclet.class");
        this.print(" ");
        this.printPreQualifiedClassLink(classDoc);
        this.println();
        this.dd();
        this.print(this.firstSentence(memberDoc.commentText()));
        this.println();
    }

    protected void printMemberDesc(MemberDoc memberDoc) {
        if (memberDoc.isField()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_variable_in");
            } else {
                this.printText("doclet.Variable_in");
            }
        } else if (memberDoc.isConstructor()) {
            this.printText("doclet.Constructor_for");
        } else if (memberDoc.isMethod()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_method_in");
            } else {
                this.printText("doclet.Method_in");
            }
        }
    }

    protected void nav11LinkTree() {
        this.printHyperLink("tree.html", this.getText("doclet.Class_Hierarchy"));
    }

    protected void nav11LinkContents() {
        this.printHyperLink("packages.html", this.getText("doclet.All_Packages"));
        this.doubleSpace();
    }

    protected void nav11LinkIndex() {
    }

    protected void nav11LinkHelp() {
    }

    protected void nav11LinkPackage() {
    }

    protected void nav11LinkPrevious() {
    }

    protected void nav11LinkNext() {
    }
}

