/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;

public class LocationImpl
extends MirrorImpl
implements Location {
    private ReferenceType declaringType;
    private Method method;
    private long methodRef;
    private long codeIndex;
    private int lineNumber;
    private boolean triedLineNumber = false;

    LocationImpl(VirtualMachine virtualMachine, Method method, long l) {
        this(virtualMachine, method, l, -1);
    }

    LocationImpl(VirtualMachine virtualMachine, Method method, long l, int n) {
        super(virtualMachine);
        this.method = method;
        this.codeIndex = l;
        this.lineNumber = n;
        this.declaringType = method.declaringType();
    }

    LocationImpl(VirtualMachine virtualMachine, ReferenceType referenceType, long l, long l2) {
        super(virtualMachine);
        this.method = null;
        this.codeIndex = l2;
        this.lineNumber = -1;
        this.declaringType = referenceType;
        this.methodRef = l;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Location) {
            Location location = (Location)object;
            return this.method().equals(location.method()) && this.codeIndex() == location.codeIndex() && this.declaringType().equals(location.declaringType()) && this.lineNumber() == location.lineNumber() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.method().hashCode() + (int)this.codeIndex();
    }

    public int compareTo(Object object) {
        LocationImpl locationImpl = (LocationImpl)object;
        int n = this.method().compareTo(locationImpl.method());
        if (n == 0) {
            long l = this.codeIndex() - locationImpl.codeIndex();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
        return n;
    }

    public ReferenceType declaringType() {
        return this.declaringType;
    }

    public Method method() {
        if (this.method == null) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
            this.method = referenceTypeImpl.getMethodMirror(this.methodRef);
        }
        return this.method;
    }

    public long codeIndex() {
        return this.codeIndex;
    }

    public String sourceName() throws AbsentInformationException {
        return ((ReferenceTypeImpl)this.declaringType()).sourceName();
    }

    public int lineNumber() {
        if (this.lineNumber == -1 && !this.triedLineNumber) {
            MethodImpl methodImpl = (MethodImpl)this.method();
            this.lineNumber = methodImpl.codeIndexToLineNumber(this.codeIndex());
            this.triedLineNumber = true;
        }
        return this.lineNumber;
    }

    public String toString() {
        if (this.lineNumber == -1) {
            return this.method().toString() + "+" + this.codeIndex();
        }
        return this.declaringType().name() + ":" + this.lineNumber();
    }
}

