/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectReferenceImpl
extends ValueImpl
implements ObjectReference,
VMListener {
    protected long ref;
    private ReferenceType type = null;
    private int gcDisableCount = 0;
    boolean addedListener = false;
    private static final Cache noInitCache = new Cache();
    private static final Cache markerCache = new Cache();
    private Cache cache = noInitCache;

    private void disableCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.cache = null;
        }
    }

    private void enableCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.cache = markerCache;
        }
    }

    protected Cache newCache() {
        return new Cache();
    }

    protected Cache getCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.cache == noInitCache) {
                if (this.vm.state().isSuspended()) {
                    this.enableCache();
                } else {
                    this.disableCache();
                }
            }
            if (this.cache == markerCache) {
                this.cache = this.newCache();
            }
            Cache cache = this.cache;
            return cache;
        }
    }

    ObjectReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine);
        this.ref = l;
    }

    protected String description() {
        return "ObjectReference " + this.uniqueID();
    }

    public boolean vmSuspended(VMAction vMAction) {
        this.enableCache();
        return true;
    }

    public boolean vmNotSuspended(VMAction vMAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.cache != null) {
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace("Clearing temporary cache for " + this.description());
                }
            }
            this.disableCache();
            if (this.addedListener) {
                this.addedListener = false;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ObjectReferenceImpl) {
            ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)object;
            return this.ref() == objectReferenceImpl.ref() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.ref();
    }

    public Type type() {
        return this.referenceType();
    }

    public ReferenceType referenceType() {
        if (this.type == null) {
            try {
                JDWP.ObjectReference.ReferenceType referenceType = JDWP.ObjectReference.ReferenceType.process(this.vm, this);
                this.type = this.vm.referenceType(referenceType.typeID, referenceType.refTypeTag);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.type;
    }

    public Value getValue(Field field) {
        ArrayList<Field> arrayList = new ArrayList<Field>(1);
        arrayList.add(field);
        Map map = this.getValues(arrayList);
        return (Value)map.get(field);
    }

    public Map getValues(List list) {
        ValueImpl[] valueImplArray;
        Map<FieldImpl, ValueImpl> map;
        this.validateMirrors(list);
        ArrayList arrayList = new ArrayList(0);
        int n = list.size();
        ArrayList arrayList2 = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            map = (Field)list.get(n2);
            ((ReferenceTypeImpl)this.referenceType()).validateFieldAccess((Field)((Object)map));
            if (map.isStatic()) {
                arrayList.add(map);
            } else {
                arrayList2.add(map);
            }
            ++n2;
        }
        map = arrayList.size() > 0 ? this.referenceType().getValues(arrayList) : new HashMap<FieldImpl, ValueImpl>(n);
        n = arrayList2.size();
        JDWP.ObjectReference.GetValues.Field[] fieldArray = new JDWP.ObjectReference.GetValues.Field[n];
        int n3 = 0;
        while (n3 < n) {
            valueImplArray = (ValueImpl[])arrayList2.get(n3);
            fieldArray[n3] = new JDWP.ObjectReference.GetValues.Field(valueImplArray.ref());
            ++n3;
        }
        try {
            valueImplArray = JDWP.ObjectReference.GetValues.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this, (JDWP.ObjectReference.GetValues.Field[])fieldArray).values;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        if (n != valueImplArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int n4 = 0;
        while (n4 < n) {
            FieldImpl fieldImpl = (FieldImpl)arrayList2.get(n4);
            map.put(fieldImpl, valueImplArray[n4]);
            ++n4;
        }
        return map;
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block6: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            ((ReferenceTypeImpl)this.referenceType()).validateFieldSet(field);
            if (field.isStatic()) {
                ReferenceType referenceType = this.referenceType();
                if (referenceType instanceof ClassType) {
                    ((ClassType)referenceType).setValue(field, value);
                    return;
                }
                throw new IllegalArgumentException("Invalid type for static field set");
            }
            try {
                JDWP.ObjectReference.SetValues.FieldValue[] fieldValueArray = new JDWP.ObjectReference.SetValues.FieldValue[]{new JDWP.ObjectReference.SetValues.FieldValue(((FieldImpl)field).ref(), ValueImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ObjectReference.SetValues.process(this.vm, this, fieldValueArray);
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (value == null) break block6;
                throw classNotLoadedException;
            }
        }
    }

    void validateMethodInvocation(Method method, List list, int n) throws InvalidTypeException, InvocationException {
        Object object;
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)method.declaringType();
        if (!referenceTypeImpl.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid method");
        }
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.referenceType();
        if (method.isConstructor()) {
            throw new IllegalArgumentException("Cannot invoke constructor");
        }
        if ((n & 2) != 0) {
            if (method.declaringType() instanceof InterfaceType) {
                throw new IllegalArgumentException("Interface method");
            }
            if (method.isAbstract()) {
                throw new IllegalArgumentException("Abstract method");
            }
        }
        if ((n & 2) != 0) {
            ClassTypeImpl classTypeImpl2 = classTypeImpl;
        } else {
            object = classTypeImpl.concreteMethodByName(method.name(), method.signature());
            ClassTypeImpl classTypeImpl3 = (ClassTypeImpl)object.declaringType();
        }
        object = new JNITypeParser(method.signature());
        List list2 = ((JNITypeParser)object).argumentSignatures();
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("Invalid argument count");
        }
    }

    PacketStream sendInvokeCommand(final ThreadReferenceImpl threadReferenceImpl, final ClassTypeImpl classTypeImpl, final MethodImpl methodImpl, final ValueImpl[] valueImplArray, final int n) {
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.ObjectReference.InvokeMethod.enqueueCommand(ObjectReferenceImpl.this.vm, ObjectReferenceImpl.this, threadReferenceImpl, classTypeImpl, methodImpl.ref(), valueImplArray, n);
            }
        };
        PacketStream packetStream = (n & 1) != 0 ? threadReferenceImpl.sendResumingCommand(commandSender) : this.vm.sendResumingCommand(commandSender);
        return packetStream;
    }

    public Value invokeMethod(ThreadReference threadReference, Method method, List list, int n) throws InvalidTypeException, IncompatibleThreadStateException, InvocationException, ClassNotLoadedException {
        JDWP.ObjectReference.InvokeMethod invokeMethod;
        this.validateMirror(threadReference);
        this.validateMirror(method);
        this.validateMirrorsOrNulls(list);
        MethodImpl methodImpl = (MethodImpl)method;
        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)threadReference;
        if (methodImpl.isStatic()) {
            if (this.referenceType() instanceof ClassType) {
                ClassType classType = (ClassType)this.referenceType();
                return classType.invokeMethod(threadReferenceImpl, methodImpl, list, n);
            }
            throw new IllegalArgumentException("Invalid type for static method invocation");
        }
        this.validateMethodInvocation(methodImpl, list, n);
        methodImpl.prepareArgumentsForInvoke(list);
        ValueImpl[] valueImplArray = list.toArray(new ValueImpl[0]);
        try {
            PacketStream packetStream = this.sendInvokeCommand(threadReferenceImpl, (ClassTypeImpl)this.referenceType(), methodImpl, valueImplArray, n);
            invokeMethod = JDWP.ObjectReference.InvokeMethod.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        if ((n & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (invokeMethod.exception != null) {
            throw new InvocationException(invokeMethod.exception);
        }
        return invokeMethod.returnValue;
    }

    public synchronized void disableCollection() {
        if (this.gcDisableCount == 0) {
            try {
                JDWP.ObjectReference.DisableCollection.process(this.vm, this);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        ++this.gcDisableCount;
    }

    public synchronized void enableCollection() {
        --this.gcDisableCount;
        if (this.gcDisableCount == 0) {
            try {
                JDWP.ObjectReference.EnableCollection.process(this.vm, this);
            }
            catch (JDWPException jDWPException) {
                if (jDWPException.errorCode() != 20) {
                    throw jDWPException.toJDIException();
                }
                return;
            }
        }
    }

    public boolean isCollected() {
        try {
            return JDWP.ObjectReference.IsCollected.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this).isCollected;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public long uniqueID() {
        return this.ref();
    }

    JDWP.ObjectReference.MonitorInfo jdwpMonitorInfo() throws IncompatibleThreadStateException {
        JDWP.ObjectReference.MonitorInfo monitorInfo = null;
        try {
            Cache cache;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                cache = this.getCache();
                if (cache != null && (monitorInfo = cache.monitorInfo) == null && !this.vm.state().hasListener(this)) {
                    this.vm.state().addListener(this);
                    this.addedListener = true;
                }
            }
            if (monitorInfo == null) {
                monitorInfo = JDWP.ObjectReference.MonitorInfo.process(this.vm, this);
                if (cache != null) {
                    cache.monitorInfo = monitorInfo;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("ObjectReference " + this.uniqueID() + " temporarily caching monitor info");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 13) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        return monitorInfo;
    }

    public List waitingThreads() throws IncompatibleThreadStateException {
        return Arrays.asList(this.jdwpMonitorInfo().waiters);
    }

    public ThreadReference owningThread() throws IncompatibleThreadStateException {
        return this.jdwpMonitorInfo().owner;
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.jdwpMonitorInfo().entryCount;
    }

    long ref() {
        return this.ref;
    }

    boolean isClassObject() {
        return this.referenceType().name().equals("java.lang.Class");
    }

    ValueImpl prepareForAssignmentTo(ValueContainer valueContainer) throws InvalidTypeException, ClassNotLoadedException {
        this.validateAssignment(valueContainer);
        return this;
    }

    void validateAssignment(ValueContainer valueContainer) throws InvalidTypeException, ClassNotLoadedException {
        if (valueContainer.signature().length() == 1) {
            throw new InvalidTypeException("Can't assign object value to primitive");
        }
        if (valueContainer.signature().charAt(0) == '[' && this.type().signature().charAt(0) != '[') {
            throw new InvalidTypeException("Can't assign non-array value to an array");
        }
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)valueContainer.type();
        ReferenceTypeImpl referenceTypeImpl2 = (ReferenceTypeImpl)this.referenceType();
        if (!referenceTypeImpl2.isAssignableTo(referenceTypeImpl)) {
            JNITypeParser jNITypeParser = new JNITypeParser(referenceTypeImpl.signature());
            String string = jNITypeParser.typeName();
            throw new InvalidTypeException("Can't assign " + this.type().name() + " to " + string);
        }
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 76;
    }

    protected static class Cache {
        JDWP.ObjectReference.MonitorInfo monitorInfo = null;

        protected Cache() {
        }
    }
}

