/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractPlayer;
import com.sun.media.sound.Printer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

class MixerSequencer
extends AbstractPlayer
implements Sequencer {
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    static final MixerSequencerInfo info = new MixerSequencerInfo();
    private static Sequencer.SyncMode[] masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static Sequencer.SyncMode[] slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private static Sequencer.SyncMode masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
    private static Sequencer.SyncMode slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    private long timeStamp = -1L;
    private Sequence sequence = null;
    private byte[] midiData = null;
    private boolean runningInEngine = false;
    private boolean newSequenceStarted = false;
    private long tick = -1L;
    private float tempoInBPM = -1.0f;
    private float tempoInMPQ = -1.0f;
    private boolean running = false;
    private boolean recording = false;
    private boolean sequenceChanged = false;
    private long startTime = 0L;
    private long startMillisecondTime = 0L;
    private long lastTempoChangeTime = 0L;
    private long lastTempoChangeTick = 0L;
    private long recordTempoInMPQ = 500000L;
    private long startTick = 0L;
    private float divisionType = 0.0f;
    private int resolution = 0;
    private SequencerReceiver sequencerReceiver = null;
    private Vector recordingTracks = new Vector();
    private Vector metaEventListeners = new Vector();
    private Vector controllerEventListeners = new Vector();

    protected MixerSequencer() throws MidiUnavailableException {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer CONSTRUCTOR completed");
        }
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setSequence(" + sequence + ")");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        int[] nArray = MidiSystem.getMidiFileTypes(sequence);
        if (nArray.length == 0) {
            throw new InvalidMidiDataException("Unsupported sequence: " + sequence);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MidiSystem.write(sequence, nArray[0], byteArrayOutputStream);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Unable to get file stream from sequence: " + sequence);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.setSequence(byteArrayInputStream);
            this.sequence = sequence;
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Failed to load sequence: " + sequence);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: setSequence(" + sequence + ") completed");
        }
    }

    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setSequence(" + inputStream + ")");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(inputStream);
        int n = midiFileFormat.getType();
        if (n == 2) {
            throw new InvalidMidiDataException("Unsupported file type: " + n + ". Only type 0 and type 1 MIDI files are supported.");
        }
        if (this.id != 0) {
            this.stop();
            this.implClose();
            try {
                this.implOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        this.midiData = this.getBytesFromFileStream(inputStream, midiFileFormat);
        if (this.midiData == null || this.midiData.length == 0) {
            throw new IOException("Failed to read data from stream.");
        }
        if (n == 0 || n == 1) {
            this.id = this.nOpenMidiSequencer(this.midiData, this.midiData.length);
            if (this.id == 0) {
                this.id = this.nOpenRmfSequencer(this.midiData, this.midiData.length);
            }
        }
        if (this.id == 0) {
            throw new InvalidMidiDataException("Failed to load sequence");
        }
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.channels[n2].setId(this.id);
            ++n2;
        }
        this.connectToInternalSynth();
        n2 = 0;
        while (n2 < this.controllerEventListeners.size()) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n2);
            int n3 = 0;
            while (n3 < controllerVectorElement.controllers.length) {
                this.nAddControllerEventCallback(this.id, controllerVectorElement.controllers[n3]);
                ++n3;
            }
            ++n2;
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: setSequence(" + inputStream + ") completed");
        }
    }

    public Sequence getSequence() {
        if (this.sequence == null && this.midiData != null && this.midiData.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.midiData);
            try {
                this.sequence = MidiSystem.getSequence(byteArrayInputStream);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sequence;
    }

    public synchronized void start() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: start()");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.id == 0) {
            return;
        }
        if (this.running) {
            return;
        }
        if (this.sequenceChanged) {
            try {
                this.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            this.sequenceChanged = false;
        }
        this.running = true;
        if (!this.newSequenceStarted) {
            this.nStartSequencer(this.id);
            this.newSequenceStarted = true;
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            }
            if (this.tempoInBPM != -1.0f) {
                this.setTempoInBPM(this.tempoInBPM);
            }
            if (this.tempoInMPQ != -1.0f) {
                this.setTempoInMPQ(this.tempoInMPQ);
            }
        } else {
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            } else if (!this.runningInEngine) {
                this.setMicrosecondPosition(0L);
            }
            this.nResumeSequencer(this.id);
        }
        this.runningInEngine = true;
        this.callbackSongStart();
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: start() completed");
        }
    }

    public synchronized void stop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: stop()");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.stopRecording();
        if (this.id == 0) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.implStop();
        this.callbackSongStop();
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: stop() completed");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = true;
        this.divisionType = this.sequence.getDivisionType();
        this.resolution = this.sequence.getResolution();
        this.startTime = System.currentTimeMillis();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
        this.startTick = 0L;
        this.lastTempoChangeTime = 0L;
        this.lastTempoChangeTick = this.startTick;
        this.recordTempoInMPQ = (long)this.getTempoInMPQ();
        this.start();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.recording) {
            this.sequenceChanged = true;
        }
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void recordEnable(Track track, int n) {
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                recordingTrack.channel = n;
            } else {
                this.recordingTracks.addElement(new RecordingTrack(track, n));
            }
        }
    }

    public void recordDisable(Track track) {
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                this.recordingTracks.removeElement(recordingTrack);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean bl = false;
        if (this.sequence != null) {
            Track[] trackArray = this.sequence.getTracks();
            int n = 0;
            while (n < trackArray.length) {
                if (track == trackArray[n]) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public float getTempoInBPM() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoInBPM() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInBPM != -1.0f) {
            return this.tempoInBPM;
        }
        return this.nGetTempoInBPM(this.id);
    }

    public void setTempoInBPM(float f) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoInBPM() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInBPM = f;
            this.tempoInMPQ = 6.0E7f / f;
        } else {
            this.nSetTempoInBPM(this.id, (int)f);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public float getTempoInMPQ() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoInMPQ() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInMPQ != -1.0f) {
            return this.tempoInMPQ;
        }
        return this.nGetTempoInMPQ(this.id);
    }

    public void setTempoInMPQ(float f) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoInMPQ() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInMPQ = f;
            this.tempoInBPM = 6.0E7f / f;
        } else {
            this.nSetTempoInMPQ(this.id, (int)f);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public void setTempoFactor(float f) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTempoFactor() ");
        }
        if (this.id == 0) {
            return;
        }
        this.nSetMasterTempo(this.id, f);
    }

    public float getTempoFactor() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTempoFactor() ");
        }
        if (this.id == 0) {
            return 0.0f;
        }
        return this.nGetMasterTempo(this.id);
    }

    public long getTickLength() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTickLength() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequenceTickLength(this.id);
    }

    public synchronized long getTickPosition() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getTickPosition() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequencerTickPosition(this.id) / 64L;
    }

    public synchronized void setTickPosition(long l) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setTickPosition() ");
        }
        if (this.id == 0) {
            return;
        }
        if (!this.running) {
            this.tick = l * 64L;
        } else {
            this.nSetSequencerTickPosition(this.id, l * 64L);
            this.tick = -1L;
        }
    }

    public long getMicrosecondLength() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getMicrosecondLength() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequenceMicrosecondLength(this.id);
    }

    public long getMicrosecondPosition() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: getMicrosecondPosition() ");
        }
        if (this.id == 0) {
            return 0L;
        }
        return this.nGetSequencerMicrosecondPosition(this.id);
    }

    public void setMicrosecondPosition(long l) {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: setMicrosecondPosition() ");
        }
        if (this.id == 0) {
            return;
        }
        this.nSetSequencerMicrosecondPosition(this.id, l);
        this.tick = -1L;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    public void setTrackMute(int n, boolean bl) {
        if (this.id == 0) {
            return;
        }
        this.nSetTrackMute(this.id, n, bl);
    }

    public boolean getTrackMute(int n) {
        if (this.id == 0) {
            return false;
        }
        return this.nGetTrackMute(this.id, n);
    }

    public void setTrackSolo(int n, boolean bl) {
        if (this.id == 0) {
            return;
        }
        this.nSetTrackSolo(this.id, n, bl);
    }

    public boolean getTrackSolo(int n) {
        if (this.id == 0) {
            return false;
        }
        return this.nGetTrackSolo(this.id, n);
    }

    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.addElement(metaEventListener);
            }
            boolean bl = true;
            return bl;
        }
    }

    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            this.metaEventListeners.removeElement(metaEventListener);
        }
    }

    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            int n = 0;
            while (n < this.controllerEventListeners.size()) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
                if (controllerVectorElement.listener.equals(controllerEventListener)) {
                    controllerVectorElement.addControllers(nArray);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                controllerVectorElement = new ControllerVectorElement(controllerEventListener, nArray);
                this.controllerEventListeners.addElement(controllerVectorElement);
            }
            if (this.id != 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.nAddControllerEventCallback(this.id, nArray[n2]);
                    ++n2;
                }
            }
            int[] nArray2 = controllerVectorElement.getControllers();
            return nArray2;
        }
    }

    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            int n = 0;
            while (n < this.controllerEventListeners.size()) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
                if (controllerVectorElement.listener.equals(controllerEventListener)) {
                    controllerVectorElement.removeControllers(nArray);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                int[] nArray2 = new int[]{};
                return nArray2;
            }
            if (nArray == null) {
                this.controllerEventListeners.removeElement(controllerVectorElement);
                int[] nArray3 = new int[]{};
                return nArray3;
            }
            int[] nArray4 = controllerVectorElement.getControllers();
            return nArray4;
        }
    }

    public long getTimeStamp() {
        return this.getMicrosecondPosition();
    }

    public void setTimeStamp(long l) {
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        if (this.sequencerReceiver == null) {
            this.sequencerReceiver = new SequencerReceiver();
        }
        return this.sequencerReceiver;
    }

    public synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: implClose() ");
        }
        this.implStop();
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.newSequenceStarted = false;
        while (this.runningInEngine) {
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: implClose() completed");
        }
    }

    public void implOpen() throws MidiUnavailableException {
        this.openInternalSynth();
    }

    protected void implStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSequencer: implStop()");
        }
        this.nPauseSequencer(this.id);
        this.running = false;
    }

    protected void sendMetaEvents(MetaMessage metaMessage) {
        if (Printer.debug) {
            Printer.debug("sending a meta event");
        }
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(metaMessage, this.metaEventListeners);
    }

    protected void sendControllerEvents(ShortMessage shortMessage, int n) {
        if (Printer.debug) {
            Printer.debug("sending a controller event");
        }
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.controllerEventListeners.size()) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n2);
            int n3 = 0;
            while (n3 < controllerVectorElement.controllers.length) {
                if (controllerVectorElement.controllers[n3] == n) {
                    vector.addElement(controllerVectorElement.listener);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(shortMessage, vector);
    }

    private long calculateTickPosition(long l) {
        if (this.divisionType == 0.0f) {
            long l2 = l - this.lastTempoChangeTime;
            long l3 = l2 >= 0L ? this.lastTempoChangeTick + l2 * (long)this.resolution * 1000L / this.recordTempoInMPQ : l * (long)this.resolution * 1000L / this.recordTempoInMPQ;
            return l3;
        }
        return (long)((float)l * this.divisionType * (float)this.resolution / 1000.0f);
    }

    protected byte[] getBytesFromFileStream(InputStream inputStream, MidiFileFormat midiFileFormat) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            throw new IOException("Stream is null");
        }
        long l = midiFileFormat.getByteLength();
        if (l != -1L) {
            byArray = new byte[(int)l];
            if ((long)inputStream.read(byArray) != l) {
                throw new IOException("Read failure: expected " + l + " bytes");
            }
        } else {
            int n = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n2 = n;
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n4 = inputStream.read(byArray2, 0, n2)) == -1) {
                    if (n3 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n4);
                n3 += n4;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private synchronized void callbackSongEnd() {
        MetaMessage metaMessage;
        block8: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackSongEnd()");
            }
            this.implStop();
            this.runningInEngine = false;
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                this.notifyAll();
            }
            metaMessage = new MetaMessage();
            try {
                metaMessage.setMessage(47, new byte[0], 0);
                if (Printer.debug) {
                    Printer.debug("new meta message: " + metaMessage);
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!Printer.debug) break block8;
                Printer.debug("invalid midi data: " + invalidMidiDataException);
            }
        }
        this.sendMetaEvents(metaMessage);
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackSongEnd completed()");
        }
    }

    private void callbackSongStart() {
        if (Printer.trace) {
            Printer.trace("MixerSequencer: callbackSongStart()");
        }
    }

    private void callbackSongStop() {
        if (Printer.trace) {
            Printer.trace("MixerSequencer: callbackSongStop()");
        }
    }

    private void callbackMetaEvent(int n, int n2, int n3, byte[] byArray) {
        block6: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackMetaEvent()");
            }
            if (Printer.debug) {
                Printer.debug("    type = " + n + ", msgLength = " + n2 + ", channel = " + n3);
            }
            MetaMessage metaMessage = new MetaMessage();
            try {
                metaMessage.setMessage(n, byArray, n2);
                if (Printer.debug) {
                    Printer.debug("new meta message: " + metaMessage);
                }
                this.sendMetaEvents(metaMessage);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!Printer.debug) break block6;
                Printer.debug("invalid midi data: " + invalidMidiDataException);
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackMetaEvent() completed");
        }
    }

    private void callbackControllerEvent(int n, int n2, int n3, int n4) {
        block4: {
            if (Printer.trace) {
                Printer.trace(">> MixerSequencer: callbackControllerEvent()");
            }
            ShortMessage shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(176 + n, n3, n4);
                this.sendControllerEvents(shortMessage, n3);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!Printer.debug) break block4;
                Printer.debug("invalid midi data: " + invalidMidiDataException);
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSequencer: callbackControllerEvent() completed");
        }
    }

    protected native int nOpenMidiSequencer(byte[] var1, int var2);

    protected native int nOpenRmfSequencer(byte[] var1, int var2);

    protected native void nStartSequencer(int var1);

    protected native void nPauseSequencer(int var1);

    protected native void nResumeSequencer(int var1);

    protected native void nAddControllerEventCallback(int var1, int var2);

    protected native long nGetSequencerTickPosition(int var1);

    protected native long nSetSequencerTickPosition(int var1, long var2);

    protected native long nGetSequencerMicrosecondPosition(int var1);

    protected native long nSetSequencerMicrosecondPosition(int var1, long var2);

    protected native int nGetTempoInBPM(int var1);

    protected native int nSetTempoInBPM(int var1, int var2);

    protected native int nGetTempoInMPQ(int var1);

    protected native int nSetTempoInMPQ(int var1, int var2);

    protected native float nGetMasterTempo(int var1);

    protected native float nSetMasterTempo(int var1, float var2);

    protected native void nSetTrackMute(int var1, int var2, boolean var3);

    protected native boolean nGetTrackMute(int var1, int var2);

    protected native void nSetTrackSolo(int var1, int var2, boolean var3);

    protected native boolean nGetTrackSolo(int var1, int var2);

    protected native long nGetSequenceTickLength(int var1);

    protected native long nGetSequenceMicrosecondLength(int var1);

    static class RecordingTrack {
        Track track;
        int channel;

        RecordingTrack(Track track, int n) {
            this.track = track;
            this.channel = n;
        }

        static RecordingTrack get(Vector vector, Track track) {
            Vector vector2 = vector;
            synchronized (vector2) {
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(n2);
                    if (recordingTrack.track == track) {
                        RecordingTrack recordingTrack2 = recordingTrack;
                        return recordingTrack2;
                    }
                    ++n2;
                }
            }
            return null;
        }

        static Vector get(Vector vector, int n) {
            Vector vector2 = new Vector();
            Vector vector3 = vector;
            synchronized (vector3) {
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(n3);
                    if (recordingTrack.channel == n || recordingTrack.channel == -1) {
                        vector2.addElement(recordingTrack.track);
                    }
                    ++n3;
                }
            }
            return vector2;
        }
    }

    private class ControllerVectorElement {
        int[] controllers;
        ControllerEventListener listener;

        private ControllerVectorElement(ControllerEventListener controllerEventListener, int[] nArray) {
            this.listener = controllerEventListener;
            this.controllers = nArray;
        }

        private void addControllers(int[] nArray) {
            int n;
            if (nArray == null) {
                return;
            }
            int[] nArray2 = new int[this.controllers.length + nArray.length];
            int n2 = 0;
            while (n2 < this.controllers.length) {
                nArray2[n2] = this.controllers[n2];
                ++n2;
            }
            int n3 = this.controllers.length;
            int n4 = 0;
            while (n4 < nArray.length) {
                boolean bl = false;
                n = 0;
                while (n < this.controllers.length) {
                    if (nArray[n4] == this.controllers[n]) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    nArray2[n3++] = nArray[n4];
                }
                ++n4;
            }
            int[] nArray3 = new int[n3];
            n = 0;
            while (n < n3) {
                nArray3[n] = nArray2[n];
                ++n;
            }
            this.controllers = nArray3;
        }

        private void removeControllers(int[] nArray) {
            if (nArray == null) {
                this.controllers = new int[0];
            } else {
                int n;
                int[] nArray2 = new int[this.controllers.length];
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.controllers.length) {
                    boolean bl = false;
                    n = 0;
                    while (n < nArray.length) {
                        if (this.controllers[n3] == nArray[n]) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        nArray2[n2++] = this.controllers[n3];
                    }
                    ++n3;
                }
                int[] nArray3 = new int[n2];
                n = 0;
                while (n < n2) {
                    nArray3[n] = nArray2[n];
                    ++n;
                }
                this.controllers = nArray3;
            }
        }

        private int[] getControllers() {
            int[] nArray = new int[this.controllers.length];
            int n = 0;
            while (n < this.controllers.length) {
                nArray[n] = this.controllers[n];
                ++n;
            }
            return nArray;
        }
    }

    private static class MixerSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer / synthesizer module";
        private static final String version = "Version 1.0";

        private MixerSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    class SequencerReceiver
    extends AbstractPlayer.PlayerReceiver {
        SequencerReceiver() {
        }

        public void send(MidiMessage midiMessage, long l) {
            super.send(midiMessage, l);
            if (MixerSequencer.this.recording) {
                Vector vector = null;
                long l2 = l < 0L ? (MixerSequencer.this.running ? MixerSequencer.this.calculateTickPosition(MixerSequencer.this.getMicrosecondPosition() / 1000L) : MixerSequencer.this.calculateTickPosition(MixerSequencer.this.startMillisecondTime + (System.currentTimeMillis() - MixerSequencer.this.startTime))) : MixerSequencer.this.calculateTickPosition(l);
                MidiEvent midiEvent = new MidiEvent(midiMessage, l2);
                vector = midiMessage instanceof ShortMessage ? RecordingTrack.get(MixerSequencer.this.recordingTracks, ((ShortMessage)midiMessage).getChannel()) : RecordingTrack.get(MixerSequencer.this.recordingTracks, 0);
                int n = 0;
                while (n < vector.size()) {
                    ((Track)vector.elementAt(n)).add(midiEvent);
                    ++n;
                }
            }
        }
    }
}

