/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.awt.motif.AWTLockAccess;
import sun.awt.motif.MDataTransferer;

final class MDropTargetContextPeer
extends SunDropTargetContextPeer {
    private long nativeDropTransfer;
    int nativeDataAvailable = 0;
    Object nativeData = null;

    static MDropTargetContextPeer createMDropTargetContextPeer() {
        return new MDropTargetContextPeer();
    }

    private MDropTargetContextPeer() {
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.local != null) {
            return this.local.getTransferDataFlavors();
        }
        Object object = this.lock;
        synchronized (object) {
            DataFlavor[] dataFlavorArray = MDataTransferer.getInstance().getFlavorsForFormatsAsArray(this.currentT, this.currentDT.getFlavorMap());
            return dataFlavorArray;
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (this.local != null) {
            return this.local.isDataFlavorSupported(dataFlavor);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = MDataTransferer.getInstance().getFlavorsForFormats(this.currentT, this.currentDT.getFlavorMap()).containsKey(dataFlavor);
            return bl;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        if (this.local != null) {
            return this.local.getTransferData(dataFlavor);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 2 || this.dropComplete) {
                throw new InvalidDnDOperationException("No drop current");
            }
            Map map = MDataTransferer.getInstance().getFlavorsForFormats(this.currentT, this.currentDT.getFlavorMap());
            Integer n = (Integer)map.get(dataFlavor);
            if (n == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            int n2 = n;
            if (dataFlavor.isRepresentationClassRemote() && this.currentDA != 0x40000000) {
                throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer of java.rmi.Remote objects");
            }
            if (this.nativeDropTransfer == 0L) {
                this.nativeDropTransfer = this.startTransfer(this.nativeDragContext, n2);
            } else {
                this.addTransfer(this.nativeDropTransfer, n2);
            }
            this.nativeDataAvailable = 0;
            while (n2 != this.nativeDataAvailable) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.nativeData == null) {
                throw new IOException("no native data was transferred");
            }
            if (this.nativeData instanceof byte[]) {
                try {
                    Object object2 = MDataTransferer.getInstance().translateBytes((byte[])this.nativeData, dataFlavor, n2);
                    return object2;
                }
                catch (IOException iOException) {
                    throw new InvalidDnDOperationException(iOException.getMessage());
                }
            }
            if (this.nativeData instanceof InputStream) {
                try {
                    Object object3 = MDataTransferer.getInstance().translateStream((InputStream)this.nativeData, dataFlavor, n2);
                    return object3;
                }
                catch (IOException iOException) {
                    throw new InvalidDnDOperationException(iOException.getMessage());
                }
            }
            throw new IOException("no native data was transfered");
        }
    }

    public void dropComplete(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentT = null;
            this.currentA = 0;
            Object object2 = SunDropTargetContextPeer._globalLock;
            synchronized (object2) {
                SunDropTargetContextPeer.currentJVMLocalSourceTransferable = null;
            }
            this.dropStatus = 0;
            this.dropComplete = true;
        }
        this.dropDone(this.nativeDragContext, this.nativeDropTransfer, this.local != null, bl, this.currentDA);
        this.currentDA = 0;
        this.nativeDragContext = 0L;
    }

    private void newData(int n, String string, byte[] byArray) {
        Object object = this.lock;
        synchronized (object) {
            this.nativeDataAvailable = n;
            this.nativeData = byArray;
            this.lock.notify();
        }
    }

    private void transferFailed(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.nativeDataAvailable = n;
            this.nativeData = null;
            this.lock.notify();
        }
    }

    private native long startTransfer(long var1, int var3);

    private native void addTransfer(long var1, int var3);

    private native void dropDone(long var1, long var3, boolean var5, boolean var6, int var7);

    protected void startSecondaryDispatch() {
        AWTLockAccess.awtUnlock();
        super.startSecondaryDispatch();
        AWTLockAccess.awtLock();
    }
}

