/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.awt.CharToByteSymbol;
import sun.awt.CharsetString;
import sun.awt.PlatformFont;
import sun.awt.motif.CharToByteX11Dingbats;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.PSPathGraphics;
import sun.awt.motif.PrintStatusDialog;
import sun.awt.motif.UPageDialog;
import sun.awt.motif.UPrinterDialog;
import sun.io.CharToByteConverter;
import sun.java2d.PeekGraphics;
import sun.java2d.PeekMetrics;
import sun.java2d.RasterPrinterJob;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /heximageSrc{currentfile imStr readhexstring pop} def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "SF";
    private static final String DrawStringName = "DS";
    private static final String EVEN_ODD_FILL_STR = "eofill";
    private static final String WINDING_FILL_STR = "fill";
    private static final String EVEN_ODD_CLIP_STR = "eoclip";
    private static final String WINDING_CLIP_STR = "clip";
    private static final String MOVETO_STR = " moveto";
    private static final String LINETO_STR = " lineto";
    private static final String CURVETO_STR = " curveto";
    private static final String GRESTORE_STR = "grestore";
    private static final String GSAVE_STR = "gsave";
    private static final String NEWPATH_STR = "newpath";
    private static final String CLOSEPATH_STR = "closepath";
    private static final String SETRGBCOLOR_STR = " setrgbcolor";
    private static final String SETGRAY_STR = " setgray";
    private static final String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static boolean forcePDL = false;
    private static boolean forceRaster = false;
    static boolean shapeTextProp = false;
    private static ResourceBundle messageRB;
    int mDestType;
    String mDestination = "lp";
    String mOptions;
    Font mLastFont;
    Color mLastColor;
    Shape mLastClip;
    AffineTransform mLastTransform;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    File spoolFile;
    private String mFillOpStr = "fill";
    private String mClipOpStr = "clip";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps;

    private static Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = System.getProperty("user.language", "en");
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties." + string2);
                if (!(file.canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2)).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public PageFormat pageDialog(final PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Frame frame = new Frame();
                UPageDialog uPageDialog = new UPageDialog(frame, pageFormat);
                uPageDialog.show();
                if (uPageDialog.getSetupStatus() != 1) {
                    return pageFormat;
                }
                PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
                pageFormat2.setOrientation(uPageDialog.getOrientation());
                pageFormat2.setPaper(uPageDialog.getPaper());
                return pageFormat2;
            }
        });
        return pageFormat2;
    }

    public boolean printDialog() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Frame frame = new Frame();
                UPrinterDialog uPrinterDialog = new UPrinterDialog(frame, "Print", PSPrinterJob.this.checkAllowedToPrintToFile());
                uPrinterDialog.setCopies(PSPrinterJob.this.getCopies());
                uPrinterDialog.setBannerString(PSPrinterJob.this.getJobName());
                uPrinterDialog.show();
                if (uPrinterDialog.getPrintStatus() != 1) {
                    return Boolean.FALSE;
                }
                PSPrinterJob.this.mDestType = uPrinterDialog.getDestType();
                PSPrinterJob.this.mDestination = uPrinterDialog.getDestString(PSPrinterJob.this.mDestType);
                PSPrinterJob.this.mOptions = uPrinterDialog.getOptionsString();
                PSPrinterJob.this.setJobName(uPrinterDialog.getBannerString());
                PSPrinterJob.this.setCopies(uPrinterDialog.getCopies());
                PSPrinterJob.this.setCollated(false);
                if (PSPrinterJob.this.mDestType == 1) {
                    return new Boolean(PSPrinterJob.this.okayToCreateFile(frame, PSPrinterJob.this.mDestination));
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    public void setCollated(boolean bl) {
        super.setCollated(bl);
    }

    protected void startDoc() throws PrinterException {
        int n;
        PrinterOpener printerOpener = new PrinterOpener();
        AccessController.doPrivileged(printerOpener);
        if (printerOpener.pex != null) {
            throw printerOpener.pex;
        }
        OutputStream outputStream = printerOpener.result;
        this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
        this.mPSStream.println(ADOBE_PS_STR);
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/ISOF {");
        this.mPSStream.println("     dup findfont dup length 1 add dict begin {");
        this.mPSStream.println("             1 index /FID eq {pop pop} {D} ifelse");
        this.mPSStream.println("     } forall /Encoding ISOLatin1Encoding D");
        this.mPSStream.println("     currentdict end definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/DS {");
        this.mPSStream.println("     moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("     1 index length 1 sub NZ div 0");
        this.mPSStream.println("     3 2 roll ashow newpath} BD");
        this.mPSStream.println("/F [");
        if (mFontProps == null) {
            this.mPSStream.println(" /Helvetica ISOF");
            this.mPSStream.println(" /Helvetica-Bold ISOF");
            this.mPSStream.println(" /Helvetica-Oblique ISOF");
            this.mPSStream.println(" /Helvetica-BoldOblique ISOF");
            this.mPSStream.println(" /Times-Roman ISOF");
            this.mPSStream.println(" /Times-Bold ISOF");
            this.mPSStream.println(" /Times-Italic ISOF");
            this.mPSStream.println(" /Times-BoldItalic ISOF");
            this.mPSStream.println(" /Courier ISOF");
            this.mPSStream.println(" /Courier-Bold ISOF");
            this.mPSStream.println(" /Courier-Oblique ISOF");
            this.mPSStream.println(" /Courier-BoldOblique ISOF");
        } else {
            n = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
            int n2 = 0;
            while (n2 < n) {
                this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(n2), "Courier ISOF"));
                ++n2;
            }
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/SF {");
        this.mPSStream.println("     F exch get exch scalefont setfont");
        if (mFontProps == null) {
            this.mPSStream.println(" (abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890) stringwidth pop div");
        } else {
            this.mPSStream.println(" testString stringwidth pop div");
        }
        this.mPSStream.println("     currentfont [1 0 0 -1 0 0]makefont exch scalefont setfont} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        n = this.isCollated() ? 1 : this.getCopies();
        this.mPSStream.println(n + COPIES);
        this.mPSStream.println("%%EndSetup");
    }

    protected void abortDoc() {
        if (this.mPSStream != null) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (PSPrinterJob.this.spoolFile != null && PSPrinterJob.this.spoolFile.exists()) {
                    PSPrinterJob.this.spoolFile.delete();
                }
                return null;
            }
        });
    }

    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.close();
        }
        if (this.mDestType == 0) {
            PrinterSpooler printerSpooler = new PrinterSpooler();
            AccessController.doPrivileged(printerSpooler);
            if (printerSpooler.pex != null) {
                throw printerSpooler.pex;
            }
        }
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        double d = pageFormat.getPaper().getHeight();
        int n2 = n + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState());
        this.mPSStream.println(PAGE_COMMENT + n2 + " " + n2);
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(d + COORD_PREP);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void drawImageBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2) {
        this.setTransform(new AffineTransform());
        this.prepDrawing(false);
        int n3 = (int)f7;
        int n4 = (int)f8;
        this.mPSStream.println(IMAGE_SAVE);
        int n5 = 3 * n3;
        while (n5 > 65535) {
            n5 /= 2;
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + f3 + " 0 " + "0 " + f4 + " " + f + " " + f2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + n4 + " 0 " + 0 + "]" + "/heximageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 6];
        try {
            n6 = (int)f6 * n;
            int n7 = 0;
            while (n7 < n4) {
                n6 += (int)f5;
                n6 = PSPrinterJob.toHex(byArray, n6, byArray2);
                this.mPSStream.write(byArray2);
                this.mPSStream.println("");
                ++n7;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        this.mPSStream.println(IMAGE_SAVE);
        int n5 = 3 * n3;
        while (n5 > 65535) {
            n5 /= 2;
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + n3 + " 0 " + "0 " + n4 + " " + n + " " + n2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + -n4 + " 0 " + n4 + "]" + "/heximageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 6];
        try {
            int n7 = 0;
            while (n7 < n4) {
                n6 = PSPrinterJob.toHex(byArray, n6, byArray2);
                this.mPSStream.write(byArray2);
                this.mPSStream.println("");
                ++n7;
            }
        }
        catch (IOException iOException) {
            throw new PrinterIOException(iOException);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n);
        }
        return pSPathGraphics;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void setClip(Shape shape) {
        this.mLastClip = shape;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.mLastTransform = affineTransform;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private int[] getPSFontIndexArray(Font font, CharsetString[] charsetStringArray) {
        int[] nArray = null;
        if (mFontProps != null) {
            nArray = new int[charsetStringArray.length];
        }
        int n = 0;
        while (n < charsetStringArray.length && nArray != null) {
            CharsetString charsetString = charsetStringArray[n];
            CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
            String string = charToByteConverter instanceof CharToByteSymbol ? "symbol" : (charToByteConverter instanceof CharToByteX11Dingbats ? "dingbats" : this.makeCharsetName(charToByteConverter.getCharacterEncoding()));
            String string2 = PlatformFont.styleStr(font.getStyle());
            String string3 = font.getName().toLowerCase();
            String string4 = mFontProps.getProperty(string3 = string3.replace(' ', '_'), "");
            String string5 = mFontProps.getProperty(string4 + "." + string + "." + string2, null);
            if (string5 != null) {
                try {
                    nArray[n] = Integer.parseInt(mFontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = null;
                }
            } else {
                nArray = null;
            }
            ++n;
        }
        return nArray;
    }

    protected boolean textOut(String string, float f, float f2) {
        boolean bl = true;
        if (mFontProps == null) {
            this.prepDrawing(true);
            this.mPSStream.println(f + " " + f2 + " moveto(" + string + ")show");
        } else {
            this.prepDrawing(false);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.mLastFont);
            CharsetString[] charsetStringArray = ((MFontPeer)this.mLastFont.getPeer()).makeMultiCharsetString(string);
            int[] nArray = this.getPSFontIndexArray(this.mLastFont, charsetStringArray);
            if (nArray != null) {
                int n = 0;
                while (n < charsetStringArray.length) {
                    block13: {
                        int n2;
                        int n3;
                        CharsetString charsetString = charsetStringArray[n];
                        CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
                        StringBuffer stringBuffer = new StringBuffer();
                        byte[] byArray = new byte[charsetString.length * 2];
                        try {
                            n3 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                        }
                        catch (CharConversionException charConversionException) {
                            break block13;
                        }
                        int n4 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                        stringBuffer.append('<');
                        int n5 = 0;
                        while (n5 < n3) {
                            n2 = byArray[n5];
                            String string2 = Integer.toHexString(n2);
                            int n6 = string2.length();
                            if (n6 > 2) {
                                string2 = string2.substring(n6 - 2, n6);
                            } else if (n6 == 1) {
                                string2 = "0" + string2;
                            } else if (n6 == 0) {
                                string2 = "00";
                            }
                            stringBuffer.append(string2);
                            ++n5;
                        }
                        stringBuffer.append('>');
                        this.mPSStream.println("/testString " + stringBuffer.toString() + " D");
                        this.mPSStream.println("% Font[" + this.mLastFont.getName() + ", " + PlatformFont.styleStr(this.mLastFont.getStyle()) + ", " + this.mLastFont.getSize() + "]");
                        this.getGState().emitPSFont(nArray[n], this.mLastFont.getSize(), n4);
                        this.mPSStream.println(stringBuffer.toString());
                        n2 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                        this.mPSStream.println(" " + n2 + " " + f + " " + f2);
                        this.mPSStream.println(DrawStringName);
                        f += (float)n2;
                    }
                    ++n;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    protected void setFillMode(int n) {
        switch (n) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    protected void beginPath() {
        this.prepDrawing(false);
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected void moveTo(float f, float f2) {
        this.mPSStream.println(f + " " + f2 + MOVETO_STR);
        this.mStartPathX = f;
        this.mStartPathY = f2;
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void lineTo(float f, float f2) {
        this.mPSStream.println(f + " " + f2 + LINETO_STR);
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void bezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPSStream.println(f + " " + f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + CURVETO_STR);
        this.mPenX = f5;
        this.mPenY = f6;
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    protected double getXRes() {
        return 300.0;
    }

    protected double getYRes() {
        return 300.0;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return paper.getImageableWidth();
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return paper.getImageableHeight();
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return paper.getWidth();
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return paper.getHeight();
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    private String[] printExecCmd(String string, String string2, String string3, int n, String string4) {
        String[] stringArray;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 0;
        int n7 = 2;
        int n8 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n6 |= n2;
            ++n7;
        }
        if (string2 != null && !string2.equals("")) {
            n6 |= n3;
            ++n7;
        }
        if (string3 != null && !string3.equals("")) {
            n6 |= n4;
            ++n7;
        }
        if (n > 1) {
            n6 |= n5;
            ++n7;
        }
        if (System.getProperty("os.name").equals("Linux")) {
            stringArray = new String[n7];
            stringArray[n8++] = "/usr/bin/lpr";
            if ((n6 & n2) != 0) {
                stringArray[n8++] = new String("-P" + string);
            }
            if ((n6 & n4) != 0) {
                stringArray[n8++] = new String("-T" + string3);
            }
            if ((n6 & n5) != 0) {
                stringArray[n8++] = new String("-#" + new Integer(n).toString());
            }
            if ((n6 & n3) != 0) {
                stringArray[n8++] = new String(string2);
            }
        } else {
            stringArray = new String[++n7];
            stringArray[n8++] = "/usr/bin/lp";
            stringArray[n8++] = "-c";
            if ((n6 & n2) != 0) {
                stringArray[n8++] = new String("-d" + string);
            }
            if ((n6 & n4) != 0) {
                stringArray[n8++] = new String("-t" + string3);
            }
            if ((n6 & n5) != 0) {
                stringArray[n8++] = new String("-n" + new Integer(n).toString());
            }
            if ((n6 & n3) != 0) {
                stringArray[n8++] = new String("-o" + string2);
            }
        }
        stringArray[n8++] = string4;
        return stringArray;
    }

    private boolean okayToCreateFile(Frame frame, String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.exists()) {
            String string2 = PSPrinterJob.getMsg("warning_button.cancel");
            String string3 = PSPrinterJob.getMsg("warning_button.overwrite");
            PrintStatusDialog printStatusDialog = new PrintStatusDialog(frame, PSPrinterJob.getMsg("warning_dialog.title"), PSPrinterJob.getMsg("warning_msg.file_exists") + string, string3, string2);
            printStatusDialog.show();
            if (printStatusDialog.getCommand().equals(string2)) {
                bl = false;
            }
        }
        return bl;
    }

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is missing.");
        }
    }

    static String getMsg(String string) {
        if (messageRB == null) {
            PSPrinterJob.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrinterJob is broken, There is no " + string + " key in resource");
        }
    }

    private static int toHex(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n < byArray.length && n2 < byArray2.length) {
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            int n5 = byArray[n++] & 0xFF;
            byArray2[n2++] = hexDigits[(n5 & 0xF0) >>> 4];
            byArray2[n2++] = hexDigits[n5 & 0xF];
            byArray2[n2++] = hexDigits[(n4 & 0xF0) >>> 4];
            byArray2[n2++] = hexDigits[n4 & 0xF];
            byArray2[n2++] = hexDigits[(n3 & 0xF0) >>> 4];
            byArray2[n2++] = hexDigits[n3 & 0xF];
        }
        return n;
    }

    private String makeCharsetName(String string) {
        if (string.indexOf("8859_1") != -1) {
            return "latin1";
        }
        return string.toLowerCase();
    }

    private void prepDrawing(boolean bl) {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
        if (bl) {
            this.getGState().emitPSFont(this.mLastFont);
        }
    }

    private GState getGState() {
        int n = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(n - 1);
    }

    private void gsave() {
        GState gState = this.getGState();
        this.mGStateStack.add(new GState(gState));
        this.mPSStream.println(GSAVE_STR);
    }

    private void grestore() {
        int n = this.mGStateStack.size();
        this.mGStateStack.remove(n - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    static {
        mFontProps = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                mFontProps = PSPrinterJob.initProps();
                return null;
            }
        });
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        Properties properties = System.getProperties();
        if (properties != null) {
            String string;
            String string2 = properties.getProperty(FORCE_PIPE_PROP);
            if (string2 != null) {
                if (string2.equalsIgnoreCase(FORCE_PDL)) {
                    forcePDL = true;
                } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                    forceRaster = true;
                }
            }
            if ((string = properties.getProperty(SHAPE_TEXT_PROP)) != null) {
                shapeTextProp = true;
            }
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;

        GState() {
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        GState(GState gState) {
            this.mColor = gState.mColor;
            this.mClip = gState.mClip;
            this.mFont = gState.mFont;
            this.mTransform = gState.mTransform;
        }

        boolean canSetClip(Shape shape) {
            return this.mClip == null || this.mClip.equals(shape);
        }

        void emitPSClip(Shape shape) {
            if (!(shape == null || this.mClip != null && this.mClip.equals(shape))) {
                this.convertToPSPath(shape.getPathIterator(new AffineTransform()));
                PSPrinterJob.this.selectClipPath();
                this.mClip = shape;
            }
        }

        void emitTransform(AffineTransform affineTransform) {
            if (affineTransform != null && !affineTransform.equals(this.mTransform)) {
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                PSPrinterJob.this.mPSStream.println("[" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + "] concat");
                this.mTransform = affineTransform;
            }
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] fArray = color.getColorComponents(null);
                if (fArray[0] == fArray[1] && fArray[1] == fArray[2]) {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + PSPrinterJob.SETGRAY_STR);
                } else {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + PSPrinterJob.SETRGBCOLOR_STR);
                }
                this.mColor = color;
            }
        }

        void emitPSFont(Font font) {
            if (this.mFont == null && font != null || !this.mFont.equals(font)) {
                PSPrinterJob.this.mCurMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n = PSPrinterJob.this.mCurMetrics.stringWidth(PSPrinterJob.testString);
                int n2 = font.getStyle();
                n2 = font.getFamily().toLowerCase().startsWith("helvetica") || font.getFamily().toLowerCase().startsWith("sansserif") ? 0 : (font.getFamily().toLowerCase().startsWith("dialog") ? 0 : (font.getFamily().toLowerCase().startsWith("times") || font.getFamily().toLowerCase().startsWith("serif") ? 4 : 8));
                if (font.isBold()) {
                    ++n2;
                }
                if (font.isItalic()) {
                    n2 += 2;
                }
                PSPrinterJob.this.mPSStream.println("% Font[" + font.getFamily() + ", " + font.getStyle() + ", " + font.getSize() + "]");
                PSPrinterJob.this.getGState().emitPSFont(n2, font.getSize(), n);
            }
            this.mFont = font;
        }

        void emitPSFont(int n, int n2, int n3) {
            PSPrinterJob.this.mPSStream.println(n3 + " " + n2 + " " + n + " " + PSPrinterJob.SetFontName);
        }

        private void convertToPSPath(PathIterator pathIterator) {
            float[] fArray = new float[6];
            int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
            PSPrinterJob.this.setFillMode(n);
            PSPrinterJob.this.beginPath();
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(fArray);
                switch (n2) {
                    case 0: {
                        PSPrinterJob.this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        PSPrinterJob.this.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        float f = PSPrinterJob.this.getPenX();
                        float f2 = PSPrinterJob.this.getPenY();
                        float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                        float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                        float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                        float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                        PSPrinterJob.this.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        PSPrinterJob.this.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        PSPrinterJob.this.closeSubpath();
                    }
                }
                pathIterator.next();
            }
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrinterException pex;

        private PrinterSpooler() {
        }

        public Object run() {
            try {
                if (PSPrinterJob.this.spoolFile == null || !PSPrinterJob.this.spoolFile.exists()) {
                    this.pex = new PrinterException("No spool file");
                    return null;
                }
                String string = PSPrinterJob.this.spoolFile.getAbsolutePath();
                String[] stringArray = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.getJobName(), PSPrinterJob.super.getCollatedCopies(), string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                PSPrinterJob.this.spoolFile.delete();
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
            }
            catch (InterruptedException interruptedException) {
                this.pex = new PrinterException(interruptedException.toString());
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                if (PSPrinterJob.this.mDestType == 1) {
                    PSPrinterJob.this.spoolFile = new File(PSPrinterJob.this.mDestination);
                } else {
                    PSPrinterJob.this.spoolFile = File.createTempFile("javaprint", ".ps", null);
                    PSPrinterJob.this.spoolFile.deleteOnExit();
                }
                this.result = new FileOutputStream(PSPrinterJob.this.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
                return null;
            }
        }
    }
}

