/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractPlayer;
import javax.sound.midi.MidiChannel;

class MixerMidiChannel
implements MidiChannel {
    protected static final boolean defaultMute = false;
    protected static final boolean defaultLocal = true;
    protected static final boolean defaultMono = false;
    protected static final boolean defaultOmni = false;
    protected static final boolean defaultSolo = false;
    protected static final int defaultProgram = 0;
    private int channelNumber;
    protected boolean mute;
    protected boolean local;
    protected boolean mono;
    protected boolean omni;
    protected boolean solo;
    protected int program;
    protected AbstractPlayer player;
    private int id = 0;

    MixerMidiChannel(AbstractPlayer abstractPlayer, int n) {
        this.player = abstractPlayer;
        this.mute = false;
        this.local = true;
        this.mono = false;
        this.omni = false;
        this.solo = false;
        this.program = 0;
        this.channelNumber = n;
    }

    public void noteOn(int n, int n2) {
        if (this.id != 0) {
            this.nNoteOn(this.id, this.channelNumber, n, n2, this.player.getTimeStamp());
        }
    }

    public void noteOff(int n, int n2) {
        if (this.id != 0) {
            this.nNoteOff(this.id, this.channelNumber, n, n2, this.player.getTimeStamp());
        }
    }

    public void noteOff(int n) {
        this.noteOff(n, 0);
    }

    public void setPolyPressure(int n, int n2) {
    }

    public int getPolyPressure(int n) {
        return 0;
    }

    public void setChannelPressure(int n) {
    }

    public int getChannelPressure() {
        return 0;
    }

    public void controlChange(int n, int n2) {
        if (this.id != 0) {
            this.nControlChange(this.id, this.channelNumber, n, n2, this.player.getTimeStamp());
        }
    }

    public int getController(int n) {
        if (this.id != 0) {
            return this.nGetController(this.id, this.channelNumber, n);
        }
        return 0;
    }

    public void programChange(int n) {
        if (this.id != 0) {
            this.nProgramChange(this.id, this.channelNumber, n, this.player.getTimeStamp());
            this.program = n;
        }
    }

    public void programChange(int n, int n2) {
        if (this.id != 0) {
            this.nProgramChange(this.id, this.channelNumber, n, n2, this.player.getTimeStamp());
            this.program = n2;
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void setPitchBend(int n) {
        if (this.id != 0) {
            this.nSetPitchBend(this.id, this.channelNumber, n / 128, n % 128, this.player.getTimeStamp());
        }
    }

    public int getPitchBend() {
        if (this.id != 0) {
            return this.nGetPitchBend(this.id, this.channelNumber);
        }
        return 0;
    }

    public void resetAllControllers() {
        if (this.id != 0) {
            this.nResetAllControllers(this.id, this.channelNumber);
        }
    }

    public void allNotesOff() {
        if (this.id != 0) {
            this.nAllNotesOff(this.id, this.channelNumber, this.player.getTimeStamp());
        }
    }

    public void allSoundOff() {
    }

    public boolean localControl(boolean bl) {
        return this.local;
    }

    public void setMono(boolean bl) {
    }

    public boolean getMono() {
        return this.mono;
    }

    public void setOmni(boolean bl) {
    }

    public boolean getOmni() {
        return this.omni;
    }

    public void setMute(boolean bl) {
        if (this.id != 0 && this.mute != bl) {
            this.mute = this.nSetMute(this.id, this.channelNumber, bl);
        }
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setSolo(boolean bl) {
        if (this.id != 0 && this.solo != bl) {
            this.solo = this.nSetSolo(this.id, this.channelNumber, bl);
        }
    }

    public boolean getSolo() {
        return this.solo;
    }

    void setId(int n) {
        this.id = n;
    }

    protected native boolean nSetSolo(int var1, int var2, boolean var3);

    protected native boolean nGetSolo(int var1, int var2);

    protected native int nGetController(int var1, int var2, int var3);

    protected native int nGetPitchBend(int var1, int var2);

    protected native void nNoteOn(int var1, int var2, int var3, int var4, long var5);

    protected native void nNoteOff(int var1, int var2, int var3, int var4, long var5);

    protected native void nControlChange(int var1, int var2, int var3, int var4, long var5);

    protected native void nProgramChange(int var1, int var2, int var3, long var4);

    protected native void nProgramChange(int var1, int var2, int var3, int var4, long var5);

    protected native void nSetPitchBend(int var1, int var2, int var3, int var4, long var5);

    protected native void nAllNotesOff(int var1, int var2, long var3);

    protected native void nResetAllControllers(int var1, int var2);

    protected native boolean nSetMute(int var1, int var2, boolean var3);
}

