/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class StandardMidiFileReader
extends SunMidiFileReader {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private InputStream stream;
    private DataInputStream dis;
    private Sequence sequence;
    private short type;
    private short tracks;
    private long tick;
    private int status;
    private int bytesRemaining = 0;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    private static final int bisBufferSize = 1024;
    public static final int[] types = new int[]{0, 1};

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        int n;
        float f;
        int n2 = 16;
        int n3 = -1;
        MidiFileFormat midiFileFormat = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n2);
        int n4 = dataInputStream.readInt();
        if (n4 != 1297377380) {
            dataInputStream.reset();
            throw new InvalidMidiDataException("not a valid MIDI file");
        }
        int n5 = dataInputStream.readInt();
        n5 += 8;
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        int n6 = dataInputStream.readShort();
        short s3 = s;
        if (n6 > 0) {
            f = 0.0f;
            n = n6;
        } else {
            int n7 = -1 * n6 >> 8;
            switch (n7) {
                case 24: {
                    f = 24.0f;
                    break;
                }
                case 25: {
                    f = 25.0f;
                    break;
                }
                case 29: {
                    f = 29.97f;
                    break;
                }
                case 30: {
                    f = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Unknown frame code: " + n7);
                }
            }
            n = n6 & 0xFF;
        }
        dataInputStream.reset();
        n5 = -1;
        midiFileFormat = new MidiFileFormat(s3, f, n, n5, n3);
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
        this.stream = inputStream;
        this.sequence = this.constructSequence();
        int n = 0;
        while (n < this.tracks) {
            this.findTrack();
            this.readTrack();
            ++n;
        }
        return this.sequence;
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        return this.getSequence(bufferedInputStream);
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        return this.getSequence(bufferedInputStream);
    }

    private Sequence constructSequence() throws IOException, InvalidMidiDataException {
        int n;
        float f;
        String string = new String("MThd");
        PushbackInputStream pushbackInputStream = new PushbackInputStream(this.stream);
        this.dis = new DataInputStream(pushbackInputStream);
        String string2 = this.getChunkName();
        if (!string2.equals(string)) {
            throw new InvalidMidiDataException("Invalid chunk name: " + string2 + ": not a MIDI file");
        }
        this.bytesRemaining = this.dis.readInt();
        this.type = this.dis.readShort();
        this.bytesRemaining -= 2;
        if (this.type != 0 && this.type != 1) {
            throw new InvalidMidiDataException("Invalid or unsupported file type: " + this.type);
        }
        this.tracks = this.dis.readShort();
        this.bytesRemaining -= 2;
        int n2 = this.dis.readShort();
        this.bytesRemaining -= 2;
        if (n2 > 0) {
            f = 0.0f;
            n = n2;
        } else {
            int n3 = -1 * n2 >> 8;
            switch (n3) {
                case 24: {
                    f = 24.0f;
                    break;
                }
                case 25: {
                    f = 25.0f;
                    break;
                }
                case 29: {
                    f = 29.97f;
                    break;
                }
                case 30: {
                    f = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Unknown frame code: " + n3);
                }
            }
            n = n2 & 0xFF;
        }
        this.dis.skip(this.bytesRemaining);
        Sequence sequence = new Sequence(f, n);
        return sequence;
    }

    private void findTrack() throws IOException, InvalidMidiDataException {
        String string;
        String string2 = new String("MTrk");
        do {
            if ((string = this.getChunkName()).equals(string2)) continue;
            this.bytesRemaining = this.dis.readInt();
            this.dis.skip(this.bytesRemaining);
        } while (!string.equals(string2));
    }

    private Track readTrack() throws IOException, InvalidMidiDataException {
        this.tick = 0L;
        this.status = 0;
        Track track = this.sequence.createTrack();
        this.bytesRemaining = this.dis.readInt();
        while (this.bytesRemaining > 0) {
            track.add(this.readEvent());
        }
        return track;
    }

    private MidiEvent readEvent() throws IOException, InvalidMidiDataException {
        int n = -1;
        int n2 = 0;
        this.tick += (long)this.readVarInt();
        int n3 = this.dis.readUnsignedByte();
        --this.bytesRemaining;
        if (n3 >= 128) {
            this.status = n3;
        } else {
            n = n3;
        }
        int n4 = this.getType(this.status);
        switch (n4) {
            case 1: {
                if (n == -1) {
                    n = this.dis.readUnsignedByte();
                    --this.bytesRemaining;
                }
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(this.status, n, n2);
                MidiEvent midiEvent = new MidiEvent(shortMessage, this.tick);
                return midiEvent;
            }
            case 2: {
                if (n == -1) {
                    n = this.dis.readUnsignedByte();
                    --this.bytesRemaining;
                }
                n2 = this.dis.readUnsignedByte();
                --this.bytesRemaining;
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(this.status, n, n2);
                MidiEvent midiEvent = new MidiEvent(shortMessage, this.tick);
                return midiEvent;
            }
            case 3: {
                int n5 = this.readVarInt();
                byte[] byArray = new byte[n5];
                this.bytesRemaining -= this.dis.read(byArray);
                SysexMessage sysexMessage = new SysexMessage();
                sysexMessage.setMessage(this.status, byArray, n5);
                MidiEvent midiEvent = new MidiEvent(sysexMessage, this.tick);
                return midiEvent;
            }
            case 4: {
                int n6 = this.dis.readUnsignedByte();
                --this.bytesRemaining;
                int n7 = this.readVarInt();
                byte[] byArray = new byte[n7];
                this.bytesRemaining -= this.dis.read(byArray);
                MetaMessage metaMessage = new MetaMessage();
                metaMessage.setMessage(n6, byArray, n7);
                MidiEvent midiEvent = new MidiEvent(metaMessage, this.tick);
                return midiEvent;
            }
        }
        throw new InvalidMidiDataException("Internal parser error");
    }

    private int getType(int n) throws InvalidMidiDataException {
        if ((n & 0xF0) == 240) {
            switch (n) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + n);
        }
        switch (n & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n);
    }

    private String getChunkName() throws IOException {
        byte[] byArray = new byte[4];
        this.dis.read(byArray);
        return new String(byArray);
    }

    private int readVarInt() throws IOException, InvalidMidiDataException {
        int n = 0;
        int n2 = 0;
        int n3 = 6;
        int n4 = 0;
        while (n4 < n3) {
            n2 = this.dis.readUnsignedByte();
            --this.bytesRemaining;
            n = (n << 7) + (n2 & 0x7F);
            if ((n2 & 0x80) == 0) break;
            ++n4;
        }
        if ((n2 & 0x80) != 0) {
            throw new InvalidMidiDataException("Unterminated variable-length integer");
        }
        return n;
    }
}

