/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    float[] scaleFactors;
    float[] offsets;
    int length = 0;
    RenderingHints hints;
    private int srcNbits;
    private int dstNbits;

    public RescaleOp(float[] fArray, float[] fArray2, RenderingHints renderingHints) {
        this.length = fArray.length;
        if (this.length > fArray2.length) {
            this.length = fArray2.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        int n = 0;
        while (n < this.length) {
            this.scaleFactors[n] = fArray[n];
            this.offsets[n] = fArray2[n];
            ++n;
        }
        this.hints = renderingHints;
    }

    public RescaleOp(float f, float f2, RenderingHints renderingHints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = f;
        this.offsets[0] = f2;
        this.hints = renderingHints;
    }

    public final float[] getScaleFactors(float[] fArray) {
        if (fArray == null) {
            return (float[])this.scaleFactors.clone();
        }
        System.arraycopy(this.scaleFactors, 0, fArray, 0, Math.min(this.scaleFactors.length, fArray.length));
        return fArray;
    }

    public final float[] getOffsets(float[] fArray) {
        if (fArray == null) {
            return (float[])this.offsets.clone();
        }
        System.arraycopy(this.offsets, 0, fArray, 0, Math.min(this.offsets.length, fArray.length));
        return fArray;
    }

    public final int getNumFactors() {
        return this.length;
    }

    private ByteLookupTable createByteLut(float[] fArray, float[] fArray2, int n, int n2) {
        byte[][] byArray = new byte[fArray.length][n2];
        int n3 = 0;
        while (n3 < fArray.length) {
            float f = fArray[n3];
            float f2 = fArray2[n3];
            byte[] byArray2 = byArray[n3];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = (int)((float)n4 * f + f2);
                if ((n5 & 0xFFFFFF00) != 0) {
                    n5 = n5 < 0 ? 0 : 255;
                }
                byArray2[n4] = (byte)n5;
                ++n4;
            }
            ++n3;
        }
        return new ByteLookupTable(0, byArray);
    }

    private ShortLookupTable createShortLut(float[] fArray, float[] fArray2, int n, int n2) {
        short[][] sArray = new short[fArray.length][n2];
        int n3 = 0;
        while (n3 < fArray.length) {
            float f = fArray[n3];
            float f2 = fArray2[n3];
            short[] sArray2 = sArray[n3];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = (int)((float)n4 * f + f2);
                if ((n5 & 0xFFFF0000) != 0) {
                    n5 = n5 < 0 ? 0 : 65535;
                }
                sArray2[n4] = (short)n5;
                ++n4;
            }
            ++n3;
        }
        return new ShortLookupTable(0, sArray);
    }

    private boolean canUseLookup(Raster raster, Raster raster2) {
        int n = raster.getDataBuffer().getDataType();
        if (n != 0 && n != 1) {
            return false;
        }
        SampleModel sampleModel = raster2.getSampleModel();
        this.dstNbits = sampleModel.getSampleSize(0);
        if (this.dstNbits != 8 && this.dstNbits != 16) {
            return false;
        }
        int n2 = 1;
        while (n2 < raster.getNumBands()) {
            int n3 = sampleModel.getSampleSize(n2);
            if (n3 != this.dstNbits) {
                return false;
            }
            ++n2;
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        this.srcNbits = sampleModel2.getSampleSize(0);
        if (this.srcNbits > 16) {
            return false;
        }
        int n4 = 1;
        while (n4 < raster.getNumBands()) {
            int n5 = sampleModel2.getSampleSize(n4);
            if (n5 != this.srcNbits) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        ColorModel colorModel;
        ColorModel colorModel2 = bufferedImage.getColorModel();
        int n = colorModel2.getNumColorComponents();
        if (colorModel2 instanceof IndexColorModel) {
            throw new IllegalArgumentException("Rescaling cannot be performed on an indexed image");
        }
        if (this.length != 1 && this.length != n && this.length != colorModel2.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        boolean bl = false;
        if (this.length > n && colorModel2.hasAlpha()) {
            this.length = n + 1;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorModel = colorModel2;
        } else {
            if (n2 != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Src width (" + n2 + ") not equal to dst width (" + bufferedImage2.getWidth() + ")");
            }
            if (n3 != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Src height (" + n3 + ") not equal to dst height (" + bufferedImage2.getHeight() + ")");
            }
            colorModel = bufferedImage2.getColorModel();
            if (colorModel2.getColorSpace().getType() != colorModel.getColorSpace().getType()) {
                bl = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            int n4;
            int n5;
            object = bufferedImage.getRaster();
            WritableRaster writableRaster = bufferedImage2.getRaster();
            if (colorModel2.hasAlpha() && (n - 1 == this.length || this.length == 1)) {
                n5 = ((Raster)object).getMinX();
                n4 = ((Raster)object).getMinY();
                int[] nArray = new int[n - 1];
                int n6 = 0;
                while (n6 < n - 1) {
                    nArray[n6] = n6;
                    ++n6;
                }
                object = ((WritableRaster)object).createWritableChild(n5, n4, ((Raster)object).getWidth(), ((Raster)object).getHeight(), n5, n4, nArray);
            }
            if (colorModel.hasAlpha() && ((n5 = writableRaster.getNumBands()) - 1 == this.length || this.length == 1)) {
                n4 = writableRaster.getMinX();
                int n7 = writableRaster.getMinY();
                int[] nArray = new int[n - 1];
                int n8 = 0;
                while (n8 < n - 1) {
                    nArray[n8] = n8;
                    ++n8;
                }
                writableRaster = writableRaster.createWritableChild(n4, n7, writableRaster.getWidth(), writableRaster.getHeight(), n4, n7, nArray);
            }
            this.filter((Raster)object, writableRaster);
        }
        if (bl) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage3;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n = raster.getNumBands();
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int[] nArray = null;
        int n4 = 0;
        int n5 = 0;
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (n3 != writableRaster.getHeight() || n2 != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (n != writableRaster.getNumBands()) {
                throw new IllegalArgumentException("Number of bands in src " + n + " does not equal number of bands in dest " + writableRaster.getNumBands());
            }
        }
        if (this.length != 1 && this.length != raster.getNumBands()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of bands in the src raster");
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        if (this.canUseLookup(raster, writableRaster)) {
            int n6 = 1 << this.srcNbits;
            int n7 = 1 << this.dstNbits;
            if (n7 == 256) {
                ByteLookupTable byteLookupTable = this.createByteLut(this.scaleFactors, this.offsets, n, n6);
                LookupOp lookupOp = new LookupOp(byteLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            } else {
                ShortLookupTable shortLookupTable = this.createShortLut(this.scaleFactors, this.offsets, n, n6);
                LookupOp lookupOp = new LookupOp(shortLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            }
        } else {
            if (this.length > 1) {
                n4 = 1;
            }
            int n8 = raster.getMinX();
            int n9 = raster.getMinY();
            int n10 = writableRaster.getMinX();
            int n11 = writableRaster.getMinY();
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            SampleModel sampleModel = writableRaster.getSampleModel();
            int n12 = 0;
            while (n12 < n) {
                int n13 = sampleModel.getSampleSize(n12);
                nArray2[n12] = (1 << n13) - 1;
                nArray3[n12] = ~nArray2[n12];
                ++n12;
            }
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n10;
                int n16 = n8;
                int n17 = 0;
                while (n17 < n2) {
                    nArray = raster.getPixel(n16, n9, nArray);
                    n5 = 0;
                    int n18 = 0;
                    while (n18 < n) {
                        int n19 = (int)((float)nArray[n18] * this.scaleFactors[n5] + this.offsets[n5]);
                        if ((n19 & nArray3[n18]) != 0) {
                            n19 = n19 < 0 ? 0 : nArray2[n18];
                        }
                        nArray[n18] = n19;
                        ++n18;
                        n5 += n4;
                    }
                    writableRaster.setPixel(n15, n11, nArray);
                    ++n17;
                    ++n16;
                    ++n15;
                }
                ++n14;
                ++n9;
                ++n11;
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            bufferedImage2 = new BufferedImage(colorModel2, bufferedImage.getRaster().createCompatibleWritableRaster(), colorModel2.isAlphaPremultiplied(), null);
        } else {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

