/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;
import sun.security.provider.Sun;

public class SecureRandom
extends Random {
    private Provider provider = null;
    private SecureRandomSpi secureRandomSpi = null;
    private static SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest = null;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        super(0L);
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = new Sun();
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = new Sun();
            this.secureRandomSpi.engineSetSeed(byArray);
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                this.secureRandomSpi.engineSetSeed(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        super(0L);
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "SecureRandom", null);
            return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "SecureRandom", string2);
        return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l));
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (byArray[n4] & 0xFF);
            ++n4;
        }
        return n3 >>> n2 * 8 - n;
    }

    public static byte[] getSeed(int n) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)l;
            l >>= 8;
            ++n;
        }
        return byArray;
    }

    private static String getPrngAlgorithm() {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            Enumeration enumeration = providerArray[n].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("SecureRandom.")) continue;
                int n2 = string.indexOf(".", 0);
                return string.substring(n2 + 1);
            }
            ++n;
        }
        return null;
    }
}

