/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};

    public SimpleDateFormat() {
        this(3, 3, Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.pattern = string;
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
        this.initialize(Locale.getDefault());
    }

    SimpleDateFormat(int n, int n2, Locale locale) {
        Object[] objectArray;
        String[] stringArray = (String[])cachedLocaleData.get(locale);
        if (stringArray == null) {
            objectArray = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            stringArray = objectArray.getStringArray("DateTimePatterns");
            cachedLocaleData.put(locale, stringArray);
        }
        this.formatData = new DateFormatSymbols(locale);
        if (n >= 0 && n2 >= 0) {
            objectArray = new Object[]{stringArray[n], stringArray[n2 + 4]};
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n >= 0) {
            this.pattern = stringArray[n];
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2 + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        this.calendar.setTime(date);
        boolean bl = false;
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (n2 < this.pattern.length()) {
            char c2 = this.pattern.charAt(n2);
            if (c2 != c && n > 0) {
                stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                n = 0;
            }
            if (c2 == '\'') {
                if (n2 + 1 < this.pattern.length() && this.pattern.charAt(n2 + 1) == '\'') {
                    stringBuffer.append('\'');
                    ++n2;
                } else {
                    bl = !bl;
                }
            } else if (!bl && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                c = c2;
                ++n;
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
        }
        return stringBuffer;
    }

    private String subFormat(char c, int n, int n2, FieldPosition fieldPosition) throws IllegalArgumentException {
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        String string = "";
        n3 = "GyMdkHmsSEDFwWahKz".indexOf(c);
        if (n3 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c + "'");
        }
        int n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n3];
        int n6 = this.calendar.get(n5);
        switch (n3) {
            case 0: {
                string = this.formatData.eras[n6];
                break;
            }
            case 1: {
                if (n >= 4) {
                    string = this.zeroPaddingNumber(n6, 4, n4);
                    break;
                }
                string = this.zeroPaddingNumber(n6, 2, 2);
                break;
            }
            case 2: {
                if (n >= 4) {
                    string = this.formatData.months[n6];
                    break;
                }
                if (n == 3) {
                    string = this.formatData.shortMonths[n6];
                    break;
                }
                string = this.zeroPaddingNumber(n6 + 1, n, n4);
                break;
            }
            case 4: {
                if (n6 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n, n4);
                    break;
                }
                string = this.zeroPaddingNumber(n6, n, n4);
                break;
            }
            case 9: {
                if (n >= 4) {
                    string = this.formatData.weekdays[n6];
                    break;
                }
                string = this.formatData.shortWeekdays[n6];
                break;
            }
            case 14: {
                string = this.formatData.ampms[n6];
                break;
            }
            case 15: {
                if (n6 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n, n4);
                    break;
                }
                string = this.zeroPaddingNumber(n6, n, n4);
                break;
            }
            case 17: {
                int n7 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n7 == -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    n6 = this.calendar.get(15) + this.calendar.get(16);
                    if (n6 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n6 = -n6;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    stringBuffer.append(this.zeroPaddingNumber(n6 / 3600000, 2, 2));
                    stringBuffer.append(':');
                    stringBuffer.append(this.zeroPaddingNumber(n6 % 3600000 / 60000, 2, 2));
                    string = stringBuffer.toString();
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n >= 4) {
                        string = this.formatData.zoneStrings[n7][3];
                        break;
                    }
                    string = this.formatData.zoneStrings[n7][4];
                    break;
                }
                if (n >= 4) {
                    string = this.formatData.zoneStrings[n7][1];
                    break;
                }
                string = this.formatData.zoneStrings[n7][2];
                break;
            }
            default: {
                string = this.zeroPaddingNumber(n6, n, n4);
            }
        }
        if (fieldPosition.field == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n3] && fieldPosition.beginIndex == 0 && fieldPosition.endIndex == 0) {
            fieldPosition.beginIndex = n2;
            fieldPosition.endIndex = n2 + string.length();
        }
        return string;
    }

    private String zeroPaddingNumber(long l, int n, int n2) {
        this.numberFormat.setMinimumIntegerDigits(n);
        this.numberFormat.setMaximumIntegerDigits(n2);
        return this.numberFormat.format(l);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n;
        int n2;
        int n3 = n2 = parsePosition.index;
        boolean[] blArray = new boolean[]{false};
        this.calendar.clear();
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        while (n7 < this.pattern.length()) {
            n = this.pattern.charAt(n7);
            if (bl) {
                if (n == 39) {
                    bl = false;
                    if (n5 == 0) {
                        if (n2 >= string.length() || n != string.charAt(n2)) {
                            parsePosition.index = n3;
                            parsePosition.errorIndex = n2;
                            return null;
                        }
                        ++n2;
                    }
                    n5 = 0;
                    n6 = 0;
                } else {
                    if (n2 >= string.length() || n != string.charAt(n2)) {
                        parsePosition.index = n3;
                        parsePosition.errorIndex = n2;
                        return null;
                    }
                    ++n5;
                    ++n2;
                }
            } else {
                int n8;
                if (n == 39) {
                    bl = true;
                    if (n5 > 0) {
                        n8 = n2;
                        if ((n2 = this.subParse(string, n2, (char)n4, n5, false, blArray)) < 0) {
                            parsePosition.errorIndex = n8;
                            parsePosition.index = n3;
                            return null;
                        }
                        n5 = 0;
                    }
                    if (n6 == 0) {
                        n8 = n2;
                        if (n2 >= string.length() || n != string.charAt(n2)) {
                            parsePosition.errorIndex = n8;
                            parsePosition.index = n3;
                            return null;
                        }
                        ++n2;
                        n5 = 1;
                    }
                } else if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
                    if (n != n4 && n5 > 0) {
                        n8 = n2;
                        if ((n2 = this.subParse(string, n2, (char)n4, n5, true, blArray)) < 0) {
                            parsePosition.errorIndex = n8;
                            parsePosition.index = n3;
                            return null;
                        }
                        n4 = n;
                        n5 = 1;
                    } else {
                        if (n != n4) {
                            n4 = n;
                        }
                        ++n5;
                    }
                } else if (n5 > 0) {
                    n8 = n2;
                    if ((n2 = this.subParse(string, n2, (char)n4, n5, false, blArray)) < 0) {
                        parsePosition.errorIndex = n8;
                        parsePosition.index = n3;
                        return null;
                    }
                    if (n2 >= string.length() || n != string.charAt(n2)) {
                        parsePosition.errorIndex = n2;
                        parsePosition.index = n3;
                        return null;
                    }
                    ++n2;
                    n5 = 0;
                    n4 = 0;
                } else {
                    if (n2 >= string.length() || n != string.charAt(n2)) {
                        parsePosition.errorIndex = n2;
                        parsePosition.index = n3;
                        return null;
                    }
                    ++n2;
                }
                ++n6;
            }
            ++n7;
        }
        if (n5 > 0) {
            n = n2;
            if ((n2 = this.subParse(string, n2, (char)n4, n5, false, blArray)) < 0) {
                parsePosition.index = n3;
                parsePosition.errorIndex = n;
                return null;
            }
        }
        parsePosition.index = n2;
        try {
            if (blArray[0]) {
                Calendar calendar = (Calendar)this.calendar.clone();
                date = this.calendar.getTime();
                if (date.before(this.defaultCenturyStart)) {
                    calendar.set(1, this.defaultCenturyStartYear + 100);
                    date = calendar.getTime();
                }
            } else {
                date = this.calendar.getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.errorIndex = n2;
            parsePosition.index = n3;
            return null;
        }
        return date;
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -1;
        while (n3 < n4) {
            int n7 = stringArray[n3].length();
            if (n7 > n5 && string.regionMatches(true, n, stringArray[n3], 0, n7)) {
                n6 = n3;
                n5 = n7;
            }
            ++n3;
        }
        if (n6 >= 0) {
            this.calendar.set(n2, n6);
            return n + n5;
        }
        return -n;
    }

    private int matchZoneString(String string, int n, int n2) {
        int n3 = 1;
        while (n3 <= 4) {
            if (string.regionMatches(true, n, this.formatData.zoneStrings[n2][n3], 0, this.formatData.zoneStrings[n2][n3].length())) break;
            ++n3;
        }
        return n3 > 4 ? -1 : n3;
    }

    private int subParseZoneString(String string, int n) {
        int n2 = this.formatData.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null && (n2 = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null) {
            n4 = 0;
            while (n4 < this.formatData.zoneStrings.length) {
                n3 = this.matchZoneString(string, n, n4);
                if (n3 > 0) {
                    timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n4][0]);
                    break;
                }
                ++n4;
            }
        }
        if (timeZone != null) {
            this.calendar.set(15, timeZone.getRawOffset());
            this.calendar.set(16, n3 >= 3 ? ((SimpleTimeZone)timeZone).getDSTSavings() : 0);
            return n + this.formatData.zoneStrings[n4][n3].length();
        }
        return 0;
    }

    private int subParse(String string, int n, char c, int n2, boolean bl, boolean[] blArray) {
        int n3;
        Number number = null;
        int n4 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n5 = -1;
        n5 = "GyMdkHmsSEDFwWahKz".indexOf(c);
        if (n5 == -1) {
            return -n;
        }
        parsePosition.index = n;
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n5];
        while (true) {
            if (parsePosition.index >= string.length()) {
                return -n;
            }
            n3 = string.charAt(parsePosition.index);
            if (n3 != 32 && n3 != 9) break;
            ++parsePosition.index;
        }
        if (n5 == 4 || n5 == 15 || n5 == 2 && n2 <= 2 || n5 == 1) {
            if (bl) {
                if (n + n2 > string.length()) {
                    return -n;
                }
                number = this.numberFormat.parse(string.substring(0, n + n2), parsePosition);
            } else {
                number = this.numberFormat.parse(string, parsePosition);
            }
            if (number == null) {
                return -n;
            }
            n4 = number.intValue();
        }
        switch (n5) {
            case 0: {
                return this.matchString(string, n, 0, this.formatData.eras);
            }
            case 1: {
                if (n2 <= 2 && parsePosition.index - n == 2 && Character.isDigit(string.charAt(n)) && Character.isDigit(string.charAt(n + 1))) {
                    n3 = this.defaultCenturyStartYear % 100;
                    blArray[0] = n4 == n3;
                    n4 += this.defaultCenturyStartYear / 100 * 100 + (n4 < n3 ? 100 : 0);
                }
                this.calendar.set(1, n4);
                return parsePosition.index;
            }
            case 2: {
                if (n2 <= 2) {
                    this.calendar.set(2, n4 - 1);
                    return parsePosition.index;
                }
                n3 = 0;
                n3 = this.matchString(string, n, 2, this.formatData.months);
                if (n3 > 0) {
                    return n3;
                }
                return this.matchString(string, n, 2, this.formatData.shortMonths);
            }
            case 4: {
                if (n4 == this.calendar.getMaximum(11) + 1) {
                    n4 = 0;
                }
                this.calendar.set(11, n4);
                return parsePosition.index;
            }
            case 9: {
                n3 = 0;
                n3 = this.matchString(string, n, 7, this.formatData.weekdays);
                if (n3 > 0) {
                    return n3;
                }
                return this.matchString(string, n, 7, this.formatData.shortWeekdays);
            }
            case 14: {
                return this.matchString(string, n, 9, this.formatData.ampms);
            }
            case 15: {
                if (n4 == this.calendar.getLeastMaximum(10) + 1) {
                    n4 = 0;
                }
                this.calendar.set(10, n4);
                return parsePosition.index;
            }
            case 17: {
                int n7;
                n3 = 0;
                if (string.length() - n >= GMT.length() && string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    this.calendar.set(16, 0);
                    parsePosition.index = n + GMT.length();
                    try {
                        if (string.charAt(parsePosition.index) == '+') {
                            n3 = 1;
                        } else if (string.charAt(parsePosition.index) == '-') {
                            n3 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n3 == 0) {
                        this.calendar.set(15, 0);
                        return parsePosition.index;
                    }
                    ++parsePosition.index;
                    Number number2 = this.numberFormat.parse(string, parsePosition);
                    if (number2 == null) {
                        return -n;
                    }
                    if (string.charAt(parsePosition.index) == ':') {
                        n7 = number2.intValue() * 60;
                        ++parsePosition.index;
                        number2 = this.numberFormat.parse(string, parsePosition);
                        if (number2 == null) {
                            return -n;
                        }
                        n7 += number2.intValue();
                    } else {
                        n7 = number2.intValue();
                        n7 = n7 < 24 ? (n7 *= 60) : n7 % 100 + n7 / 100 * 60;
                    }
                } else {
                    int n8 = this.subParseZoneString(string, n);
                    if (n8 != 0) {
                        return n8;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("+####;-####");
                    decimalFormat.setParseIntegerOnly(true);
                    Number number3 = decimalFormat.parse(string, parsePosition);
                    if (number3 == null) {
                        return -n;
                    }
                    n7 = number3.intValue();
                    n3 = 1;
                    if (n7 < 0) {
                        n3 = -1;
                        n7 = -n7;
                    }
                    n7 = n7 < 24 ? (n7 *= 60) : n7 % 100 + n7 / 100 * 60;
                }
                if (n3 != 0) {
                    n7 *= 60000 * n3;
                    if (this.calendar.getTimeZone().useDaylightTime()) {
                        this.calendar.set(16, 3600000);
                        n7 -= 3600000;
                    }
                    this.calendar.set(15, n7);
                    return parsePosition.index;
                }
                return -n;
            }
        }
        if (bl) {
            if (n + n2 > string.length()) {
                return -n;
            }
            number = this.numberFormat.parse(string.substring(0, n + n2), parsePosition);
        } else {
            number = this.numberFormat.parse(string, parsePosition);
        }
        if (number != null) {
            this.calendar.set(n6, number.intValue());
            return parsePosition.index;
        }
        return -n;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                }
            } else if (c == '\'') {
                bl = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int n2 = string2.indexOf(c);
                if (n2 == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
                c = string3.charAt(n2);
            }
            stringBuffer.append(c);
            ++n;
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKz", this.formatData.localPatternChars);
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        this.pattern = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKz");
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
    }
}

