/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    private static final String uiClassID = "TableHeaderUI";
    protected JTable table;
    protected TableColumnModel columnModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;
    private TableCellRenderer defaultRenderer;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
        }
        this.setColumnModel(tableColumnModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public void setTable(JTable jTable) {
        JTable jTable2 = this.table;
        this.table = jTable;
        this.firePropertyChange("table", jTable2, jTable);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setReorderingAllowed(boolean bl) {
        boolean bl2 = this.reorderingAllowed;
        this.reorderingAllowed = bl;
        this.firePropertyChange("reorderingAllowed", bl2, bl);
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setResizingAllowed(boolean bl) {
        boolean bl2 = this.resizingAllowed;
        this.resizingAllowed = bl;
        this.firePropertyChange("resizingAllowed", bl2, bl);
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setUpdateTableInRealTime(boolean bl) {
        this.updateTableInRealTime = bl;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        this.defaultRenderer = tableCellRenderer;
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public Rectangle getHeaderRect(int n) {
        Rectangle rectangle = new Rectangle();
        TableColumnModel tableColumnModel = this.getColumnModel();
        rectangle.height = this.getHeight();
        if (n >= 0) {
            if (n >= tableColumnModel.getColumnCount()) {
                rectangle.x = this.getWidth();
            } else {
                int n2 = 0;
                while (n2 < n) {
                    rectangle.x += tableColumnModel.getColumn(n2).getWidth();
                    ++n2;
                }
                rectangle.width = tableColumnModel.getColumn(n).getWidth();
            }
        }
        return rectangle;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnModel.getColumnIndexAtX(point.x);
        if (n != -1) {
            Component component;
            TableColumn tableColumn = this.columnModel.getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.defaultRenderer;
            }
            if ((component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n)) instanceof JComponent) {
                Rectangle rectangle = this.getHeaderRect(n);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
        if (this.ui != tableHeaderUI) {
            super.setUI(tableHeaderUI);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableCellRenderer createDefaultRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.resizingColumn = null;
        this.updateTableInRealTime = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setDefaultRenderer(this.createDefaultRenderer());
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setDraggedColumn(TableColumn tableColumn) {
        this.draggedColumn = tableColumn;
    }

    public void setDraggedDistance(int n) {
        this.draggedDistance = n;
    }

    public void setResizingColumn(TableColumn tableColumn) {
        this.resizingColumn = tableColumn;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String string = this.reorderingAllowed ? "true" : "false";
        String string2 = this.resizingAllowed ? "true" : "false";
        String string3 = this.updateTableInRealTime ? "true" : "false";
        return super.paramString() + ",draggedDistance=" + this.draggedDistance + ",reorderingAllowed=" + string + ",resizingAllowed=" + string2 + ",updateTableInRealTime=" + string3;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTableHeader();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        protected AccessibleJTableHeader() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTableHeader.this.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    if (JTableHeader.this.defaultRenderer != null) {
                        tableCellRenderer = JTableHeader.this.defaultRenderer;
                    } else {
                        return null;
                    }
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
                return new AccessibleJTableHeaderEntry(n, JTableHeader.this, JTableHeader.this.table);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTableHeader.this.columnModel.getColumnCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                if (JTableHeader.this.defaultRenderer != null) {
                    tableCellRenderer = JTableHeader.this.defaultRenderer;
                } else {
                    return null;
                }
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
            return new AccessibleJTableHeaderEntry(n, JTableHeader.this, JTableHeader.this.table);
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTableHeader parent;
            private int column;
            private JTable table;

            public AccessibleJTableHeaderEntry(int n, JTableHeader jTableHeader, JTable jTable) {
                this.parent = jTableHeader;
                this.column = n;
                this.table = jTable;
                this.setAccessibleParent(this.parent);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null) {
                    Component component;
                    TableColumn tableColumn = tableColumnModel.getColumn(this.column);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        if (JTableHeader.this.defaultRenderer != null) {
                            tableCellRenderer = JTableHeader.this.defaultRenderer;
                        } else {
                            return null;
                        }
                    }
                    if ((component = tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column)) instanceof Accessible) {
                        return ((Accessible)((Object)component)).getAccessibleContext();
                    }
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null) {
                    TableColumn tableColumn = tableColumnModel.getColumn(this.column);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        if (JTableHeader.this.defaultRenderer != null) {
                            tableCellRenderer = JTableHeader.this.defaultRenderer;
                        } else {
                            return null;
                        }
                    }
                    return tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column);
                }
                return null;
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return this.table.getColumnName(this.column);
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.COLUMN_HEADER;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                    if (this.isShowing()) {
                        accessibleStateSet.add(AccessibleState.SHOWING);
                    }
                    return accessibleStateSet;
                }
                return new AccessibleStateSet();
            }

            public int getAccessibleIndexInParent() {
                return this.column;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl);
                    }
                }
            }

            public boolean isShowing() {
                return this.isVisible() && JTableHeader.this.isShowing();
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.getLocation();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.getLocation();
                }
                return this.getBounds().getLocation();
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.table.getCellRect(-1, this.column, false);
                rectangle.y = 0;
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }
    }
}

