/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    FontMetrics metrics;
    Segment lineBuffer = new Segment();
    boolean widthChanging;
    int tabBase;
    int tabSize;
    boolean wordWrap;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public WrappedPlainView(Element element) {
        this(element, false);
    }

    public WrappedPlainView(Element element, boolean bl) {
        super(element, 1);
        this.wordWrap = bl;
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        try {
            if (element2.isLeaf()) {
                this.drawText(element2, n, n2, graphics, n3, n4);
            } else {
                int n5 = element2.getElementIndex(n);
                int n6 = element2.getElementIndex(n2);
                while (n5 <= n6) {
                    Element element3 = element2.getElement(n5);
                    int n7 = Math.max(element3.getStartOffset(), n);
                    int n8 = Math.min(element3.getEndOffset(), n2);
                    n3 = this.drawText(element3, n7, n8, graphics, n3, n4);
                    ++n5;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render: " + n + "," + n2);
        }
    }

    private int drawText(Element element, int n, int n2, Graphics graphics, int n3, int n4) throws BadLocationException {
        n2 = Math.min(this.getDocument().getLength(), n2);
        AttributeSet attributeSet = element.getAttributes();
        if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
            graphics.setColor(this.unselected);
            n3 = Utilities.drawComposedText(attributeSet, graphics, n3, n4, n - element.getStartOffset(), n2 - element.getStartOffset());
        } else if (this.sel0 == this.sel1) {
            n3 = this.drawUnselectedText(graphics, n3, n4, n, n2);
        } else if (n >= this.sel0 && n <= this.sel1 && n2 >= this.sel0 && n2 <= this.sel1) {
            n3 = this.drawSelectedText(graphics, n3, n4, n, n2);
        } else if (this.sel0 >= n && this.sel0 <= n2) {
            if (this.sel1 >= n && this.sel1 <= n2) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, this.sel1);
                n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
            } else {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, n2);
            }
        } else if (this.sel1 >= n && this.sel1 <= n2) {
            n3 = this.drawSelectedText(graphics, n3, n4, n, this.sel1);
            n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
        } else {
            n3 = this.drawUnselectedText(graphics, n3, n4, n, n2);
        }
        return n3;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected final Segment getLineBuffer() {
        return this.lineBuffer;
    }

    protected int calculateBreakPosition(int n, int n2) {
        this.loadText(n, n2);
        int n3 = this.wordWrap ? n + Utilities.getBreakLocation(this.lineBuffer, this.metrics, this.tabBase, this.tabBase + this.getWidth(), this, n) : n + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, this.tabBase, this.tabBase + this.getWidth(), this, n);
        return n3;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = new WrappedLine(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                viewArray[n] = new WrappedLine(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void loadText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.lineBuffer);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't get line text");
        }
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public float nextTabStop(float f, int n) {
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        if ((int)f != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f, f2);
        this.widthChanging = false;
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    public float getMinimumSpan(int n) {
        this.updateMetrics();
        return super.getMinimumSpan(n);
    }

    public float getMaximumSpan(int n) {
        this.updateMetrics();
        return super.getMaximumSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element element) {
            super(element);
        }

        final int calculateLineCount() {
            int n = 0;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            while (n3 < n2) {
                ++n;
                int n4 = WrappedPlainView.this.calculateBreakPosition(n3, n2);
                int n5 = n3 = n4 == n3 ? n2 : n4;
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    return WrappedPlainView.this.getWidth();
                }
                case 1: {
                    if (this.nlines == 0 || WrappedPlainView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    int n2 = this.nlines * WrappedPlainView.this.metrics.getHeight();
                    return n2;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            int n = rectangle.y + WrappedPlainView.this.metrics.getAscent();
            int n2 = rectangle.x;
            JTextComponent jTextComponent = (JTextComponent)this.getContainer();
            Highlighter highlighter = jTextComponent.getHighlighter();
            LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                int n5 = WrappedPlainView.this.calculateBreakPosition(n4, n3);
                if (layeredHighlighter != null) {
                    if (n5 == n3) {
                        layeredHighlighter.paintLayeredHighlights(graphics, n4, n5 - 1, shape, jTextComponent, this);
                    } else {
                        layeredHighlighter.paintLayeredHighlights(graphics, n4, n5, shape, jTextComponent, this);
                    }
                }
                WrappedPlainView.this.drawLine(n4, n5, graphics, n2, n);
                n4 = n5 == n4 ? n3 : n5;
                n += WrappedPlainView.this.metrics.getHeight();
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            rectangle.width = 1;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            int n4 = bias == Position.Bias.Forward ? n : Math.max(n3, n - 1);
            while (n3 < n2) {
                int n5 = WrappedPlainView.this.calculateBreakPosition(n3, n2);
                if (n >= n3 && n4 < n5) {
                    WrappedPlainView.this.loadText(n3, n);
                    rectangle.x += Utilities.getTabbedTextWidth(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, WrappedPlainView.this, n3);
                    return rectangle;
                }
                if (n5 == n2 && n == n2) {
                    if (n > n3) {
                        WrappedPlainView.this.loadText(n3, n);
                        rectangle.x += Utilities.getTabbedTextWidth(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, WrappedPlainView.this, n3);
                    }
                    return rectangle;
                }
                n3 = n5 == n3 ? n2 : n5;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            Document document = this.getDocument();
            int n = (int)f;
            int n2 = (int)f2;
            if (n2 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n2 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                int n5 = WrappedPlainView.this.calculateBreakPosition(n4, n3);
                if (n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                    if (n < rectangle.x) {
                        return n4;
                    }
                    if (n > rectangle.x + rectangle.width) {
                        return n5;
                    }
                    int n6 = Utilities.getTabbedTextOffset(WrappedPlainView.this.lineBuffer, WrappedPlainView.this.metrics, rectangle.x, n, WrappedPlainView.this, n4);
                    return Math.min(n4 + n6, n3 - 1);
                }
                n4 = n5 == n4 ? n3 : n5;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedPlainView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedPlainView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

