/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.InputStream;
import sun.audio.AudioDevice;
import sun.audio.AudioSecurity;
import sun.audio.AudioSecurityAction;

public class AudioPlayer
extends Thread {
    private AudioDevice devAudio;
    private static boolean DEBUG = false;
    public static final AudioPlayer player = AudioPlayer.getAudioPlayer();

    private static ThreadGroup getAudioThreadGroup() {
        if (DEBUG) {
            System.out.println("AudioPlayer.getAudioThreadGroup()");
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static AudioPlayer getAudioPlayer() {
        if (DEBUG) {
            System.out.println("> AudioPlayer.getAudioPlayer()");
        }
        return (AudioPlayer)AudioSecurity.doPrivileged(new AudioSecurityAction(){

            public Object run() {
                return new AudioPlayer();
            }
        }, "UniversalThreadGroupAccess");
    }

    private AudioPlayer() {
        block6: {
            super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
            if (DEBUG) {
                System.out.println("> AudioPlayer private constructor");
            }
            this.devAudio = AudioDevice.device;
            try {
                AudioSecurity.doPrivileged(new AudioSecurityAction(){

                    public Object run() {
                        AudioPlayer.this.setPriority(10);
                        AudioPlayer.this.setDaemon(true);
                        return null;
                    }
                }, "UniversalThreadAccess");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (DEBUG) {
                    System.out.println("exception creating AudioPlayer: " + illegalArgumentException);
                }
            }
            catch (SecurityException securityException) {
                if (!DEBUG) break block6;
                System.out.println("exception creating AudioPlayer: " + securityException);
            }
        }
        this.devAudio.open();
        this.start();
        if (DEBUG) {
            System.out.println("< AudioPlayer private constructor completed");
        }
    }

    public synchronized void start(InputStream inputStream) {
        if (DEBUG) {
            System.out.println("> AudioPlayer.start");
            System.out.println("  InputStream = " + inputStream);
        }
        this.devAudio.openChannel(inputStream);
        this.notify();
        if (DEBUG) {
            System.out.println("< AudioPlayer.start completed");
        }
    }

    public synchronized void stop(InputStream inputStream) {
        if (DEBUG) {
            System.out.println("> AudioPlayer.stop");
        }
        this.devAudio.closeChannel(inputStream);
        if (DEBUG) {
            System.out.println("< AudioPlayer.stop completed");
        }
    }

    public void run() {
        this.devAudio.play();
        if (DEBUG) {
            System.out.println("AudioPlayer mixing loop.");
        }
        try {
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("AudioPlayer exited.");
            }
            return;
        }
    }
}

