/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.util.Comparator;
import sun.java2d.loops.GeneralRenderer;
import sun.java2d.loops.ImageData;

class EdgeCollection {
    private int remainingEdges = 0;
    private int activeEdges = 0;
    private int firstActive = 0;
    private Comparator leftComparator;
    private Comparator topLeftComparator;
    private EdgeEntry[] edges;

    EdgeCollection(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n2 += nArray3[n5];
            ++n5;
        }
        this.edges = new EdgeEntry[n2];
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray3[n6];
            int n8 = nArray[n3];
            int n9 = nArray2[n3];
            int n10 = nArray[n3 + n7 - 1];
            int n11 = nArray2[n3 + n7 - 1];
            if (n8 != n10 || n9 != n11) {
                this.edges[n4] = new EdgeEntry(n10, n11, n8, n9);
                if (this.edges[n4].initialized()) {
                    ++this.remainingEdges;
                    ++n4;
                }
            }
            while (n7-- > 1) {
                n10 = nArray[n3 + 1];
                n11 = nArray2[n3 + 1];
                this.edges[n4] = new EdgeEntry(n8, n9, n10, n11);
                if (this.edges[n4].initialized()) {
                    ++this.remainingEdges;
                    ++n4;
                }
                ++n3;
                n8 = n10;
                n9 = n11;
            }
            ++n3;
            ++n6;
        }
        this.topLeftComparator = new TopLeftComparator();
        this.leftComparator = new LeftComparator();
    }

    int countUnfinished() {
        return this.remainingEdges;
    }

    void sortByHighestVertex() {
        if (this.remainingEdges > 0) {
            this.sort(this.edges, this.firstActive, this.remainingEdges, this.topLeftComparator);
        }
    }

    void sortByLeftMostVertex() {
        if (this.activeEdges > 0) {
            this.sort(this.edges, this.firstActive, this.activeEdges, this.leftComparator);
        }
    }

    void removeDuplicateEdges() {
        if (this.remainingEdges <= 0) {
            return;
        }
        int n = this.firstActive;
        int n2 = this.firstActive + this.remainingEdges - 1;
        int n3 = this.firstActive;
        while (n < n2) {
            if (this.edges[n].mirrors(this.edges[n + 1])) {
                n += 2;
                this.remainingEdges -= 2;
                continue;
            }
            if (n3 != n) {
                this.edges[n3] = this.edges[n];
            }
            ++n3;
            ++n;
        }
    }

    void drawEvenOddFromActiveEdges(ImageData imageData, Object object) {
        int n = this.activeEdges;
        int n2 = this.firstActive;
        while (n >= 2) {
            int n3 = this.edges[n2].getY1();
            int n4 = this.edges[n2].getX1();
            int n5 = this.edges[++n2].getX1();
            ++n2;
            if (n5 > n4) {
                GeneralRenderer.doDrawLine(imageData, object, n4, n3, n5 - 1, n3);
            }
            n -= 2;
        }
    }

    void drawWindingFromActiveEdges(ImageData imageData, Object object) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.activeEdges;
        int n5 = this.firstActive;
        while (n4 > 0) {
            int n6;
            EdgeEntry edgeEntry = this.edges[n5];
            if (0 == n) {
                n2 = edgeEntry.getX1();
                n3 = edgeEntry.getY1();
            }
            if (0 == (n += edgeEntry.isFlipped() ? -1 : 1) && (n6 = edgeEntry.getX1()) > n2) {
                GeneralRenderer.doDrawLine(imageData, object, n2, n3, n6 - 1, n3);
            }
            --n4;
            ++n5;
        }
    }

    void drawActiveEdges(ImageData imageData, Object object, boolean bl) {
        if (bl) {
            this.drawEvenOddFromActiveEdges(imageData, object);
        } else {
            this.drawWindingFromActiveEdges(imageData, object);
        }
    }

    void advanceActiveEdges() {
        int n = this.firstActive;
        int n2 = this.firstActive + this.activeEdges;
        while (n < n2) {
            EdgeEntry edgeEntry = this.edges[n];
            edgeEntry.bumpY1(1);
            if (edgeEntry.getErrY() != 0) {
                edgeEntry.bumpError(edgeEntry.getErrX());
                while (edgeEntry.getError() > 0) {
                    edgeEntry.bumpX1(edgeEntry.getBumpX());
                    edgeEntry.bumpError(-edgeEntry.getErrY());
                }
            }
            ++n;
        }
    }

    void activateNewEdges() {
        if (this.remainingEdges > 0) {
            int n = this.edges[this.firstActive].getY1();
            while (this.activeEdges < this.remainingEdges) {
                if (this.edges[this.firstActive + this.activeEdges].getY1() != n) break;
                ++this.activeEdges;
            }
        }
    }

    void purgeUsedEdges() {
        if (this.activeEdges > 0) {
            int n = this.activeEdges;
            int n2 = this.firstActive;
            while (n-- > 0) {
                if (this.edges[n2].getY1() >= this.edges[n2].getY2()) {
                    if (n2 != this.firstActive) {
                        this.edges[n2] = this.edges[this.firstActive];
                    }
                    ++this.firstActive;
                    --this.remainingEdges;
                    --this.activeEdges;
                }
                ++n2;
            }
        }
    }

    private void sort(EdgeEntry[] edgeEntryArray, int n, int n2, Comparator comparator) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            int n7 = n;
            while (n7 < n2 + n) {
                int n8 = n7;
                while (n8 > n && comparator.compare(edgeEntryArray[n8 - 1], edgeEntryArray[n8]) > 0) {
                    this.swap(edgeEntryArray, n8, n8 - 1);
                    --n8;
                }
                ++n7;
            }
            return;
        }
        int n9 = n + n2 / 2;
        if (n2 > 7) {
            int n10 = n;
            n6 = n + n2 - 1;
            if (n2 > 40) {
                n5 = n2 / 8;
                n10 = this.med3(edgeEntryArray, n10, n10 + n5, n10 + 2 * n5, comparator);
                n9 = this.med3(edgeEntryArray, n9 - n5, n9, n9 + n5, comparator);
                n6 = this.med3(edgeEntryArray, n6 - 2 * n5, n6 - n5, n6, comparator);
            }
            n9 = this.med3(edgeEntryArray, n10, n9, n6, comparator);
        }
        EdgeEntry edgeEntry = edgeEntryArray[n9];
        n5 = n6 = n;
        int n11 = n4 = n + n2 - 1;
        while (true) {
            if (n5 <= n4 && (n3 = comparator.compare(edgeEntryArray[n5], edgeEntry)) <= 0) {
                if (n3 == 0) {
                    this.swap(edgeEntryArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && (n3 = comparator.compare(edgeEntryArray[n4], edgeEntry)) >= 0) {
                if (edgeEntryArray[n4] == edgeEntry) {
                    this.swap(edgeEntryArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            this.swap(edgeEntryArray, n5++, n4--);
        }
        int n12 = n + n2;
        n3 = Math.min(n6 - n, n5 - n6);
        this.vecswap(edgeEntryArray, n, n5 - n3, n3);
        n3 = Math.min(n11 - n4, n12 - n11 - 1);
        this.vecswap(edgeEntryArray, n5, n12 - n3, n3);
        n3 = n5 - n6;
        if (n3 > 1) {
            this.sort(edgeEntryArray, n, n3, comparator);
        }
        if ((n3 = n11 - n4) > 1) {
            this.sort(edgeEntryArray, n12 - n3, n3, comparator);
        }
    }

    private int med3(EdgeEntry[] edgeEntryArray, int n, int n2, int n3, Comparator comparator) {
        return comparator.compare(edgeEntryArray[n], edgeEntryArray[n2]) < 0 ? (comparator.compare(edgeEntryArray[n2], edgeEntryArray[n3]) < 0 ? n2 : (comparator.compare(edgeEntryArray[n], edgeEntryArray[n3]) < 0 ? n3 : n)) : (comparator.compare(edgeEntryArray[n2], edgeEntryArray[n3]) > 0 ? n2 : (comparator.compare(edgeEntryArray[n], edgeEntryArray[n3]) > 0 ? n3 : n));
    }

    private void swap(EdgeEntry[] edgeEntryArray, int n, int n2) {
        EdgeEntry edgeEntry = edgeEntryArray[n];
        edgeEntryArray[n] = edgeEntryArray[n2];
        edgeEntryArray[n2] = edgeEntry;
    }

    private void vecswap(EdgeEntry[] edgeEntryArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.swap(edgeEntryArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private class LeftComparator
    implements Comparator {
        private LeftComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((EdgeEntry)object).isLeftOf((EdgeEntry)object2);
        }
    }

    private class TopLeftComparator
    implements Comparator {
        private TopLeftComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((EdgeEntry)object).isTopLeftOf((EdgeEntry)object2);
        }
    }

    private class EdgeEntry {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int error;
        private int errx;
        private int erry;
        private int bumpx;
        private boolean flipped;
        private boolean initOK = false;

        EdgeEntry(int n, int n2, int n3, int n4) {
            if (n2 != n4) {
                int n5;
                this.flipped = false;
                if (n2 > n4) {
                    this.flipped = true;
                    this.x1 = n3;
                    this.y1 = n4;
                    this.x2 = n;
                    this.y2 = n2;
                } else {
                    this.x1 = n;
                    this.y1 = n2;
                    this.x2 = n3;
                    this.y2 = n4;
                }
                int n6 = this.x2 - this.x1;
                int n7 = this.y2 - this.y1;
                int n8 = n6 < 0 ? -n6 : n6;
                int n9 = n5 = n7 < 0 ? -n7 : n7;
                if (n6 < 0) {
                    this.bumpx = -1;
                    this.error = -n5;
                } else {
                    this.bumpx = 1;
                    this.error = 0;
                }
                this.errx = n8;
                this.erry = n5;
                this.initOK = true;
            }
        }

        boolean initialized() {
            return this.initOK;
        }

        int getX1() {
            return this.x1;
        }

        int getY1() {
            return this.y1;
        }

        int getX2() {
            return this.x2;
        }

        int getY2() {
            return this.y2;
        }

        boolean isFlipped() {
            return this.flipped;
        }

        int getErrY() {
            return this.erry;
        }

        int getErrX() {
            return this.errx;
        }

        int getBumpX() {
            return this.bumpx;
        }

        int getError() {
            return this.error;
        }

        void bumpX1(int n) {
            this.x1 += n;
        }

        void bumpY1(int n) {
            this.y1 += n;
        }

        void bumpError(int n) {
            this.error += n;
        }

        boolean mirrors(EdgeEntry edgeEntry) {
            return edgeEntry.x1 == this.x1 && edgeEntry.y1 == this.y1 && edgeEntry.x2 == this.x2 && edgeEntry.y2 == this.y2 && edgeEntry.flipped != this.flipped;
        }

        int isTopLeftOf(EdgeEntry edgeEntry) {
            if (this.y1 < edgeEntry.y1) {
                return -1;
            }
            if (this.y1 > edgeEntry.y1) {
                return 1;
            }
            if (this.x1 < edgeEntry.x1) {
                return -1;
            }
            if (this.x1 > edgeEntry.x1) {
                return 1;
            }
            if (this.y2 < edgeEntry.y2) {
                return -1;
            }
            if (this.y2 > edgeEntry.y2) {
                return 1;
            }
            if (this.x2 < edgeEntry.x2) {
                return -1;
            }
            if (this.x2 > edgeEntry.x2) {
                return 1;
            }
            return 0;
        }

        int isLeftOf(EdgeEntry edgeEntry) {
            if (this.x1 < edgeEntry.x1) {
                return -1;
            }
            if (this.x1 > edgeEntry.x1) {
                return 1;
            }
            return 0;
        }
    }
}

