/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.GC;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.Target;
import sun.rmi.transport.WeakRef;
import sun.security.action.GetLongAction;

public final class ObjectTable {
    private static final long gcInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.server.gcInterval", 60000L));
    private static Object lock = new Object();
    private static Map objTable = new HashMap();
    private static Map implTable = new HashMap();
    private static int keepAliveCount = 0;
    private static Thread reaper = null;
    static ReferenceQueue reapQueue = new ReferenceQueue();
    private static GC.LatencyRequest gcLatencyRequest = null;

    private ObjectTable() {
    }

    static Target getTarget(ObjID objID) {
        Object object = lock;
        synchronized (object) {
            Target target = (Target)objTable.get(objID);
            return target;
        }
    }

    public static Target getTarget(Remote remote) {
        Object object = lock;
        synchronized (object) {
            Target target = (Target)implTable.get(new WeakRef(remote));
            return target;
        }
    }

    public static RemoteStub getStub(Remote remote) throws NoSuchObjectException {
        Target target = ObjectTable.getTarget(remote);
        if (target == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return target.getStub();
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        Object object = lock;
        synchronized (object) {
            Target target = ObjectTable.getTarget(remote);
            if (target == null) {
                throw new NoSuchObjectException("object not exported");
            }
            if (target.unexport(bl)) {
                ObjectTable.removeTarget(target);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
    }

    static void putTarget(Target target) throws ExportException {
        Remote remote;
        ObjID objID = target.getObjID();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("ObjectTable.putTarget: add object " + objID);
        }
        if ((remote = target.getImpl()) == null) {
            throw new ExportException("internal error: attempt to export collected object");
        }
        Object object = lock;
        synchronized (object) {
            if (objTable.containsKey(objID)) {
                throw new ExportException("internal error: ObjID already in use");
            }
            if (implTable.containsKey(weakRef)) {
                throw new ExportException("object already exported");
            }
            objTable.put(objID, target);
            implTable.put(weakRef, target);
            if (!target.isPermanent()) {
                ++keepAliveCount;
                if (reaper == null) {
                    reaper = (Thread)AccessController.doPrivileged(new RMIThreadAction(new Reaper(), "Reaper", false));
                    reaper.start();
                }
                if (gcLatencyRequest == null) {
                    gcLatencyRequest = GC.requestLatency(gcInterval);
                }
            }
        }
    }

    private static void removeTarget(Target target) {
        ObjID objID = target.getObjID();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("ObjetTable.removeTarget: remove object " + objID);
        }
        objTable.remove(objID);
        implTable.remove(weakRef);
        if (!target.isPermanent() && --keepAliveCount == 0) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    reaper.interrupt();
                    return null;
                }
            });
            reaper = null;
            gcLatencyRequest.cancel();
            gcLatencyRequest = null;
        }
    }

    static void referenced(ObjID objID, long l, VMID vMID) {
        Object object = lock;
        synchronized (object) {
            Target target = (Target)objTable.get(objID);
            if (target != null) {
                target.referenced(l, vMID);
            }
        }
    }

    static void unreferenced(ObjID objID, long l, VMID vMID, boolean bl) {
        Object object = lock;
        synchronized (object) {
            Target target = (Target)objTable.get(objID);
            if (target != null) {
                target.unreferenced(l, vMID, bl);
            }
        }
    }

    private static class Reaper
    implements Runnable {
        private Reaper() {
        }

        public void run() {
            try {
                do {
                    WeakRef weakRef = (WeakRef)reapQueue.remove();
                    Object object = lock;
                    synchronized (object) {
                        Target target = (Target)implTable.get(weakRef);
                        if (target != null) {
                            if (!target.isEmpty()) {
                                throw new Error("object with known references collected");
                            }
                            if (target.isPermanent()) {
                                throw new Error("permanent object collected");
                            }
                            ObjectTable.removeTarget(target);
                        }
                    }
                } while (!Thread.interrupted());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

