/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript.navig5;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.applet.AppletClassLoader;
import sun.plugin.ActivatorSecurityManager;
import sun.plugin.usability.Trace;

class SecurityContext {
    private ProtectionDomain domain;
    private AccessControlContext ctx;

    SecurityContext(ProtectionDomain protectionDomain, AccessControlContext accessControlContext) {
        this.domain = protectionDomain;
        this.ctx = accessControlContext;
    }

    String getURL() {
        CodeSource codeSource;
        URL uRL;
        if (this.domain != null && (uRL = (codeSource = this.domain.getCodeSource()).getLocation()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = uRL.getProtocol();
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            stringBuffer.append(string);
            stringBuffer.append("://");
            stringBuffer.append(string2);
            if (n != -1) {
                stringBuffer.append(":" + n);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    byte[][] getCertChain() {
        return null;
    }

    int[] getCertLength() {
        return null;
    }

    int getNumOfCert() {
        return 0;
    }

    AccessControlContext getAccessControlContext() {
        return this.ctx;
    }

    static SecurityContext getCurrentSecurityContext() {
        AccessControlContext accessControlContext = AccessController.getContext();
        try {
            return (SecurityContext)AccessController.doPrivileged(new PrivilegedBlockAction(accessControlContext));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.securityPrintException(privilegedActionException);
            return new SecurityContext(null, accessControlContext);
        }
    }

    static class PrivilegedBlockAction
    implements PrivilegedExceptionAction {
        AccessControlContext ctx;

        PrivilegedBlockAction(AccessControlContext accessControlContext) {
            this.ctx = accessControlContext;
        }

        public Object run() throws Exception {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && securityManager instanceof ActivatorSecurityManager) {
                ActivatorSecurityManager activatorSecurityManager = (ActivatorSecurityManager)((Object)securityManager);
                Class[] classArray = activatorSecurityManager.getExecutionStackContext();
                int n = 0;
                while (n < classArray.length) {
                    Class clazz = classArray[n];
                    ClassLoader classLoader = clazz.getClassLoader();
                    if (classLoader instanceof AppletClassLoader) {
                        return new SecurityContext(clazz.getProtectionDomain(), this.ctx);
                    }
                    ++n;
                }
            }
            return new SecurityContext(null, this.ctx);
        }
    }
}

