/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "basics.h"
#include "camera.h"


void CameraMat(Matrix m, const Camera *cam)
{
	Matrix r, t;

	// align the uvn camera axes with the xyz world axes
	r[0][0] = cam->u[0]; r[0][1] = cam->u[1]; r[0][2] = cam->u[2]; r[0][3] = 0.0f;
	r[1][0] = cam->v[0]; r[1][1] = cam->v[1]; r[1][2] = cam->v[2]; r[1][3] = 0.0f;
	r[2][0] = cam->n[0]; r[2][1] = cam->n[1]; r[2][2] = cam->n[2]; r[2][3] = 0.0f;
	r[3][0] =      0.0f; r[3][1] =      0.0f; r[3][2] =      0.0f; r[3][3] = 1.0f;

	TranslateMat(t, -cam->pos[X], -cam->pos[Y], -cam->pos[Z]);
//	float d = 0.0f;
//	TranslateMat(t, -cam->pos[X] + d*cam->n[0], -cam->pos[Y] + d*cam->n[1], -cam->pos[Z] + d*cam->n[2]);

	MatMultMat3x4(m, r, t);
}
