# OK, we're going to try a new approach.  For the original set of /etc config
# files, if the file exists in /etc already, we don't copy the new one into
# place.  tcpip.tgz is really one of the few packages in Slackware to contain
# a lot of configuration files, and the "starter" files in /etc have changed
# *very little* over the years.  If we *really* want to force replacement of
# one of these files, we can always add another /etc directory to this package,
# right?  As it is, 99% of the people who already have these files don't want
# them replaced.
cd etc-incoming
for file in * */* ; do
 if [ ! -d file ]; then # file is not a directory
  if [ ! -r ../etc/$file ]; then # file isn't already in /etc, so copy it.
   cp -a $file ../etc/$file
  fi
 fi
done
cd ..
rm -rf etc-incoming
if [ ! -r var/lib/nfs/rmtab ]; then
  touch var/lib/nfs/rmtab
  chmod 644 var/lib/nfs/rmtab
fi
if [ ! -r var/lib/nfs/xtab ]; then
  touch var/lib/nfs/xtab
  chmod 644 var/lib/nfs/xtab
fi
if [ ! -r var/lib/nfs/etab ]; then
  touch var/lib/nfs/etab
  chmod 644 var/lib/nfs/etab
fi
( cd sbin ; rm -rf netconfig )
( cd sbin ; ln -sf netconfig.color netconfig )
( cd usr/sbin ; rm -rf in.ntalkd )
( cd usr/sbin ; ln -sf in.talkd in.ntalkd )
( cd usr/bin ; rm -rf ntalk )
( cd usr/bin ; ln -sf talk ntalk )
( cd usr/bin ; rm -rf inews )
( cd usr/bin ; ln -sf inews-nntp inews )
( cd bin ; rm -rf dnsdomainname )
( cd bin ; ln -sf hostname dnsdomainname )
( cd bin ; rm -rf nisdomainname )
( cd bin ; ln -sf hostname nisdomainname )
( cd bin ; rm -rf ypdomainname )
( cd bin ; ln -sf hostname ypdomainname )
( cd usr/man/man8 ; rm -rf rpc.lockd.8.gz )
( cd usr/man/man8 ; ln -sf lockd.8.gz rpc.lockd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.mountd.8.gz )
( cd usr/man/man8 ; ln -sf mountd.8.gz rpc.mountd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.nfsd.8.gz )
( cd usr/man/man8 ; ln -sf nfsd.8.gz rpc.nfsd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.rquotad.8.gz )
( cd usr/man/man8 ; ln -sf rquotad.8.gz rpc.rquotad.8.gz )
( cd usr/man/man8 ; rm -rf rpc.statd.8.gz )
( cd usr/man/man8 ; ln -sf statd.8.gz rpc.statd.8.gz )
