/*
 * Copyright 1999 Silicon Graphics, Inc.
 */
#ifndef _STRING_H_
#define _STRING_H_

#include "stddef.h"

extern size_t strlen(const char *s);
extern int strncmp(const char *s1, const char *s2, size_t n);
extern char *strchr(const char *s, int c);
extern char *strcpy(char *s1, const char *s2);
extern char *strncpy(char *s1, const char *s2, size_t n);
extern char *strdup(const char *s1);

extern void *memcpy(void *s1, const void *s2, size_t n);
extern void *memset(void *s, int c, size_t n);
extern void __bzero(char *p, int len);

#endif /* _STRING_H_ */
