/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIDiskDocument.idl
 */

#ifndef __gen_nsIDiskDocument_h__
#define __gen_nsIDiskDocument_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIFile_h__
#include "nsIFile.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIDiskDocument */
#define NS_IDISKDOCUMENT_IID_STR "dd038282-d5a2-11d4-aedb-e1c4b1c8b9fc"

#define NS_IDISKDOCUMENT_IID \
  {0xdd038282, 0xd5a2, 0x11d4, \
    { 0xae, 0xdb, 0xe1, 0xc4, 0xb1, 0xc8, 0xb9, 0xfc }}

class NS_NO_VTABLE nsIDiskDocument : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IDISKDOCUMENT_IID)

  /** An nsIFile pointing to the location of the file on disk. May be null if
    *  this document has not been saved yet
    */
  /* readonly attribute nsIFile fileSpec; */
  NS_IMETHOD GetFileSpec(nsIFile * *aFileSpec) = 0;

  /** The modification count for the document. A +ve mod count indicates
    * that the document is dirty, and needs saving.
    */
  /* readonly attribute long modificationCount; */
  NS_IMETHOD GetModificationCount(PRInt32 *aModificationCount) = 0;

  /** Initialize the document output. This may be called on document
    * creation, or lazily before the first save. For a document read
    * in from disk, it should be called on document instantiation.
    *
    * @param aFile			    nsIFile for the file, if a disk version
    *												of the file exists already. Otherwise nsnull.
    */
  /* void InitDiskDocument (in nsIFile aFile); */
  NS_IMETHOD InitDiskDocument(nsIFile *aFile) = 0;

  /** Save the file to disk. This will be called after the caller has
    * displayed a put file dialog, which the user confirmed. The internal
    * fileSpec of the document is only updated with the given fileSpec if inSaveCopy == PR_FALSE.
    *    
    * @param aFile					    File to which to stream the document.
    * @param aReplaceExisting	  true if replacing an existing file, otherwise false.
    *    												If false and aFile exists, SaveFile returns an error.
    * @param aSaveCopy					True to save a copy of the file, without changing the file
    *														referenced internally.
    * @param aFileType			    Mime type to save (text/plain or text/html)
    * @param aFileCharset			  Charset to save the document in. If this is an empty
    *    												string, or "UCS2", then the doc will be saved as Unicode.
    * @param aSaveFlags         Flags used by the document encoder (see nsIDocumentEncoder).
    * @param inWrapColumn       Wrap column, assuming that flags specify wrapping.
    */
  /* void SaveFile (in nsIFile aFile, in boolean aReplaceExisting, in boolean aSaveCopy, in wstring aFileType, in wstring aFileCharset, in unsigned long aSaveFlags, in unsigned long aWrapColumn); */
  NS_IMETHOD SaveFile(nsIFile *aFile, PRBool aReplaceExisting, PRBool aSaveCopy, const PRUnichar *aFileType, const PRUnichar *aFileCharset, PRUint32 aSaveFlags, PRUint32 aWrapColumn) = 0;

  /** Reset the modification count for the document. This marks the documents as
    * 'clean' and not in need of saving.
    */
  /* void ResetModificationCount (); */
  NS_IMETHOD ResetModificationCount(void) = 0;

  /** Increment the modification count for the document by the given
    * amount (which may be -ve).
    */
  /* void IncrementModificationCount (in long aNumMods); */
  NS_IMETHOD IncrementModificationCount(PRInt32 aNumMods) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDISKDOCUMENT \
  NS_IMETHOD GetFileSpec(nsIFile * *aFileSpec); \
  NS_IMETHOD GetModificationCount(PRInt32 *aModificationCount); \
  NS_IMETHOD InitDiskDocument(nsIFile *aFile); \
  NS_IMETHOD SaveFile(nsIFile *aFile, PRBool aReplaceExisting, PRBool aSaveCopy, const PRUnichar *aFileType, const PRUnichar *aFileCharset, PRUint32 aSaveFlags, PRUint32 aWrapColumn); \
  NS_IMETHOD ResetModificationCount(void); \
  NS_IMETHOD IncrementModificationCount(PRInt32 aNumMods); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDISKDOCUMENT(_to) \
  NS_IMETHOD GetFileSpec(nsIFile * *aFileSpec) { return _to ## GetFileSpec(aFileSpec); } \
  NS_IMETHOD GetModificationCount(PRInt32 *aModificationCount) { return _to ## GetModificationCount(aModificationCount); } \
  NS_IMETHOD InitDiskDocument(nsIFile *aFile) { return _to ## InitDiskDocument(aFile); } \
  NS_IMETHOD SaveFile(nsIFile *aFile, PRBool aReplaceExisting, PRBool aSaveCopy, const PRUnichar *aFileType, const PRUnichar *aFileCharset, PRUint32 aSaveFlags, PRUint32 aWrapColumn) { return _to ## SaveFile(aFile, aReplaceExisting, aSaveCopy, aFileType, aFileCharset, aSaveFlags, aWrapColumn); } \
  NS_IMETHOD ResetModificationCount(void) { return _to ## ResetModificationCount(); } \
  NS_IMETHOD IncrementModificationCount(PRInt32 aNumMods) { return _to ## IncrementModificationCount(aNumMods); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDISKDOCUMENT(_to) \
  NS_IMETHOD GetFileSpec(nsIFile * *aFileSpec) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileSpec(aFileSpec); } \
  NS_IMETHOD GetModificationCount(PRInt32 *aModificationCount) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetModificationCount(aModificationCount); } \
  NS_IMETHOD InitDiskDocument(nsIFile *aFile) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InitDiskDocument(aFile); } \
  NS_IMETHOD SaveFile(nsIFile *aFile, PRBool aReplaceExisting, PRBool aSaveCopy, const PRUnichar *aFileType, const PRUnichar *aFileCharset, PRUint32 aSaveFlags, PRUint32 aWrapColumn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SaveFile(aFile, aReplaceExisting, aSaveCopy, aFileType, aFileCharset, aSaveFlags, aWrapColumn); } \
  NS_IMETHOD ResetModificationCount(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ResetModificationCount(); } \
  NS_IMETHOD IncrementModificationCount(PRInt32 aNumMods) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IncrementModificationCount(aNumMods); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDiskDocument : public nsIDiskDocument
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDISKDOCUMENT

  nsDiskDocument();
  virtual ~nsDiskDocument();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDiskDocument, nsIDiskDocument)

nsDiskDocument::nsDiskDocument()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsDiskDocument::~nsDiskDocument()
{
  /* destructor code */
}

/* readonly attribute nsIFile fileSpec; */
NS_IMETHODIMP nsDiskDocument::GetFileSpec(nsIFile * *aFileSpec)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long modificationCount; */
NS_IMETHODIMP nsDiskDocument::GetModificationCount(PRInt32 *aModificationCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InitDiskDocument (in nsIFile aFile); */
NS_IMETHODIMP nsDiskDocument::InitDiskDocument(nsIFile *aFile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SaveFile (in nsIFile aFile, in boolean aReplaceExisting, in boolean aSaveCopy, in wstring aFileType, in wstring aFileCharset, in unsigned long aSaveFlags, in unsigned long aWrapColumn); */
NS_IMETHODIMP nsDiskDocument::SaveFile(nsIFile *aFile, PRBool aReplaceExisting, PRBool aSaveCopy, const PRUnichar *aFileType, const PRUnichar *aFileCharset, PRUint32 aSaveFlags, PRUint32 aWrapColumn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ResetModificationCount (); */
NS_IMETHODIMP nsDiskDocument::ResetModificationCount()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void IncrementModificationCount (in long aNumMods); */
NS_IMETHODIMP nsDiskDocument::IncrementModificationCount(PRInt32 aNumMods)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDiskDocument_h__ */
