/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIRequest.idl
 */

#ifndef __gen_nsIRequest_h__
#define __gen_nsIRequest_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsILoadGroup; /* forward declaration */

typedef PRUint32 nsLoadFlags;


/* starting interface:    nsIRequest */
#define NS_IREQUEST_IID_STR "f2caaba0-2f25-11d3-a164-0050041caf44"

#define NS_IREQUEST_IID \
  {0xf2caaba0, 0x2f25, 0x11d3, \
    { 0xa1, 0x64, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 }}

/**
 * nsIRequest
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIRequest : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IREQUEST_IID)

  /**
     * Returns the name of the request.  Often this is the URL of the request.
     */
  /* readonly attribute wstring name; */
  NS_IMETHOD GetName(PRUnichar * *aName) = 0;

  /**
     * Returns true if the request is pending (active).  Returns false 
     * after completion or successful calling Cancel.  Suspended requests
     * are still considered pending.
     */
  /* boolean isPending (); */
  NS_IMETHOD IsPending(PRBool *_retval) = 0;

  /**
     * Returns any error status associated with the request.
     */
  /* readonly attribute nsresult status; */
  NS_IMETHOD GetStatus(nsresult *aStatus) = 0;

  /**
     * Cancels the current request.  This will close any open input or
     * output streams and terminate any async requests.  Users should 
     * normally pass NS_BINDING_ABORTED, although other errors may also
     * be passed.  The error passed in will become the value of the 
     * status attribute.
     */
  /* void cancel (in nsresult status); */
  NS_IMETHOD Cancel(nsresult status) = 0;

  /**
     * Suspends the current requests.  This may have the effect of closing
     * any underlying transport (in order to free up resources), although
     * any open streams remain logically opened and will continue delivering
     * data when the transport is resumed. 
     */
  /* void suspend (); */
  NS_IMETHOD Suspend(void) = 0;

  /**
     * Resumes the current request.  This may have the effect of re-opening
     * any underlying transport and will resume the delivery of data to 
     * any open streams. 
     */
  /* void resume (); */
  NS_IMETHOD Resume(void) = 0;

  /**
     * Accesses the load group in which this request is currently a member.
     */
  /* attribute nsILoadGroup loadGroup; */
  NS_IMETHOD GetLoadGroup(nsILoadGroup * *aLoadGroup) = 0;
  NS_IMETHOD SetLoadGroup(nsILoadGroup * aLoadGroup) = 0;

  /**
     * Accesses the load flags for this request.  Bits 0-15 are defined (or
     * reserved) by nsIRequest.  When added to a load group, this request's
     * load flags are merged with the load flags of the load group.
     */
  /* attribute nsLoadFlags loadFlags; */
  NS_IMETHOD GetLoadFlags(nsLoadFlags *aLoadFlags) = 0;
  NS_IMETHOD SetLoadFlags(nsLoadFlags aLoadFlags) = 0;

  /**************************************************************************
     * Listed below are the various load flags which may be or'd together.
     */
/**
     * No special load flags:
     */
  enum { LOAD_NORMAL = 0U };

  /** 
     * Don't deliver status notifications to the nsIProgressEventSink, or keep 
     * this load from completing the nsILoadGroup it may belong to.
     */
  enum { LOAD_BACKGROUND = 1U };

  /**************************************************************************
     * The following flags control the flow of data into the cache.
     */
/**
     * This flag prevents caching of any kind.  It does not, however, prevent
     * cached content from being used to satisfy this request.
     */
  enum { INHIBIT_CACHING = 128U };

  /**
     * This flag prevents caching on disk (or other persistent media), which
     * may be needed to preserve privacy.  For HTTPS, this flag is set auto-
     * matically.
     */
  enum { INHIBIT_PERSISTENT_CACHING = 256U };

  /**************************************************************************
     * The following flags control what happens when the cache contains data
     * that could perhaps satisfy this request.  They are listed in descending
     * order of precidence.
     */
/**
     * Force an end-to-end download of content data from the origin server.
     * This flag is used for a shift-reload.
     */
  enum { LOAD_BYPASS_CACHE = 512U };

  /**
     * Load from the cache, bypassing protocol specific validation logic.  This
     * flag is used when browsing via history.  It is not recommended for normal
     * browsing as it may likely violate reasonable assumptions made by the 
     * server and confuse users.
     */
  enum { LOAD_FROM_CACHE = 1024U };

  /**
     * The following flags control the frequency of cached content validation
     * when neither LOAD_BYPASS_CACHE or LOAD_FROM_CACHE are set.  By default,
     * cached content is automatically validated if necessary before reuse.
     * 
     * VALIDATE_ALWAYS forces validation of any cached content independent of
     * its expiration time.
     * 
     * VALIDATE_NEVER disables validation of expired content.
     *
     * VALIDATE_ONCE_PER_SESSION disables validation of expired content, 
     * provided it has already been validated (at least once) since the start 
     * of this session.
     *
     * NOTE TO IMPLEMENTORS:
     *   These flags are intended for normal browsing, and they should therefore
     *   not apply to content that must be validated before each use.  Consider,
     *   for example, a HTTP response with a "Cache-control: no-cache" header.
     *   According to RFC2616, this response must be validated before it can
     *   be taken from a cache.  Breaking this requirement could result in 
     *   incorrect and potentially unpleasant side-effects.
     */
  enum { VALIDATE_ALWAYS = 2048U };

  enum { VALIDATE_NEVER = 4096U };

  enum { VALIDATE_ONCE_PER_SESSION = 8192U };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIREQUEST \
  NS_IMETHOD GetName(PRUnichar * *aName); \
  NS_IMETHOD IsPending(PRBool *_retval); \
  NS_IMETHOD GetStatus(nsresult *aStatus); \
  NS_IMETHOD Cancel(nsresult status); \
  NS_IMETHOD Suspend(void); \
  NS_IMETHOD Resume(void); \
  NS_IMETHOD GetLoadGroup(nsILoadGroup * *aLoadGroup); \
  NS_IMETHOD SetLoadGroup(nsILoadGroup * aLoadGroup); \
  NS_IMETHOD GetLoadFlags(nsLoadFlags *aLoadFlags); \
  NS_IMETHOD SetLoadFlags(nsLoadFlags aLoadFlags); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIREQUEST(_to) \
  NS_IMETHOD GetName(PRUnichar * *aName) { return _to ## GetName(aName); } \
  NS_IMETHOD IsPending(PRBool *_retval) { return _to ## IsPending(_retval); } \
  NS_IMETHOD GetStatus(nsresult *aStatus) { return _to ## GetStatus(aStatus); } \
  NS_IMETHOD Cancel(nsresult status) { return _to ## Cancel(status); } \
  NS_IMETHOD Suspend(void) { return _to ## Suspend(); } \
  NS_IMETHOD Resume(void) { return _to ## Resume(); } \
  NS_IMETHOD GetLoadGroup(nsILoadGroup * *aLoadGroup) { return _to ## GetLoadGroup(aLoadGroup); } \
  NS_IMETHOD SetLoadGroup(nsILoadGroup * aLoadGroup) { return _to ## SetLoadGroup(aLoadGroup); } \
  NS_IMETHOD GetLoadFlags(nsLoadFlags *aLoadFlags) { return _to ## GetLoadFlags(aLoadFlags); } \
  NS_IMETHOD SetLoadFlags(nsLoadFlags aLoadFlags) { return _to ## SetLoadFlags(aLoadFlags); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIREQUEST(_to) \
  NS_IMETHOD GetName(PRUnichar * *aName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetName(aName); } \
  NS_IMETHOD IsPending(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsPending(_retval); } \
  NS_IMETHOD GetStatus(nsresult *aStatus) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetStatus(aStatus); } \
  NS_IMETHOD Cancel(nsresult status) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Cancel(status); } \
  NS_IMETHOD Suspend(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Suspend(); } \
  NS_IMETHOD Resume(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Resume(); } \
  NS_IMETHOD GetLoadGroup(nsILoadGroup * *aLoadGroup) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLoadGroup(aLoadGroup); } \
  NS_IMETHOD SetLoadGroup(nsILoadGroup * aLoadGroup) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLoadGroup(aLoadGroup); } \
  NS_IMETHOD GetLoadFlags(nsLoadFlags *aLoadFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLoadFlags(aLoadFlags); } \
  NS_IMETHOD SetLoadFlags(nsLoadFlags aLoadFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLoadFlags(aLoadFlags); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsRequest : public nsIRequest
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIREQUEST

  nsRequest();
  virtual ~nsRequest();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsRequest, nsIRequest)

nsRequest::nsRequest()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsRequest::~nsRequest()
{
  /* destructor code */
}

/* readonly attribute wstring name; */
NS_IMETHODIMP nsRequest::GetName(PRUnichar * *aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isPending (); */
NS_IMETHODIMP nsRequest::IsPending(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsresult status; */
NS_IMETHODIMP nsRequest::GetStatus(nsresult *aStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancel (in nsresult status); */
NS_IMETHODIMP nsRequest::Cancel(nsresult status)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void suspend (); */
NS_IMETHODIMP nsRequest::Suspend()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resume (); */
NS_IMETHODIMP nsRequest::Resume()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsILoadGroup loadGroup; */
NS_IMETHODIMP nsRequest::GetLoadGroup(nsILoadGroup * *aLoadGroup)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsRequest::SetLoadGroup(nsILoadGroup * aLoadGroup)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsLoadFlags loadFlags; */
NS_IMETHODIMP nsRequest::GetLoadFlags(nsLoadFlags *aLoadFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsRequest::SetLoadFlags(nsLoadFlags aLoadFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIRequest_h__ */
