/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef SOUNDSERVER_H
#define SOUNDSERVER_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"
#include "kmedia2.h"

namespace Arts {
enum RealtimeStatus {rtRealtime = 0, rtNoSupport = 1, rtNoWrapper = 2, rtNoRealtime = 3};
};
namespace Arts {
class ByteSoundProducer;
class SimpleSoundServer;
class SoundServer;
class WavPlayObject;

class ByteSoundProducer_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteSoundProducer_base *_create(const std::string& subClass = "Arts::ByteSoundProducer");
	static ByteSoundProducer_base *_fromString(std::string objectref);
	static ByteSoundProducer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline ByteSoundProducer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual long channels() = 0;
	virtual long bits() = 0;
};

class ByteSoundProducer_stub : virtual public ByteSoundProducer_base, virtual public Arts::SynthModule_stub {
protected:
	ByteSoundProducer_stub();

public:
	ByteSoundProducer_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	long channels();
	long bits();
};

class ByteSoundProducer_skel : virtual public ByteSoundProducer_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream outdata;            // outgoing stream

	// handler for asynchronous streams
	virtual void request_outdata(Arts::DataPacket<Arts::mcopbyte> *);

protected:
	// emitters for change notifications
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}

public:
	ByteSoundProducer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

};
#include "reference.h"
namespace Arts {
class ByteSoundProducer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteSoundProducer_base *_cache;
	inline ByteSoundProducer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteSoundProducer_base *)_pool->base->_cast(ByteSoundProducer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteSoundProducer(ByteSoundProducer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ByteSoundProducer_base _base_class;

	inline ByteSoundProducer() : Arts::Object(_Creator), _cache(0) {}
	inline ByteSoundProducer(const Arts::SubClass& s) :
		Arts::Object(ByteSoundProducer_base::_create(s.string())), _cache(0) {}
	inline ByteSoundProducer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteSoundProducer_base::_fromString(r.string())):(ByteSoundProducer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteSoundProducer(const Arts::DynamicCast& c) : Arts::Object(ByteSoundProducer_base::_fromString(c.object().toString())), _cache(0) {}
	inline ByteSoundProducer(const ByteSoundProducer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteSoundProducer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteSoundProducer null() {return ByteSoundProducer((ByteSoundProducer_base*)0);}
	inline static ByteSoundProducer _from_base(ByteSoundProducer_base* b) {return ByteSoundProducer(b);}
	inline ByteSoundProducer& operator=(const ByteSoundProducer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteSoundProducer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline long channels();
	inline long bits();
};

class SimpleSoundServer_base : virtual public Arts::PlayObjectFactory_base {
public:
	static unsigned long _IID; // interface ID

	static SimpleSoundServer_base *_create(const std::string& subClass = "Arts::SimpleSoundServer");
	static SimpleSoundServer_base *_fromString(std::string objectref);
	static SimpleSoundServer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline SimpleSoundServer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::StereoEffectStack outstack() = 0;
	virtual float minStreamBufferTime() = 0;
	virtual float serverBufferTime() = 0;
	virtual long play(const std::string& filename) = 0;
	virtual void attach(Arts::ByteSoundProducer producer) = 0;
	virtual void detach(Arts::ByteSoundProducer producer) = 0;
	virtual Arts::Object createObject(const std::string& name) = 0;
};

class SimpleSoundServer_stub : virtual public SimpleSoundServer_base, virtual public Arts::PlayObjectFactory_stub {
protected:
	SimpleSoundServer_stub();

public:
	SimpleSoundServer_stub(Arts::Connection *connection, long objectID);

	Arts::StereoEffectStack outstack();
	float minStreamBufferTime();
	float serverBufferTime();
	long play(const std::string& filename);
	void attach(Arts::ByteSoundProducer producer);
	void detach(Arts::ByteSoundProducer producer);
	Arts::Object createObject(const std::string& name);
};

class SimpleSoundServer_skel : virtual public SimpleSoundServer_base, virtual public Arts::PlayObjectFactory_skel {
protected:
	// emitters for change notifications
	inline void minStreamBufferTime_changed(float newValue) {
		_emit_changed("minStreamBufferTime_changed",newValue);
	}
	inline void serverBufferTime_changed(float newValue) {
		_emit_changed("serverBufferTime_changed",newValue);
	}

public:
	SimpleSoundServer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SimpleSoundServer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SimpleSoundServer_base *_cache;
	inline SimpleSoundServer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SimpleSoundServer_base *)_pool->base->_cast(SimpleSoundServer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SimpleSoundServer(SimpleSoundServer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SimpleSoundServer_base _base_class;

	inline SimpleSoundServer() : Arts::Object(_Creator), _cache(0) {}
	inline SimpleSoundServer(const Arts::SubClass& s) :
		Arts::Object(SimpleSoundServer_base::_create(s.string())), _cache(0) {}
	inline SimpleSoundServer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SimpleSoundServer_base::_fromString(r.string())):(SimpleSoundServer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SimpleSoundServer(const Arts::DynamicCast& c) : Arts::Object(SimpleSoundServer_base::_fromString(c.object().toString())), _cache(0) {}
	inline SimpleSoundServer(const SimpleSoundServer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SimpleSoundServer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SimpleSoundServer null() {return SimpleSoundServer((SimpleSoundServer_base*)0);}
	inline static SimpleSoundServer _from_base(SimpleSoundServer_base* b) {return SimpleSoundServer(b);}
	inline SimpleSoundServer& operator=(const SimpleSoundServer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline SimpleSoundServer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::StereoEffectStack outstack();
	inline float minStreamBufferTime();
	inline float serverBufferTime();
	inline long play(const std::string& filename);
	inline void attach(Arts::ByteSoundProducer producer);
	inline void detach(Arts::ByteSoundProducer producer);
	inline Arts::Object createObject(const std::string& name);
};

class SoundServer_base : virtual public Arts::SimpleSoundServer_base {
public:
	static unsigned long _IID; // interface ID

	static SoundServer_base *_create(const std::string& subClass = "Arts::SoundServer");
	static SoundServer_base *_fromString(std::string objectref);
	static SoundServer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline SoundServer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::RealtimeStatus realtimeStatus() = 0;
	virtual long secondsUntilSuspend() = 0;
	virtual bool suspend() = 0;
	virtual bool terminate() = 0;
};

class SoundServer_stub : virtual public SoundServer_base, virtual public Arts::SimpleSoundServer_stub {
protected:
	SoundServer_stub();

public:
	SoundServer_stub(Arts::Connection *connection, long objectID);

	Arts::RealtimeStatus realtimeStatus();
	long secondsUntilSuspend();
	bool suspend();
	bool terminate();
};

class SoundServer_skel : virtual public SoundServer_base, virtual public Arts::SimpleSoundServer_skel {
protected:
	// emitters for change notifications
	inline void secondsUntilSuspend_changed(long newValue) {
		_emit_changed("secondsUntilSuspend_changed",newValue);
	}

public:
	SoundServer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SoundServer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SoundServer_base *_cache;
	inline SoundServer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SoundServer_base *)_pool->base->_cast(SoundServer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SoundServer(SoundServer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SoundServer_base _base_class;

	inline SoundServer() : Arts::Object(_Creator), _cache(0) {}
	inline SoundServer(const Arts::SubClass& s) :
		Arts::Object(SoundServer_base::_create(s.string())), _cache(0) {}
	inline SoundServer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SoundServer_base::_fromString(r.string())):(SoundServer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SoundServer(const Arts::DynamicCast& c) : Arts::Object(SoundServer_base::_fromString(c.object().toString())), _cache(0) {}
	inline SoundServer(const SoundServer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SoundServer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SoundServer null() {return SoundServer((SoundServer_base*)0);}
	inline static SoundServer _from_base(SoundServer_base* b) {return SoundServer(b);}
	inline SoundServer& operator=(const SoundServer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SimpleSoundServer() const { return Arts::SimpleSoundServer(*_pool); }
	inline operator Arts::PlayObjectFactory() const { return Arts::PlayObjectFactory(*_pool); }
	inline SoundServer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::StereoEffectStack outstack();
	inline float minStreamBufferTime();
	inline float serverBufferTime();
	inline long play(const std::string& filename);
	inline void attach(Arts::ByteSoundProducer producer);
	inline void detach(Arts::ByteSoundProducer producer);
	inline Arts::Object createObject(const std::string& name);
	inline Arts::PlayObject createPlayObject(const std::string& filename);
	inline Arts::RealtimeStatus realtimeStatus();
	inline long secondsUntilSuspend();
	inline bool suspend();
	inline bool terminate();
};

class WavPlayObject_base : virtual public Arts::PlayObject_base,
	virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static WavPlayObject_base *_create(const std::string& subClass = "Arts::WavPlayObject");
	static WavPlayObject_base *_fromString(std::string objectref);
	static WavPlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline WavPlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class WavPlayObject_stub : virtual public WavPlayObject_base, virtual public Arts::PlayObject_stub,
	virtual public Arts::SynthModule_stub {
protected:
	WavPlayObject_stub();

public:
	WavPlayObject_stub(Arts::Connection *connection, long objectID);

};

class WavPlayObject_skel : virtual public WavPlayObject_base, virtual public Arts::PlayObject_skel,
	virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	WavPlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class WavPlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	WavPlayObject_base *_cache;
	inline WavPlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(WavPlayObject_base *)_pool->base->_cast(WavPlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline WavPlayObject(WavPlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef WavPlayObject_base _base_class;

	inline WavPlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline WavPlayObject(const Arts::SubClass& s) :
		Arts::Object(WavPlayObject_base::_create(s.string())), _cache(0) {}
	inline WavPlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(WavPlayObject_base::_fromString(r.string())):(WavPlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline WavPlayObject(const Arts::DynamicCast& c) : Arts::Object(WavPlayObject_base::_fromString(c.object().toString())), _cache(0) {}
	inline WavPlayObject(const WavPlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline WavPlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static WavPlayObject null() {return WavPlayObject((WavPlayObject_base*)0);}
	inline static WavPlayObject _from_base(WavPlayObject_base* b) {return WavPlayObject(b);}
	inline WavPlayObject& operator=(const WavPlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObject() const { return Arts::PlayObject(*_pool); }
	inline operator Arts::PlayObject_private() const { return Arts::PlayObject_private(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline WavPlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline std::string description();
	inline Arts::poTime currentTime();
	inline Arts::poTime overallTime();
	inline Arts::poCapabilities capabilities();
	inline std::string mediaName();
	inline Arts::poState state();
	inline void play();
	inline void seek(const Arts::poTime& newTime);
	inline void pause();
	inline void halt();
	inline bool loadMedia(const std::string& filename);
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

// Forward wrapper calls to _base classes:

inline Arts::AutoSuspendState Arts::ByteSoundProducer::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteSoundProducer::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteSoundProducer::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteSoundProducer::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteSoundProducer::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteSoundProducer::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::ByteSoundProducer::samplingRate()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->samplingRate():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->samplingRate();
}

inline long Arts::ByteSoundProducer::channels()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->channels():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->channels();
}

inline long Arts::ByteSoundProducer::bits()
{
	return _cache?static_cast<Arts::ByteSoundProducer_base*>(_cache)->bits():static_cast<Arts::ByteSoundProducer_base*>(_method_call())->bits();
}

inline Arts::PlayObject Arts::SimpleSoundServer::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::StereoEffectStack Arts::SimpleSoundServer::outstack()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->outstack():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->outstack();
}

inline float Arts::SimpleSoundServer::minStreamBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->minStreamBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->minStreamBufferTime();
}

inline float Arts::SimpleSoundServer::serverBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->serverBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->serverBufferTime();
}

inline long Arts::SimpleSoundServer::play(const std::string& filename)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->play(filename):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->play(filename);
}

inline void Arts::SimpleSoundServer::attach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attach(producer);
}

inline void Arts::SimpleSoundServer::detach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detach(producer);
}

inline Arts::Object Arts::SimpleSoundServer::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->createObject(name):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->createObject(name);
}

inline Arts::StereoEffectStack Arts::SoundServer::outstack()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->outstack():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->outstack();
}

inline float Arts::SoundServer::minStreamBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->minStreamBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->minStreamBufferTime();
}

inline float Arts::SoundServer::serverBufferTime()
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->serverBufferTime():static_cast<Arts::SimpleSoundServer_base*>(_method_call())->serverBufferTime();
}

inline long Arts::SoundServer::play(const std::string& filename)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->play(filename):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->play(filename);
}

inline void Arts::SoundServer::attach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->attach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->attach(producer);
}

inline void Arts::SoundServer::detach(Arts::ByteSoundProducer producer)
{
	 _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->detach(producer):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->detach(producer);
}

inline Arts::Object Arts::SoundServer::createObject(const std::string& name)
{
	return _cache?static_cast<Arts::SimpleSoundServer_base*>(_cache)->createObject(name):static_cast<Arts::SimpleSoundServer_base*>(_method_call())->createObject(name);
}

inline Arts::PlayObject Arts::SoundServer::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

inline Arts::RealtimeStatus Arts::SoundServer::realtimeStatus()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->realtimeStatus():static_cast<Arts::SoundServer_base*>(_method_call())->realtimeStatus();
}

inline long Arts::SoundServer::secondsUntilSuspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->secondsUntilSuspend():static_cast<Arts::SoundServer_base*>(_method_call())->secondsUntilSuspend();
}

inline bool Arts::SoundServer::suspend()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->suspend():static_cast<Arts::SoundServer_base*>(_method_call())->suspend();
}

inline bool Arts::SoundServer::terminate()
{
	return _cache?static_cast<Arts::SoundServer_base*>(_cache)->terminate():static_cast<Arts::SoundServer_base*>(_method_call())->terminate();
}

inline std::string Arts::WavPlayObject::description()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->description():static_cast<Arts::PlayObject_base*>(_method_call())->description();
}

inline Arts::poTime Arts::WavPlayObject::currentTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->currentTime():static_cast<Arts::PlayObject_base*>(_method_call())->currentTime();
}

inline Arts::poTime Arts::WavPlayObject::overallTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->overallTime():static_cast<Arts::PlayObject_base*>(_method_call())->overallTime();
}

inline Arts::poCapabilities Arts::WavPlayObject::capabilities()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->capabilities():static_cast<Arts::PlayObject_base*>(_method_call())->capabilities();
}

inline std::string Arts::WavPlayObject::mediaName()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->mediaName():static_cast<Arts::PlayObject_base*>(_method_call())->mediaName();
}

inline Arts::poState Arts::WavPlayObject::state()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->state():static_cast<Arts::PlayObject_base*>(_method_call())->state();
}

inline void Arts::WavPlayObject::play()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->play():static_cast<Arts::PlayObject_base*>(_method_call())->play();
}

inline void Arts::WavPlayObject::seek(const Arts::poTime& newTime)
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->seek(newTime):static_cast<Arts::PlayObject_base*>(_method_call())->seek(newTime);
}

inline void Arts::WavPlayObject::pause()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->pause():static_cast<Arts::PlayObject_base*>(_method_call())->pause();
}

inline void Arts::WavPlayObject::halt()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->halt():static_cast<Arts::PlayObject_base*>(_method_call())->halt();
}

inline bool Arts::WavPlayObject::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline Arts::AutoSuspendState Arts::WavPlayObject::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::WavPlayObject::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::WavPlayObject::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::WavPlayObject::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::WavPlayObject::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::WavPlayObject::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

};
#endif /* SOUNDSERVER_H */
