/** 
 *
 * $Id: ContainerP.h,v 1.4 2000/09/23 14:51:42 amai Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 * Copyright (C) 1995-2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/


#ifndef _XM_CONTAINERP_H
#define _XM_CONTAINERP_H

#include <Xm/Container.h>
#include <Xm/ManagerP.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _XmCwidNodeRec {
	struct _XmCwidNodeRec	*next_ptr, *prev_ptr,
				*child_ptr, *parent_ptr;
	Widget			widget_ptr;
} XmCwidNodeRec, *CwidNode;

typedef struct _XmContainerXfrActionRec {
	Widget		wid;
        XEvent		*event;
        String		*params;
        Cardinal	*num_params;
        Atom		operation;
} XmContainerXfrActionRec, *ContainerXfrAction;

/* Define the container instance part */
typedef struct {
	WidgetList	selected_items;
	Widget		icon_header, anchor_cwid, druggee, size_ob,
			drag_context;
	CwidNode	first_node, last_node;
	Cardinal	*detail_order, *detail_heading;
	XSegment	*outline_segs;
	XtCallbackList	convert_cb, default_action_cb, destination_cb,
			outline_cb, selection_cb;
	XmTabList	detail_tablist;
	XmFontList	render_table;
	Pixel		select_color;
	Pixmap		collapsed_state_pixmap, expanded_state_pixmap;
	GC		normalGC, marqueeGC;
	Time		last_click_time;
	Region		cells_region;
	ContainerXfrAction	transfer_action;
	XtIntervalId	transfer_timer_id;
	XPoint		anchor_point, marquee_start, marquee_end,
			marquee_smallest, marquee_largest, dropspot;
	unsigned long	dynamic_resource;
	int		max_depth, outline_seg_count, *cells, cell_count,
			next_free_cell, current_width_in_cells,
			current_height_in_cells, drag_offset_x, drag_offset_y;
	unsigned int	selected_item_count;
	Cardinal        detail_heading_count, saved_detail_heading_count,
			detail_order_count;
	Dimension	first_col_width, real_first_col_width,
			large_cell_height, large_cell_width, small_cell_height,
			small_cell_width, real_large_cellh, real_large_cellw,
			real_small_cellh, real_small_cellw, margin_h,
			margin_w, outline_indent, ob_width, ob_height,
			prev_width, ideal_width, ideal_height;
	Boolean		first_change_managed, extending_mode, marquee_mode,
			self, toggle_pressed, extend_pressed, ob_pressed,
			cancel_pressed, kaddmode, no_auto_sel_changes,
			started_in_anchor, marquee_drawn, have_primary,
			selecting, large_cell_dim_fixed, small_cell_dim_fixed;
	unsigned char   automatic, entry_viewtype, include_model, layout_type,
			ob_policy, outline_sep_style, spatial_style,
			primary_ownership, resize_model, selection_policy,
			selection_technique, snap_model, create_cwid_type,
			selection_state;
} XmContainerPart;

/* define the full instance record */
typedef struct _XmContainerRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
    XmContainerPart container;
} XmContainerRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmContainerClassPart;

/* Define the full class record */
typedef struct _XmContainerClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
    XmContainerClassPart container_class;
} XmContainerClassRec;

/* Define the Constraint Resources */
typedef struct _XmContainerConstraintPart {
    int unused;
    unsigned char child_type;
    unsigned char child_h_alignment;
    Dimension child_h_spacing;
    unsigned char child_v_alignment;
} XmContainerConstraintPart, *XmContainerContraint;

typedef struct _XmContainerConstraintRec {
    XmManagerConstraintPart manager;
    XmContainerConstraintPart container;
} XmContainerConstraintRec, *XmContainerConstraintPtr;

extern XmContainerClassRec xmContainerClassRec;

#define ContainerMarginHeight(w)	(((XmContainerRec *)(w))->container.margin_h)
#define ContainerMarginWidth(w)		(((XmContainerRec *)(w))->container.margin_w)

#ifdef __cplusplus
}
#endif

#endif /* _XM_CONTAINERP_H */
