/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -2823317246039655811L;
    public static final String FORM = "FORM";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private String nameForm;
    private int ruleID;

    protected LDAPDITStructureRuleSchema() {
    }

    public LDAPDITStructureRuleSchema(String string, int n, String string2, boolean bl, String string3, String[] stringArray) {
        super(string, "", string2, null);
        this.nameForm = string3;
        this.ruleID = n;
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setQualifier("SUP", stringArray);
        }
    }

    public LDAPDITStructureRuleSchema(String string) {
        this.attrName = "ditStructureRules";
        this.parseValue(string);
        Object v = this.properties.get(FORM);
        if (v != null) {
            this.nameForm = (String)v;
        }
        try {
            this.ruleID = Integer.parseInt(this.oid);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String[] getSuperiors() {
        return this.getQualifier("SUP");
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String getValue() {
        String string = "( " + this.ruleID + ' ';
        if (this.name != null) {
            string = String.valueOf(string) + "NAME " + '\'' + this.name + "' ";
        }
        if (this.description != null) {
            string = String.valueOf(string) + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            string = String.valueOf(string) + "OBSOLETE" + ' ';
        }
        string = String.valueOf(string) + "FORM " + this.nameForm + ' ';
        String string2 = this.getValue("SUP", false);
        if (string2 != null && string2.length() > 1) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    public String toString() {
        String[] stringArray;
        String string = "Name: " + this.name + "; ruleID: " + this.ruleID + "; ";
        string = String.valueOf(string) + "Description: " + this.description;
        if (this.isObsolete()) {
            string = String.valueOf(string) + "; OBSOLETE";
        }
        if ((stringArray = this.getSuperiors()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n];
                if (n < stringArray.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        }
        string = String.valueOf(string) + "Name form: " + this.nameForm + "; ";
        string = String.valueOf(string) + this.getQualifierString(IGNOREVALS);
        return string;
    }

    static {
        int n = 0;
        while (n < NOVALS.length) {
            LDAPSchemaElement.novalsTable.put(NOVALS[n], NOVALS[n]);
            ++n;
        }
        IGNOREVALS = new String[]{"OBSOLETE", FORM, "SUP"};
    }
}

