#if 0
;  first.S  -  LILO first stage boot loader with LBA32 support */
Copyright 1992-1998 Werner Almesberger.
Copyright 1999-2000 John Coffman.
All rights reserved.

Licensed under the terms contained in the file 'COPYING' in the 
source directory.

#endif


#define JRC_NOCOMPACT
/*   #define JRC_READ_INLINE		this does not work */

#define LILO_ASM
#include "lilo.h"



	.text

	.globl	_main

	.org	0

_main:	cli			! NT 4 blows up if this is missing
	jmpi	start,BOOTSEG


	.org	6

! Boot device parameters. They are set by the installer.

	.ascii	"LILO"
	.word	STAGE_FIRST
	.word	VERSION

timeout:.word	0		! input timeout
delay:	.word	0		! boot delay
port:	.byte	0		! COM port (0 = unused, 1 = COM1, etc.)
sparam:	.byte	0		! serial port parameters (0 = unused)

tstamp:	.long	0		! timestamp

d1_cx:	.word	0		! first descriptor sector address
d1_dx:	.word	0
d1_al:	.byte	0		! (unused)

d2_cx:	.word	0		! second descriptor sector address
d2_dx:	.word	0
d2_al:	.byte	0		! (unused)

dc_cx:	.word	0		! default command-line sector address
dc_dx:	.word	0
dc_al:	.byte	0		! (unused)

prompt:	.byte	0		! indicates whether to always enter prompt
				! (also used as alignment byte)

ms_len:	.word	0		! initial greeting message
ms_cx:	.word	0
ms_dx:	.word	0
ms_al:	.byte	0		! (unused)

kt_cx:	.word	0		! keyboard translation table
kt_dx:	.word	0
kt_al:	.byte	0

d_addr:				! second stage sector addresses

	.org	CODE_START_1
!  These locations are referenced as EX_OFF and must be at CODE_START_1
ext_si:	.word	0		! external interface
ext_es:	.word	0		! these locations are referenced in second.S
ext_bx:	.word	0		! do not disturb the ordering
ext_dl:	.byte	0		! second.S will check this magic number
ext_dh:	.byte	0		! not referenced, but must align stack
ext_stack:

start:	mov	ax,cs		! set DS and SS
	mov	ss,ax		! funny way to fill in ext_PARAMs
	mov	sp,#ext_stack	!
	push	dx		! set ext_dl (and ext_dh, which is not used)
	push	bx		! WATCH the order of pushes
	push	es		! set ext_es
	push	si		! set ext_si

	mov	sp,#SETUP_STACKSIZE	! set the stack for First Stage
	sti			! now it is safe

go:	mov	ds,ax		! DS = BOOTSEG

	mov	al,#0x0d	! gimme a CR ...
	call	display
	mov	al,#0x0a	! ... an LF ...
	call	display
	mov	al,#0x4c	! ... an 'L' ...
	call	display
	
lagain:	mov	si,#d_addr	! ready to load the second stage loader
#ifdef LCF_LARGE_EBDA
	push	#SECONDSEG
#else
	int	0x12		! get memory available
	shl	ax,#6		! convert to paragraphs
	sub	ax,#DATAEND>>4+0x20	! allow for PARMLINE
	push	ax
#endif
	pop	es
	xor	bx,bx

sload:	lodsw			! get CX
	xchg	cx,ax
	
#ifndef JRC_NOCOMPACT
        lodsw			! get DX
	mov	dx,ax
	or	ax,cx		! at EOF ?
	jz	done		! yes -> start it
        lodsb
        test    dl,#LINEAR_FLAG|LBA32_FLAG
#else
        lodsb
	test    al,#LINEAR_FLAG|LBA32_FLAG
#endif
        jnz     use_linear
#ifdef JRC_NOCOMPACT
        dec     si
	lodsw
	mov     dx,ax
	or      ax,cx
	jz      done
	lodsb
#endif
        mov     ah,#2           ! read command
        int     0x13            ! BIOS read
        jmp     rd_done

use_linear:
#ifndef JRC_NOCOMPACT
        xchg    al,dh           ! save count in DH, address to AL
        mov     ah,hinib        ! linear will get 0
        test    dl,#LBA32_NOCOUNT  ! check if count omitted
        jz      count_ok
        mov     hinib,dh        ! save the hi-nibble
        mov     ah,dh
        mov     dh,#1           ! count is 1
count_ok:
        xchg    ax,di           ! LBA to DI
        mov     al,dh
#else
;;;	mov     dl,al
	xchg	dx,ax		! was mov dl,al
	lodsw
	test    dl,#LBA32_FLAG
	jnz     is_lba
	xor     ah,ah           ! was LINEAR, zero the hi-nibble (was count)
is_lba:
        xchg    ax,di
;;;	mov     al,#1
#endif
;;;        and     dl,#0x8F        ! clear all the spurious flags
#ifdef JRC_READ_INLINE
#include "read.S"
#else
	call	lba_read
#endif
rd_done:
	jc	error		! error -> start over again
	add	bh,#2    	! next sector
	jmp	sload

done:	mov	al,#0x49	! display an 'I'
	call	display

! Start the second stage loader     DS=location of Params

	push	es
	push	#0
	retf
;;;	jmpi	0,SECONDSEG	! start the second stage loader


#ifndef JRC_NOCOMPACT
hinib:  .byte   0
#endif

error:
#ifndef LCF_NO1STDIAG
        mov	al,#32          ! display a space
	call	display
;;;		        ! display error code in AH
	call	bout
#endif
	xor	ax,ax		! reset the FDC
;;;	mov	dl,al
	int	0x13
	jmp	lagain		! redo from start

#ifndef LCF_NO1STDIAG
bout:	rol     ax,4            ! bring hi-nibble to position
	call	nout
	rol     ax,4            ! bring lo-nibble to position
nout:	and	al,#0x0F	! display one nibble
	add	al,#0x30
	cmp	al,#0x3A	! a..f converts to letter
	jb	nokay
	add	al,#7		! make a letter A..F
nokay:				! fall through
#endif
display:  push  ax              ! new display does not affect AX
        xor	bh,bh		! display on screen
	mov	ah,#14
	int	0x10
	pop     ax
	ret
	
#ifndef JRC_READ_INLINE	
#include "read.S"
#endif

	
theend:

#if 1
!
!   If 'first' loads as the MBR, then there must be space for the partition
!   table.  If 'first' loads as the boot record of some partition, then
!   the space reserved below is not used.  But we must reserve the area
!   as a hedge against the first case.
!
!
	.org	0x1be		! spot for the partition table
p_table:
	.blkb	16
	.blkb	16
	.blkb	16
	.blkb	16
	.word	0xAA55		! boot block signature
#endif