/* probe.h  -- definitions for the LILO probe utility */

#ifndef __PROBE_H_
#define __PROBE_H_



#define EDD_PACKET  01
#define EDD_LOCK    02
#define EDD_SUBSET  04

struct disk_geom {
   long n_total_blocks;
   int n_sect;
   int n_head;
   int n_cyl;
   char type;
   char EDD_flags;
   char EDD_rev;
   char reserved_1;
};

/* structure used by int 0x13, AH=0x48 */

struct disk_param {
   short size;
   short flags;
   unsigned long n_cyl;
   unsigned long n_head;
   unsigned long n_sect;
   long long n_sectors;
   short n_byte;
   unsigned long edd_config_ptr;
};

#define EDD_DMA_BOUNDARY_TRANSP  01
#define EDD_PARAM_GEOM_VALID     02




void probe_tell (char *cmd);


#endif
/* end probe.h */
