/*	SC	A Spreadsheet Calculator
 *		Routines for piping data to and from an external macro program
 *
 *		Chuck Martin <cmartin@bigfoot.com>
 *		June, 2000
 *
 *		$Revision: 7.7 $
 */

#include <stdio.h>
#include <unistd.h>
#include "sc.h"

#ifdef BSD42
#include <strings.h>
#include <sys/time.h>
#ifndef strchr
#define strchr index
#endif
#else
#include <time.h>
#ifndef SYSIII
#include <string.h>
#endif
#endif


void
getnum(int r0, int c0, int rn, int cn, int fd)
{
    struct ent	**pp;
    int		r, c;

    for (r = r0; r <= rn; r++) {
	for (c = c0, pp = ATBL(tbl, r, c); c <= cn; pp++, c++) {
	    *line = '\0';
	    if (*pp && (*pp)->flags & is_valid)
		sprintf(line, "%.15g", (*pp)->v);
	    if (c < cn)
		strcat(line, "\t");
	    else
		strcat(line, "\n");
	    write(fd, line, strlen(line));
	}
    }
    linelim = -1;
}

void
fgetnum(int r0, int c0, int rn, int cn, int fd)
{
    struct ent	**pp;
    int		r, c;

    for (r = r0; r <= rn; r++) {
	for (c = c0, pp = ATBL(tbl, r, c); c <= cn; pp++, c++) {
	    *line = '\0';
	    if (*pp && (*pp)->flags & is_valid) {
		if ((*pp)->format) {
		    if (*((*pp)->format) == ctl('d')) {
			time_t i = (time_t) ((*pp)->v);
			strftime(line, sizeof(line), ((*pp)->format)+1,
			    localtime(&i));
		    } else
		    format((*pp)->format, (*pp)->v,
			line, sizeof(line));
		} else
		    engformat(realfmt[c0], fwidth[c0], precision[c0], (*pp)->v, 
			    line, sizeof(line));
	    }
	    if (c < cn)
		strcat(line, "\t");
	    else
		strcat(line, "\n");
	    write(fd, line, strlen(line));
	}
    }
    linelim = -1;
}

void
getstring(int r0, int c0, int rn, int cn, int fd)
{
    struct ent	**pp;
    int		r, c;

    for (r = r0; r <= rn; r++) {
	for (c = c0, pp = ATBL(tbl, r, c); c <= cn; pp++, c++) {
	    *line = '\0';
	    if (*pp && (*pp)->label)
		sprintf(line, "%s", (*pp)->label);
	    if (c < cn)
		strcat(line, "\t");
	    else
		strcat(line, "\n");
	    write(fd, line, strlen(line));
	}
    }
    linelim = -1;
}

void
getexp(int r0, int c0, int rn, int cn, int fd)
{
    struct ent	**pp;
    int		r, c;

    for (r = r0; r <= rn; r++) {
	for (c = c0, pp = ATBL(tbl, r, c); c <= cn; pp++, c++) {
	    *line = '\0';
	    if (*pp && (*pp)->expr) {
		linelim = 0;
		decompile((*pp)->expr, 0);	/* set line to expr */
		line[linelim] = '\0';
		if (*line == '?')
		    *line = '\0';
	    }
	    if (c < cn)
		strcat(line, "\t");
	    else
		strcat(line, "\n");
	    write(fd, line, strlen(line));
	}
    }
    linelim = -1;
}

void
getformat(int col, int fd)
{
    sprintf(line, "%d %d %d\n", fwidth[col], precision[col], realfmt[col]);
    write(fd, line, strlen(line));
    linelim = -1;
}

void
getfmt(int r0, int c0, int rn, int cn, int fd)
{
    struct ent	**pp;
    int		r, c;

    for (r = r0; r <= rn; r++) {
	for (c = c0, pp = ATBL(tbl, r, c); c <= cn; pp++, c++) {
	    *line = '\0';
	    if (*pp && (*pp)->format)
		sprintf(line, "%s", (*pp)->format);
	    if (c < cn)
		strcat(line, "\t");
	    else
		strcat(line, "\n");
	    write(fd, line, strlen(line));
	}
    }
    linelim = -1;
}
