
/*      xmms - esound output plugin
 *    Copyright (C) 1999      Galex Yen
 *      
 *      this program is free software
 *      
 *      Description:
 *              This program is an output plugin for xmms v0.9 or greater.
 *              The program uses the esound daemon to output audio in order
 *              to allow more than one program to play audio on the same
 *              device at the same time.
 *
 *              Contains code Copyright (C) 1998-1999 Mikael Alm, Olle Hallnas,
 *              Thomas Nillson and 4Front Technologies
 *
 */
#include "xmms/i18n.h"
#include "esdout.h"
#include "libxmms/configfile.h"
#include <gtk/gtk.h>

static GtkWidget *configure_win = NULL, *vbox, *notebook;

static GtkWidget *server_frame, *server_vbox, *server_hbox;
static GtkWidget *server_use_remote, *server_host_label, *server_host_entry;
static GtkWidget *server_port_label, *server_port_entry;

static GtkWidget *buffer_frame, *buffer_vbox, *buffer_table;
static GtkWidget *buffer_size_box, *buffer_size_label, *buffer_size_spin;
static GtkObject *buffer_size_adj;
static GtkWidget *buffer_pre_box, *buffer_pre_label, *buffer_pre_spin;
static GtkObject *buffer_pre_adj;
static GtkWidget *bbox, *ok, *cancel;

static void configure_win_ok_cb(GtkWidget * w, gpointer data)
{
	ConfigFile *cfgfile;
	gchar *filename;

	esd_cfg.use_remote = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(server_use_remote));
	if (esd_cfg.server)
		g_free(esd_cfg.server);
	esd_cfg.server = g_strdup(gtk_entry_get_text(GTK_ENTRY(server_host_entry)));
	esd_cfg.port = atoi(gtk_entry_get_text(GTK_ENTRY(server_port_entry)));
	esd_cfg.buffer_size = (gint) GTK_ADJUSTMENT(buffer_size_adj)->value;
	esd_cfg.prebuffer = (gint) GTK_ADJUSTMENT(buffer_pre_adj)->value;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfgfile = xmms_cfg_open_file(filename);
	if (!cfgfile)
		cfgfile = xmms_cfg_new();

	xmms_cfg_write_boolean(cfgfile, "ESD", "use_remote", esd_cfg.use_remote);
	xmms_cfg_write_string(cfgfile, "ESD", "remote_host", esd_cfg.server);
	xmms_cfg_write_int(cfgfile, "ESD", "remote_port", esd_cfg.port);
	xmms_cfg_write_int(cfgfile, "ESD", "buffer_size", esd_cfg.buffer_size);
	xmms_cfg_write_int(cfgfile, "ESD", "prebuffer", esd_cfg.prebuffer);
	xmms_cfg_write_file(cfgfile, filename);
	xmms_cfg_free(cfgfile);

	g_free(filename);

	gtk_widget_destroy(configure_win);
}

static void use_remote_cb(GtkWidget * w, gpointer data)
{
	gboolean use_remote;

	use_remote = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(server_use_remote));

	gtk_widget_set_sensitive(server_hbox, use_remote);
}

void esdout_configure(void)
{
	gchar *temp;

	if (!configure_win)
	{
		configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);
		gtk_window_set_title(GTK_WINDOW(configure_win), _("ESD Plugin configuration"));
		gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(configure_win), vbox);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

		server_frame = gtk_frame_new(_("Host:"));
		gtk_container_set_border_width(GTK_CONTAINER(server_frame), 5);

		server_vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(server_vbox), 5);
		gtk_container_add(GTK_CONTAINER(server_frame), server_vbox);

		server_use_remote = gtk_check_button_new_with_label(_("Use remote host"));
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(server_use_remote), esd_cfg.use_remote);
		gtk_signal_connect(GTK_OBJECT(server_use_remote), "clicked", use_remote_cb, NULL);
		gtk_box_pack_start(GTK_BOX(server_vbox), server_use_remote, FALSE, FALSE, 0);
		gtk_widget_show(server_use_remote);

		server_hbox = gtk_hbox_new(FALSE, 5);
		gtk_widget_set_sensitive(server_hbox, esd_cfg.use_remote);
		gtk_box_pack_start(GTK_BOX(server_vbox), server_hbox, FALSE, FALSE, 0);

		server_host_label = gtk_label_new(_("Host:"));
		gtk_box_pack_start(GTK_BOX(server_hbox), server_host_label, FALSE, FALSE, 0);
		gtk_widget_show(server_host_label);

		server_host_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(server_host_entry), esd_cfg.server);
		gtk_box_pack_start(GTK_BOX(server_hbox), server_host_entry, TRUE, TRUE, 0);
		gtk_widget_show(server_host_entry);

		server_port_label = gtk_label_new(_("Port:"));
		gtk_box_pack_start(GTK_BOX(server_hbox), server_port_label, FALSE, FALSE, 0);
		gtk_widget_show(server_port_label);

		server_port_entry = gtk_entry_new();
		gtk_widget_set_usize(server_port_entry, 50, -1);
		temp = g_strdup_printf("%d", esd_cfg.port);
		gtk_entry_set_text(GTK_ENTRY(server_port_entry), temp);
		g_free(temp);
		gtk_box_pack_start(GTK_BOX(server_hbox), server_port_entry, FALSE, FALSE, 0);
		gtk_widget_show(server_port_entry);

		gtk_widget_show(server_hbox);
		gtk_widget_show(server_vbox);
		gtk_widget_show(server_frame);
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), server_frame, gtk_label_new(_("Server")));

		buffer_frame = gtk_frame_new(_("Buffering:"));
		gtk_container_set_border_width(GTK_CONTAINER(buffer_frame), 5);

		buffer_vbox = gtk_vbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(buffer_frame), buffer_vbox);

		buffer_table = gtk_table_new(2, 1, TRUE);
		gtk_container_set_border_width(GTK_CONTAINER(buffer_table), 5);
		gtk_box_pack_start(GTK_BOX(buffer_vbox), buffer_table, FALSE, FALSE, 0);

		buffer_size_box = gtk_hbox_new(FALSE, 5);
		gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_size_box, 0, 1, 0, 1);
		buffer_size_label = gtk_label_new(_("Buffer size (ms):"));
		gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_label, FALSE, FALSE, 0);
		gtk_widget_show(buffer_size_label);
		buffer_size_adj = gtk_adjustment_new(esd_cfg.buffer_size, 200, 10000, 100, 100, 100);
		buffer_size_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_size_adj), 8, 0);
		gtk_widget_set_usize(buffer_size_spin, 60, -1);
		gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_spin, FALSE, FALSE, 0);
		gtk_widget_show(buffer_size_spin);
		gtk_widget_show(buffer_size_box);

		buffer_pre_box = gtk_hbox_new(FALSE, 5);
		gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_pre_box, 1, 2, 0, 1);
		buffer_pre_label = gtk_label_new(_("Pre-buffer (percent):"));
		gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_label, FALSE, FALSE, 0);
		gtk_widget_show(buffer_pre_label);
		buffer_pre_adj = gtk_adjustment_new(esd_cfg.prebuffer, 0, 90, 1, 1, 1);
		buffer_pre_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_pre_adj), 1, 0);
		gtk_widget_set_usize(buffer_pre_spin, 60, -1);
		gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_spin, FALSE, FALSE, 0);
		gtk_widget_show(buffer_pre_spin);
		gtk_widget_show(buffer_pre_box);

		gtk_widget_show(buffer_table);
		gtk_widget_show(buffer_vbox);
		gtk_widget_show(buffer_frame);
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), buffer_frame, gtk_label_new(_("Buffering")));

		gtk_widget_show(notebook);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label(_("Ok"));
		gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(configure_win_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label(_("Cancel"));
		gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show(bbox);
		gtk_widget_show(vbox);
		gtk_widget_show(configure_win);
	}
	else
		gdk_window_raise(configure_win->window);
}
