/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "print.h"

#ifndef __mozilla_h
#define __mozilla_h

typedef struct
{
	gchar *img; 
	gchar *link; 
	gchar *linktext;
	gboolean framed_page;
	gint context;
} WrapperContextInfo;

typedef struct
{
	WrapperContextInfo ctx;
	gulong key;
	gint modifier;
} WrapperKeyEventInfo;

typedef struct
{
	WrapperContextInfo ctx;
	gint button;
	gint modifier;
} WrapperMouseEventInfo;

typedef struct
{
	gchar *search_string;
	gboolean backwards;
	gboolean wrap;
	gboolean entire_word;
	gboolean match_case;
} WrapperSearchProperties;

#define COOKIEPERMISSION 0
#define IMAGEPERMISSION 1
#define PASSWORDMANAGER_ID "@mozilla.org/passwordmanager;1"
#define UTF8_ENCODER_ID "@mozilla.org/intl/unicode/encoder;1?charset=UTF-8"  
#define UTF8_DECODER_ID "@mozilla.org/intl/unicode/decoder;1?charset=UTF-8"

#ifdef __cplusplus
extern "C"
{
#endif

/* Preferences */
gboolean mozilla_load_prefs (void);
gboolean mozilla_save_prefs (void);
gboolean mozilla_preference_set (const char *preference_name,
				 const char *new_value);
gboolean mozilla_preference_set_boolean (const char *preference_name,
					 gboolean  new_boolean_value);
gboolean mozilla_preference_set_int (const char *preference_name,
				     int new_int_value);

/* Mozilla interface initializations */
gboolean mozilla_init_promptService (void);
gboolean mozilla_init_ContentHandler (void);
gboolean mozilla_init_FilePicker (void);
gboolean mozilla_register_contentOverrideHandler (const char *mime_type);   
gboolean mozilla_register_stored_contentOverrideHandlers (void);  
gboolean mozilla_unregister_stored_contentOverrideHandlers (void);

/* Wrapper initialization */
gpointer mozilla_wrapper_init (GaleonEmbed *embed,
			       gboolean attach_listener);
gboolean mozilla_wrapper_destroy (GaleonEmbed *embed);

/* Base functionalities */
gboolean mozilla_find (GaleonEmbed *embed,
		       WrapperSearchProperties *properties);
gboolean mozilla_save_url (GaleonEmbed *embed, const char *url, 
			     const char *file_name);
gboolean mozilla_save_link (GaleonEmbed *embed, const char *url);
gboolean mozilla_reload (GaleonEmbed *embed);
gboolean mozilla_print (GaleonEmbed *embed, PrintInfo *info);
gboolean mozilla_set_zoom (GaleonEmbed *embed, float f);
gboolean mozilla_get_zoom (GaleonEmbed *embed, float *f);
gboolean mozilla_session_history (GaleonEmbed *embed, char **titles[],
					 int *count, int *index);
gboolean mozilla_session_history_go (GaleonEmbed *embed, int index);
gchar *mozilla_get_main_document_url (GaleonEmbed *embed);
gchar *mozilla_get_document_url (GaleonEmbed *embed);
gchar *mozilla_get_document_title (GaleonEmbed *embed);
void mozilla_clear_cache (unsigned long cache);
gboolean mozilla_set_offline (GaleonEmbed *embed, gboolean offline);

/* Utils */
gboolean mozilla_get_key_event_info (GaleonEmbed *embed,
				     gpointer event,
				     WrapperKeyEventInfo *info);
gboolean mozilla_get_mouse_event_info (GaleonEmbed *embed,
				       gpointer event,
				       WrapperMouseEventInfo *info);
void mozilla_free_context_info_sub (WrapperContextInfo *ctx);

/* Charsets */
void mozilla_get_charsets (GHashTable **charsets,
			   GList **sorted_charset_titles);
void mozilla_force_character_set (GaleonEmbed *embed,
				  char *force_character_set);

/* Cookies manager */
void mozilla_block_url (const char *imgURL);
GList *mozilla_list_cookies (void);
void mozilla_set_permission (GaleonEmbed *embed, gboolean permit, 
				    int type);
GList *mozilla_get_permissions (int type);
gboolean mozilla_remove_cookies (GList *gone, gboolean block);
gboolean mozilla_remove_permissions (GList *gone, int type);

/* Password Manager */
GList *mozilla_list_passwords (PasswordType type);
gboolean mozilla_remove_passwords (GList *gone, PasswordType type);

/* Others */
gboolean mozilla_copy_session_history (GaleonEmbed *embed,
				       GaleonEmbed *dest);
gboolean mozilla_get_favicon_location (GaleonEmbed *embed, gchar **url);

#ifdef __cplusplus
}
#endif 

#ifdef __cplusplus

#include <nscore.h>
#include "nsIDOMWindow.h"

extern "C"
{
gchar *mozilla_unicode_to_utf8 (const PRUnichar *uniStr);
gchar *mozilla_unicode_to_locale (const PRUnichar *uniStr);
PRUnichar *mozilla_utf8_to_unicode (const gchar *utfStr);
PRUnichar *mozilla_locale_to_unicode (const gchar *locStr);
GtkWidget *mozilla_find_gtk_parent (nsIDOMWindow *domWindow);
}

#endif

#endif /* __mozilla_h */
