/*
 *  Copyright (C) 1999-2001 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "Gtm.h"
#include "file-data.h"
#include "file-list.h"

/*** App-specific servant structures ***/
typedef struct {
   POA_GTM_Download servant;
   PortableServer_POA poa;

} impl_POA_GTM_Download;

/*** Implementation stub prototypes ***/
GTM_Download 
impl_GTM_Download__create(PortableServer_POA poa, CORBA_Environment * ev);

static CORBA_boolean
 impl_GTM_Download_add_url(impl_POA_GTM_Download * servant,
			   CORBA_char * url,
			   CORBA_char * dir,
			   CORBA_boolean disable_proxy,
			   CORBA_boolean disable_auto_dl,
			   CORBA_Environment * ev);

/*** epv structures ***/
static PortableServer_ServantBase__epv impl_GTM_Download_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GTM_Download__epv impl_GTM_Download_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GTM_Download_add_url,

};

/*** vepv structures ***/
static POA_GTM_Download__vepv impl_GTM_Download_vepv =
{
   &impl_GTM_Download_base_epv,
   &impl_GTM_Download_epv,
};

/*** Stub implementations ***/
GTM_Download 
impl_GTM_Download__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GTM_Download retval;
   impl_POA_GTM_Download *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GTM_Download, 1);
   newservant->servant.vepv = &impl_GTM_Download_vepv;
   newservant->poa = poa;
   POA_GTM_Download__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static CORBA_boolean
impl_GTM_Download_add_url(impl_POA_GTM_Download * servant,
			  CORBA_char * url,
			  CORBA_char * dir,
			  CORBA_boolean disable_proxy,
			  CORBA_boolean disable_auto_dl,
			  CORBA_Environment * ev)
{
   CORBA_boolean retval;
   FileData *file_data;
   
   file_data = file_data_create (url, dir, !disable_proxy, !disable_auto_dl);
   retval = file_list_single_add (GTK_CLIST (dl_file_list), file_data);
   if (retval == FALSE)
       file_data_free (file_data);

   return retval;
}
