/*
 *  Copyright (C) 2001 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <string.h>
#include <time.h>
#include "gtm.h"
#include "log.h"

static GtkWidget *log_text_window;

static gchar *
get_time_date (void)
{
    time_t cur_time;
    struct tm *tm;

    cur_time = time (NULL);
    tm = localtime (&cur_time);
    return g_strdup_printf ("%04d/%02d/%02d %02d:%02d:%02d",
                            tm->tm_year + 1900, tm->tm_mon, tm->tm_mday,
                            tm->tm_hour, tm->tm_min, tm->tm_sec);
}

static void
style_set_cb (GtkWidget *widget, GtkStyle *previous_style, GtkWidget *hbox)
{
    GtkStyle *gtk_style;

    /* Set the new text box size (it tries to set it to 4 lines) */
    gtk_style = gtk_widget_get_style (log_text_window);
    gtk_widget_set_usize (hbox, 10, 
                          (2 + gdk_char_height (gtk_style->font, '|')) * 4
                          + 10);
}

GtkWidget *
log_create (void)
{
    GtkWidget *hbox, *vsbar;
    gchar *time_date;
    GdkColormap *cmap;
    GdkColor color, *pcolor;

    hbox = gtk_hbox_new (FALSE, 0);
    log_text_window = gtk_text_new (NULL, NULL);
    gtk_box_pack_start (GTK_BOX (hbox), log_text_window, TRUE, TRUE, 0);
    vsbar = gtk_vscrollbar_new (GTK_TEXT (log_text_window)->vadj);
    gtk_box_pack_start (GTK_BOX (hbox), vsbar, FALSE, FALSE, 0);
    gtk_signal_connect (GTK_OBJECT (log_text_window), "style_set",
                        GTK_SIGNAL_FUNC (style_set_cb),
                        (gpointer) hbox);
    cmap = gdk_colormap_get_system ();
    color.red = 0;
    color.green = 0;
    color.blue = 0xcccc;
    if (!gdk_color_alloc (cmap, &color)) {
        g_warning ("Couldn't allocate color");
        pcolor = NULL;
    } else
        pcolor = &color;
    gtk_widget_show_all (hbox);
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, pcolor, NULL,
                     _ ("GTM Log started on "), -1);
    time_date = get_time_date ();
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, pcolor, NULL,
                     time_date, -1);
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, pcolor, NULL,
                     "\n", -1);
    g_free (time_date);

    return hbox;
}

void
log_insert_entry (gchar *text)
{
    gchar *time_date;
    GdkColormap *cmap;
    GdkColor color, *pcolor;

    gtk_text_insert (GTK_TEXT (log_text_window), NULL, NULL, NULL,
                     "\n", -1);
    cmap = gdk_colormap_get_system ();
    color.red = 0;
    color.green = 0xcccc;
    color.blue = 0;
    if (!gdk_color_alloc (cmap, &color)) {
        g_warning ("Couldn't allocate color");
        pcolor = NULL;
    } else
        pcolor = &color;
    time_date = get_time_date ();
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, pcolor, NULL,
                     time_date, -1);
    g_free (time_date);
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, NULL, NULL,
                     ": ", -1);
    gtk_text_insert (GTK_TEXT (log_text_window), NULL, NULL, NULL,
                     text, -1);
}
