/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */
#ifndef nsBrowserInstance_h___
#define nsBrowserInstance_h___

// Helper Classes
#include "nsCOMPtr.h"
#include "nsWeakReference.h"

// Interfaces Needed
#include "nsIBrowserInstance.h"

#include "nscore.h"
#include "nsString.h"
#include "nsISupports.h"

#include "nsIRequestObserver.h"
#include "nsIInputStream.h"
#include "nsIObserver.h"
#include "nsICmdLineHandler.h"
#include "nsIWebShell.h"
#include "nsIUrlbarHistory.h"

class nsIDocShell;
class nsIScriptContext;
class nsIDOMWindowInternal;
class nsIDOMNode;
class nsIURI;
class nsIWebShellWindow;
class nsIFindComponent;


////////////////////////////////////////////////////////////////////////////////
// nsBrowserInstance:
////////////////////////////////////////////////////////////////////////////////

class nsBrowserInstance : public nsIBrowserInstance,
                          public nsSupportsWeakReference 
{
  public:

    nsBrowserInstance();
    virtual ~nsBrowserInstance();
    
    NS_DEFINE_STATIC_CID_ACCESSOR( NS_BROWSERINSTANCE_CID )
                 
    NS_DECL_ISUPPORTS

    NS_DECL_NSIBROWSERINSTANCE


  protected:

    nsresult GetContentAreaDocShell(nsIDocShell** outDocShell);
    nsresult GetContentWindow(nsIDOMWindowInternal** outContentWindow);
    
    nsresult GetFocussedContentWindow(nsIDOMWindowInternal** outFocussedWindow);
    
    void ReinitializeContentVariables();
    
    PRBool              mIsClosed;
    static PRBool       sCmdLineURLUsed;

    nsWeakPtr          mContentAreaDocShellWeak;

    nsIWebShellWindow  *mWebShellWin;								// weak reference
    nsIDocShell *       mDocShell;									// weak reference
    nsIDOMWindowInternal*       mDOMWindow;                         // weak reference

    nsCOMPtr<nsIUrlbarHistory> mUrlbarHistory;                  //We own this
    nsCOMPtr<nsISupports>  mSearchContext;				// at last, something we really own
#ifdef DEBUG_warren
    PRIntervalTime      mLoadStartTime;
#endif
};

#endif // nsBrowserInstance_h___
