/****************************
 Change a contacts' nicname
 (c) 1999 Jeremy Wise
 GnomeICU
*****************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <string.h>

/*** Local function declarations ***/
void change_name_revert( GtkWidget *widget, gpointer data );

/*** Global functions ***/
void change_nick( GtkWidget *widget, gpointer data )
{
	char *new_nick;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "change_nick\n" );
#endif

	contact = Find_User( GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "index" ) ) );
	if( contact == NULL )
		return;

	new_nick = gtk_entry_get_text( GTK_ENTRY( widget ) );

	strncpy( kontakt->nick, new_nick, sizeof(kontakt->nick) );

	if( kontakt->info->window != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_alias ),
		                    new_nick );
	
	gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
	                    kontakt->lb_index, 1, new_nick );
}

void change_nick_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox1;
	GtkWidget *label2;
	GtkWidget *entry1;
	GtkWidget *combo_entry1;
	GtkWidget *dialog_action_area2;
	GtkWidget *button4;
	GtkWidget *button6;
	GtkCList *clist;
	GSList *contact;

	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "change_nick_window\n" );
#endif

	if( !GTK_IS_BUTTON( widget ) )
	{
		clist = GTK_CLIST( MainData->lb_userwin );
		contact = Find_User( GPOINTER_TO_INT( gtk_clist_get_row_data( clist, GPOINTER_TO_INT( clist->selection->data ) ) ) );
	}
	else
		contact = Find_User( GPOINTER_TO_INT( data ) );

	if( contact == NULL )
		return;

	window = gnome_dialog_new (_("GnomeICU: Rename User"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Rename_User", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox2", dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, FALSE, FALSE, 0);

	str = g_strdup_printf( _("Please enter a new alias for %s:"),
	                       kontakt->nick );

	label2 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label2), 7.45058e-09, 0.5);

	entry1 = gnome_entry_new ("gnomeicu_renames");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (window), "entry1", entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry1);
	gtk_box_pack_start (GTK_BOX (vbox1), entry1, FALSE, FALSE, 0);

	combo_entry1 = gnome_entry_gtk_entry (GNOME_ENTRY (entry1));
	gtk_widget_ref (combo_entry1);
	gtk_object_set_data_full (GTK_OBJECT (window), "combo_entry1", combo_entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry1);

	gtk_entry_set_text( GTK_ENTRY( combo_entry1 ), kontakt->nick );

	gtk_object_set_data( GTK_OBJECT( combo_entry1 ), "index",
	                     GINT_TO_POINTER( kontakt->uin ) );

	gtk_object_set_data( GTK_OBJECT( combo_entry1 ), "oldnick",
	                     GINT_TO_POINTER( kontakt->nick ) );

	dialog_action_area2 = GNOME_DIALOG (window)->action_area;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area2", dialog_action_area2);
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_OK);
	button4 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button4);
	gtk_object_set_data_full (GTK_OBJECT (window), "button4", button4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button4);
	GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
	button6 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button6);
	gtk_object_set_data_full (GTK_OBJECT (window), "button6", button6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button6);
	GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (combo_entry1), "changed",
	                    GTK_SIGNAL_FUNC (change_nick),
	                    NULL);
	gtk_signal_connect_object (GTK_OBJECT (combo_entry1), "activate",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));
	gtk_signal_connect_object (GTK_OBJECT (button4), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));
	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
	                    GTK_SIGNAL_FUNC (change_name_revert),
	                    combo_entry1);
	gtk_signal_connect_object (GTK_OBJECT (button6), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_widget_show_all( window );
}

/*** Local functions ***/
void change_name_revert( GtkWidget *widget, gpointer data )
{
	gchar *nick;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "change_name_revert\n" );
#endif

	contact = Find_User( GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( data ), "index" ) ) );
	if( contact == NULL )
		return;

	nick = (gchar*)gtk_object_get_data( GTK_OBJECT( data ), "oldnick" );
	strncpy( kontakt->nick, nick, sizeof(kontakt->nick) );

	gtk_clist_set_text( GTK_CLIST( MainData->lb_userwin ),
	                    kontakt->lb_index, 1, nick );
}
