/**************************
 Handle file transfer
 (c) 1999 Jeremy Wise
 GnomeICU
***************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Global functions ***/
void create_file_xfer_dialog( struct xfer_struct *xfer )
{
	filexferdlg *dlg = g_new0( filexferdlg, 1 );
	GtkWidget *table;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *label;

	GString *string = g_string_new("");

	if( dlg == NULL )
		return;

	dlg->window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( dlg->window ), _("GnomeICU: File Transfer") );
	gtk_container_set_border_width( GTK_CONTAINER( dlg->window ), 10 );

	table = gtk_table_new( 4, 2, FALSE );
	gtk_container_add( GTK_CONTAINER( dlg->window ), table );
	
	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Current File:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	g_string_sprintf( string, "1/%d", g_slist_length(xfer->file_queue) );

	dlg->tot_files = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->tot_files ), string->str );
	gtk_widget_set_usize( dlg->tot_files, 50, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->tot_files, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->tot_files );

	dlg->current_file = gtk_entry_new();
	gtk_widget_set_usize( dlg->current_file, 137, 0 );
	gtk_entry_set_text( GTK_ENTRY( dlg->current_file ), ((struct file_struct *)xfer->file_queue->data)->short_filename );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->current_file, TRUE, TRUE, 0 );
	gtk_widget_show( dlg->current_file );

	gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 2, 0, 1 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Local File Name:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_set_sensitive( label, xfer->direction == XFER_DIRECTION_RECEIVING );
	gtk_widget_show( label );

	dlg->local_filename = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), dlg->local_filename, TRUE, TRUE, 0 );
	gtk_widget_set_sensitive( dlg->local_filename, xfer->direction == XFER_DIRECTION_RECEIVING );
	gtk_widget_show( dlg->local_filename );

	gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 2, 1, 2 );
	gtk_widget_show( hbox );

	frame = gtk_frame_new( _("Current File") );
	gtk_widget_set_usize( frame, 200, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( frame ), 7 );
	vbox = gtk_vbox_new( TRUE, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( vbox ), 7 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_table_attach_defaults( GTK_TABLE( table ), frame, 0, 1, 2, 3 );
	gtk_widget_show( frame );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Size:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	g_string_sprintf( string, "%d",  ((struct file_struct *)xfer->file_queue->data)->total_bytes );

	dlg->cf_size = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->cf_size ), string->str );
	gtk_widget_set_usize( dlg->cf_size, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_size, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_size );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Trans:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_trans = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_trans, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_trans, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_trans );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Time:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_time = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_time, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_time, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_time );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Speed:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_bps = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_bps, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_bps, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_bps );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	dlg->cf_progress = gtk_progress_bar_new();
	gtk_box_pack_start( GTK_BOX( vbox ), dlg->cf_progress, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_progress );

	gtk_widget_show( vbox );

	frame = gtk_frame_new( _("Batch") );
	gtk_widget_set_usize( frame, 200, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( frame ), 7 );
	vbox = gtk_vbox_new( TRUE, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( vbox ), 7 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_table_attach_defaults( GTK_TABLE( table ), frame, 1, 2, 2, 3 );
	gtk_widget_show( frame );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Size:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	g_string_sprintf( string, "%d", xfer->total_bytes );

	dlg->b_size = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->b_size ), string->str );
	gtk_widget_set_usize( dlg->b_size, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_size, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_size );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Trans:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_trans = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_trans, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_trans, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_trans );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Time:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_time = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_time, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_time, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_time );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Speed:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_bps = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_bps, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_bps, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_bps );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	dlg->b_progress = gtk_progress_bar_new();
	gtk_box_pack_start( GTK_BOX( vbox ), dlg->b_progress, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_progress );

	gtk_widget_show( vbox );

	dlg->cancel = gtk_button_new_with_label( _("Cancel") );
	gtk_table_attach_defaults( GTK_TABLE( table ), dlg->cancel, 0, 2, 3, 4 );
	gtk_widget_show( dlg->cancel );

	gtk_widget_show( table );
	gtk_widget_show( dlg->window );

	g_string_free(string, TRUE);

       gtk_signal_connect( GTK_OBJECT( dlg->cancel ),
                                       "clicked", (GtkSignalFunc) cancel_transfer,
                                       xfer );
       
       gtk_signal_connect( GTK_OBJECT( dlg->window ),
                                       "delete_event", (GtkSignalFunc) cancel_transfer,
                                       xfer );

       dlg->timer = g_timeout_add(250, (GSourceFunc)&update_file_transfer_dialog, (gpointer)xfer);
          
       xfer->dialog = dlg;
}

gboolean update_file_transfer_dialog( struct xfer_struct *xfer )
{
	GString *message = g_string_new("");
	struct file_struct *current_file;
	int t;
	
#ifdef TRACE_FUNCTION
	g_print("update_file_transfer_dialog\n");
#endif
	
	current_file = (struct file_struct *)xfer->file_queue->data;

	if (!xfer->dialog) 
	   return FALSE;	

	g_string_sprintf(message, "%d/%d", g_slist_length(xfer->completed_files) + 1, g_slist_length(xfer->file_queue) + g_slist_length(xfer->completed_files));

	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->tot_files ),
					message->str );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->current_file ),
					current_file->short_filename );

	g_string_sprintf( message, "%d",  current_file->total_bytes );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->cf_size ), message->str );

	g_string_sprintf( message, "%d", current_file->completed_bytes );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->cf_trans ),
										 message->str );
	g_string_sprintf( message, "%d", xfer->completed_bytes );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->b_trans ),
										 message->str );
	t = time( NULL ) - current_file->start_time;

	g_string_sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->cf_time ),
										 message->str );
	t = time( NULL ) - xfer->start_time;
	g_string_sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->b_time ),
										 message->str );
	if( current_file->completed_bytes &&
		current_file->start_time != time( NULL ) )
		g_string_sprintf( message, "%.1f KB/sec",
						current_file->completed_bytes /
						( time( NULL ) - current_file->start_time ) /1024.0);
	else
		g_string_assign( message, "0 KB/sec" );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->cf_bps ),
										 message->str );
	if( xfer->completed_bytes && xfer->start_time != time( NULL ) )
		g_string_sprintf( message, "%.1f KB/sec",
						(xfer->completed_bytes /
						( time( NULL ) - xfer->start_time )) / 1024.0 );
	else
		g_string_assign( message, "0 KB/sec" );
	gtk_entry_set_text( GTK_ENTRY( xfer->dialog->b_bps ),
										 message->str );
	if( current_file->completed_bytes == 0 ||
		 current_file->total_bytes == 0 )
		gtk_progress_bar_update( GTK_PROGRESS_BAR( xfer->dialog->cf_progress ), 0.0F );
	else
		gtk_progress_bar_update( GTK_PROGRESS_BAR( xfer->dialog->cf_progress ),
					(float)( (float)current_file->completed_bytes / (float)current_file->total_bytes ) );
	if( xfer->completed_bytes == 0 ||
		 xfer->total_bytes == 0 )
		gtk_progress_bar_update( GTK_PROGRESS_BAR( xfer->dialog->b_progress ), 0.0F );
	else
		gtk_progress_bar_update( GTK_PROGRESS_BAR( xfer->dialog->b_progress ),
					(float)( (float)xfer->completed_bytes / (float)xfer->total_bytes ) );
	
	g_string_free(message, TRUE);

	return TRUE;
}

void destroy_file_xfer_dialog( struct xfer_struct *xfer) {
        if( xfer->dialog ) {
                if ( xfer->dialog->window )
                        gtk_widget_destroy( xfer->dialog->window );
        
	        if (xfer->dialog->timer)
        	        g_source_remove(xfer->dialog->timer);
	}
        
        g_free( xfer->dialog );
}
