/*
 * For a full descritpion of this check BSD's protocol/talkd.h
 *
 * This file just duplicates the interface
 */

#define NAME_SIZE       12
#define TTY_SIZE        16

/* client->server message */
typedef struct {
        guchar   vers;
        guchar   type; 
        guchar   answer; 
        guchar   pad;
        gint32   id_num; 
        struct   osockaddr addr;
        struct   osockaddr ctl_addr;
        gint32 pid;            
        char    l_name[NAME_SIZE];
        char    r_name[NAME_SIZE];
        char    r_tty[TTY_SIZE];
} CTL_MSG;

/* Server to client reponse format */
typedef struct {
	guchar	vers;		
	guchar	type;		
	guchar	answer;		
	guchar	pad;
	gint32  id_num;	
	struct	osockaddr addr;	
} CTL_RESPONSE;

/* Protocol version */
#define	TALK_VERSION	1

typedef enum {
	LEAVE_INVITE,
	LOOK_UP,
	DELETE,
	ANNOUNCE
} MessageType;

typedef enum {
	SUCCESS,
	NOT_HERE,
	FAILED,
	MACHINE_UNKNOWN,
	PERMISSION_DENIED,
	UNKNOWN_REQUEST,
	BADVERSION,
	BADADDR,
	BADCTLADDR
} AnwerType;

