/*****************************************************************

Copyright (c) 2000 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __container_extension_h__
#define __container_extension_h__

#include <qframe.h>
#include <qsize.h>
#include <qstring.h>
#include <qcstring.h>

#include <kpanelextension.h>
#include <dcopobject.h>

#include "global.h"
#include "appletinfo.h"

class QHBox;
class QBoxLayout;
class QXEmbed;
class AppletHandle;
class PanelExtensionOpMenu;

class ExtensionContainer : public QFrame
{
    Q_OBJECT

public:
    ExtensionContainer(const AppletInfo& info, QWidget *parent=0);
    virtual ~ExtensionContainer();

    virtual QSize sizeHint(Position, QSize maxSize) { return maxSize; }

    KPanelExtension::Type type() const { return _type; }
    const AppletInfo& info() const { return _info; }

    QString extensionId() const { return _id; }
    void setExtensionId(const QString& s) { _id = s; }

    Position position() const { return _pos; }
    Orientation orientation() const { return _orient; }

    void resetLayout();
    bool eventFilter (QObject *, QEvent *);

    virtual void saveConfiguration(const QString& group) = 0;
    virtual void configure();

    virtual void about() {}
    virtual void help() {}
    virtual void preferences() {}
    virtual void reportBug() {}

    void removeSessionConfigFile();

public slots:
    virtual void slotSetPosition(Position p);

signals:
    void removeme(ExtensionContainer*);
    void moveme(ExtensionContainer*);
    void requestSave();
    void updateLayout();

protected:
    bool x11Event(XEvent*);

protected:
    Position              _pos;
    Orientation           _orient;
    QString               _id;
    AppletHandle         *_handle;
    QHBox                *_frame;
    QBoxLayout           *_layout;
    PanelExtensionOpMenu *_opMnu;
    AppletInfo            _info;
    KPanelExtension::Type _type;
    int                   _actions;
    QWidget   * _activeWidget; // Used in x11Event
};

class InternalExtensionContainer : public ExtensionContainer
{
    Q_OBJECT

public:
    InternalExtensionContainer(const AppletInfo& info, QWidget *parent = 0);
    ~InternalExtensionContainer();

    QSize sizeHint(Position, QSize maxSize);

    void about();
    void help();
    void preferences();
    void reportBug();
    void saveConfiguration(const QString& group);

public slots:
    void slotSetPosition(Position p);

private:
    QString          _deskFile, _configFile;
    KPanelExtension *_extension;
};

class ExternalExtensionContainer : public ExtensionContainer, DCOPObject
{
    Q_OBJECT

public:
    ExternalExtensionContainer(const AppletInfo& info, QWidget *parent = 0);
    ~ExternalExtensionContainer();

    QSize sizeHint(Position, QSize maxSize);

    void about();
    void help();
    void preferences();
    void reportBug();
    void saveConfiguration(const QString& group);

    bool process(const QCString &fun, const QByteArray &data,
		 QCString& replyType, QByteArray &replyData);
public slots:
    void slotSetPosition(Position p);

signals:
    void embeddedWindowDestroyed();
    void docked(ExternalExtensionContainer*);

protected:
    void dockRequest(QCString app, int actions, int type);

private:
    QString   _deskFile, _configFile;
    QXEmbed  *_embed;
    QCString  _app;
    bool      _isdocked;
};

#endif

