// -*- c++ -*-

/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef KASITEM_H
#define KASITEM_H

#include <qpixmap.h>
#include <netwm.h>

/**
 * Information about a window. This class gathers together various 
 * bits of info obtained from the NET WM properties, and makes them
 * available to the rest of KasBar in a convenient way.
 *
 * @version $Id: kasitem.h,v 1.3 2000/11/14 21:46:45 rich Exp $
 */
class KasItem
{
public:
    /**
     * Create an item for an existing window.
     */
    KasItem(WId w);

    /**
     * Create an item for a window which hasn't arrived yet.
     */
    KasItem();

    ~KasItem();

    void refresh();
    void refreshIcon();

    WId window() const { return win; }
    QString text() const { return winStr; }
    QPixmap& icon() { return pixmap; }
    bool isMinimized() const { return mappingState == NET::Iconic; }
    bool isShaded() const { return state & NET::Shaded; }
    int desktop() const;

    // For startup notifier
    bool isStarting() const { return starting; }
    void setStarted( WId w );
    void setDead() { dying = true; resetFrame(); }
    bool isDead() const { return dying; }

    int frameNumber() { return aniFrame; }
    void resetFrame() { aniFrame = 0; }
    void nextFrame();

private:
    bool starting;
    bool dying;
    int aniFrame;
    WId win;
    QString winStr;
    QPixmap pixmap;
    int desk;
    bool sticky;
    NET::MappingState mappingState;
    long unsigned int state;
};

#endif // KASITEM_H
