/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000,2001 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
*/

/*
  $Log: kbgfibs.h,v $
  Revision 1.8  2001/01/08 06:52:03  hoefkens
  Yet another rewrite of the FIBS message handling. The next step is to use a
  separate class to parse the messages.  Move the TODO entries in a new file.

  Revision 1.7  2001/01/06 23:31:17  hoefkens
  Lots of small changes and fixed. Big thing is a rewrite of the join menu
  in kbgfibs.

  Revision 1.6  2001/01/03 22:29:43  hoefkens
  Added the total user count to the player list caption and made the FIBS
  menu tearable & removed the aboutToShow handler in the engine.

  Revision 1.5  2000/12/29 22:43:33  hoefkens
  New version number and landing of the first FIBS options. More cleanup
  of the FIBS engine. Almost done with cleanup.

  Revision 1.4  2000/12/28 20:44:00  hoefkens
  Separated the connection and the invitation dialog from the kbgfibs files.
  The latter was just too long (and in the future, other network-based
  engines might use the same classes).

  Revision 1.3  2000/12/28 18:59:43  hoefkens
  Reworked the configuration and setup handling for the FIBS engine. More
  cleaning of the FIBS files and a bug fix: opponent can't move now enables
  cube and dice, and plays a sound.

  Revision 1.2  2000/12/26 20:03:28: hoefkens
  Many additions to the FIBS engine. Small addition to the Playerlist and a
  rather long message to lukas.

  Revision 1.1  2000/12/21 19:58:57  hoefkens
  Initial checkin of application's source files

*/

#ifndef __KBGFIBS_H
#define __KBGFIBS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include "kbgengine.h"
#include "kplayerlist.h"
#include "kfibschat.h"
#include "kbgconnection.h"
#include "kbginvite.h"

#include <qtabdialog.h>
#include <qtimer.h>
#include <kaction.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qstringlist.h>
#include <klineedit.h>
#include <klistview.h>
#include <qpopupmenu.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <klocale.h>


/**
 *
 * Special backgammon engine for games on the First Internet Backgammon Server
 *
 */
class KBgEngineFIBS : public KBgEngine
{
	Q_OBJECT

public:

	enum PStatus {Ready, Away, Blind}; // TODO: we only use Blind maybe get these from the playerlist...

 
	/**
	 * Constructor 
	 */
	KBgEngineFIBS(QWidget *parent = 0, QString *name = 0);

	/**
	 * Destructor
	 */
	virtual ~KBgEngineFIBS();

	/**
	 * Return the menu entry of the engine
	 */
	virtual QPopupMenu *getMenu();

	/**
	 * Fills the engine-specific page into the notebook
	 */
	virtual void getSetupPages(QTabDialog *nb);

	/**
	 * About to be closed. Let the engine exit properly.
	 */
	virtual bool queryExit();

public slots:

	/**
	 * Read and save user settings to the config file
	 */
	virtual void readConfig();
	virtual void saveConfig();
	
        /**
	 * Roll dice for the player w
	 */
        virtual void rollDice(const int w);
	
	/**
	 * Double the cube of player w
	 */
	virtual void doubleCube(const int w);

	/**
	 * A move has been made on the board - see the board class
	 * for the format of the string s
	 */
	virtual void handleMove(QString *s);

	/**
	 * Undo the last move
	 */
        virtual void undo();

	/**
	 * Redo the last move
	 */
        virtual void redo();

	/**
	 * Commit a move
	 */
	virtual void done();


	// ###########################################################################
	//
	//
	//
	//                    TODO TODO TODO TODO TODO TODO TODO
	//
	//
	//
	// ###########################################################################

	/*
	 * Process the string cmd
	 */
	void handleCommand(const QString &cmd);

	void fibsRequestInvitation(const QString &player);

	void personalMessage(const QString &msg);
	


	/**
	 * Get additional menu entries in the menu
	 */
	virtual void addMenuItems(QPopupMenu *m);

	/**
	 * Remove additional menu entries from the menu
	 */
	virtual void removeMenuItems(QPopupMenu *m);


	/*
	 * Local configuration handling
	 */

	void setupOk();

protected slots:

        void audioPlay(int event);

signals:
	
	void serverString(const QString &s);

	void fibsWhoInfo(const QString &line);
	void fibsWhoEnd();
	void fibsLogout(const QString &p);
	void fibsLogin(const QString &p);

	void fibsConnectionClosed();

	void changePlayerStatus(const QString &, int, bool);

	void chatMessage(const QString &msg);

	void fibsStartNewGame(const QString &msg);
	void gameOver();

protected slots:

        void invitationDone();	
	void newBoard(const QString &line);
	void inviteDialog();
	void showList();
	void showChat();

	void endGame();

private:
	
	QStringList invitations;
	

	/*
	 * special menu entries
	 */
	int fibsMenuID, respMenuID, cmdMenuID, joinMenuID, optsMenuID;
	QPopupMenu *fibsMenu, *respMenu, *cmdMenu, *joinMenu, *optsMenu;

	/*
	 * child windows
	 */
	KFibsPlayerList *playerlist;
	KFibsChat       *chatWindow;
	KBgInvite       *invitationDlg;

	// careful: player will never be our login, it will be You...
	char opponent[100], player[100];

	
	/*
	 * Other stuff
	 */
	QString lastMove;
	int toMove;

	QString lastAway;
	bool playing;
	bool redoPossible;
	int undoCounter;

	KAction *conAction, *disAction, *newAction, *invAction;
	
	KAction *actAccept, *actReject, *actConti, *actLeave, *actAway, *actBack;
	
	KToggleAction *chatAct, *listAct;

	QString caption;
	

	// ###########################################################################
	//
	//
	//
	//                    DONE DONE DONE DONE DONE DONE DONE
	//
	//
	//
	// ###########################################################################

private:

	/**
	 * Actions for responding to invitations. numJoin is he current
	 * number of active actions. The max. number of pending invitations 
	 * is eight and this is hardcoded in a lot of places (not the least
	 * of which are the slots join_N().
	 */
	KAction *actJoin[8];
	int numJoin;

protected slots:

        /**
	 * Handle rawwho information for the purposes of the invitation
	 * submenu and the join entries
	 */
        void changeJoin(const QString &info);
	
	/**
	 * A player will be removed from the menu of pending invitations
	 * if necessary.
	 */
	void cancelJoin(const QString &info);

	/**
	 * We have up to 8 names in the join menu. They are the
	 * players that invited us to play games. Each action 
	 * has its own slot and all slots call the common backend
	 * join().
	 */
	void join(const QString &msg);

	void join_0();
	void join_1();
	void join_2();
	void join_3();
	void join_4();
	void join_5();
	void join_6();
	void join_7();

	/**
	 * Simple slots that toggle FIBS server-side settings. The
	 * names of the functions reflect the name of the toggle on
	 * FIBS.
	 */
	void toggle_greedy();
	void toggle_ready();
	void toggle_double();

private:
	
	/**
	 * Toggle actions for the FIBS server-side settings
	 */
	enum FIBSOpt {OptReady, OptGreedy, OptDouble, 
		      OptAllowPip, OptAutoMove, OptCrawford, OptSilent, OptRatings, OptMoves, NumFIBSOpt};
	KToggleAction *fibsOpt[NumFIBSOpt];

protected slots:

        /* 
	 * Connection setup and handling
	 * -----------------------------
	 */

        // actual connection establishment
	void connectFIBS(const bool login);

	// simple wrapper for prev function
	void connectFIBSWrapper();

	// take the connection down
	void disconnectFIBS();

	// called once the connection is down
	void serverDisconnected();

	// create a new account and connect
	void newAccount();

protected:

	// get the connection parameters	
	bool queryConnection(const bool newlogin);

private:

	// actual connection object
	KBgConnection *connection;


protected slots:

        /* 
	 * FIBS command slots
	 * ------------------
	 */

        // go away and leave a message
	void away();

	// come back after being away
	void back();

	// roll dice 
        virtual void roll();

	// double the cube
        virtual void cube();

	// reload the board to the last known sane state
	virtual void load();

	// accept an offer
        void accept();

	// reject an offer
	void reject();

	// continue a multi game match
	void match_conti();

	// leave a multi game match
	void match_leave();

protected slots:

	/*
	 * All strings received from the server are given to handleServerData() for
	 * identification and processing. It implements a limited state machine to
	 * handle the incoming data correctly. The whole function could probably be 
	 * made more efficient, but it is not time critical (and it appears to be 
	 * easier to understand this way).
	 */
        void handleServerData(QString *line);

protected:

	enum RxStatus {RxIgnore, RxConnect, RxWhois, RxMotd, RxRating, 
		       RxNewLogin, RxGoodbye, RxNormal};

	int rxStatus, rxCount;
	
	QString rxCollect;
	
	/*
	 * The following functions handle the individual states
	 * of the handleServerData() state machine,
	 */
	void handleMessageWhois(const QString &line);
	void handleMessageRating(const QString &line);
	void handleMessageMotd(const QString &line);
	void handleMessageNewLogin(const QString &line);
	void handleMessageConnect(const QString &line, const QString &rawline);
	void handleMessageNormal(QString &line, QString &rawline);

	/*
	 * The next enumeration and the array of regular expressions is needed for the
	 * message identification in handleServerData(). 
	 */
	enum Pattern {Welcome, OwnInfo, NoLogin, BegRate, EndRate, HTML_lt, HTML_gt, 
		      BoardSY, BoardSN, WhoisBG, WhoisE1, WhoisE2, WhoEnde, WhoInfo,
		      MotdBeg, MotdEnd, MsgPers, MsgDeli, MsgSave, ChatSay, ChatSht, 
		      ChatWis, ChatKib, SelfSay, SelfSlf, SelfSht, SelfWis, SelfKib,
		      UserLin, UserLot, Goodbye, GameSav, RawBord, YouTurn, PlsMove,
		      BegWtch, EndWtch, BegBlnd, EndBlnd, BegGame, OneWave, TwoWave, 
		      YouWave, Reload1, Reload2, GameBG1, GameBG2, GameRE1, GameRE2, 
		      GameEnd, EndLose, EndVict, MatchB1, MatchB2, MatchB3, MatchB4, 
		      RejAcpt, YouAway, YouAcpt, HelpTxt, Invite0, Invite1, Invite2, 
		      Invite3, ConLeav, TabChar, SpcChar, PlsChar, OneName, TypJoin,  
		      YouBack, YouMove, YouRoll, TwoStar, BoxHori, BoxVer1, BoxVer2, 
		      OthrNam, YourNam, GivePwd, RetypeP, GreedyY, GreedyN, RejCont,
		      AcptWin, YouGive, DoubleY, DoubleN, 
		      NumPattern};

	QRegExp pat[NumPattern];

	/*
	 * This function is simply filling the pat[] array with the proper values.
	 */
	void initPattern();

private:

	/*
	 * Local setup and config variables
	 * ================================
	 */

	/*
	 * Various options
	 */
	bool showMsg, whoisInvite;
	QCheckBox *cbp, *cbi;

	/*
	 * Commit timer variables
	 */
	QTimer* commitTimeout;
	int commitTimeoutLength;
	QSpinBox *sbt;

	/*
	 * Sound settings
	 */
	enum SoundEvents {SoundRoll, SoundMove, SoundWon, SoundLost, SoundJoin, NumSounds};
	QRadioButton *rbs, *rbb, *rbf;
	bool useSound, ringBell;

	/*
	 * Connection setup
	 */
	enum FIBSInfo {FIBSHost, FIBSPort, FIBSUser, FIBSPswd, NumFIBS};
	QString infoFIBS[NumFIBS];
	QLineEdit *lec[NumFIBS];
	
	/*
	 * Auto messages
	 */
	enum AutoMessages {MsgBeg, MsgLos, MsgWin, NumMsg};
	QLineEdit *lem[NumMsg];
	QCheckBox *cbm[NumMsg];
	bool useAutoMsg[NumMsg];
	QString autoMsg[NumMsg];
};

#endif // __KBGFIBS_H
