/***************************************************************
TranslData.cpp
KTranslator Version 0.6.x , main widget, top level widget, dialogs

    KDE Translation Utility
    
    
    
    
    "Dedicated to the KDE Translators"
    
    
    
    
    
    
    program by Andrea Rizzi <rizzi@kde.org>  
    25 Feb 98 / Dec 1999   

*********************************************************************/
#include <kkeydialog.h>
#include <qstring.h>
#include <kaccel.h>
#include <kiconloader.h>
#include "TranslData.h"
#include <kurl.h>
#include <qtooltip.h>
#include "CatalogManager.h"  
#include <qsplitter.h>
#include <qlayout.h>
#include <qlistview.h>
#define Inherited QDialog
#include <qkeycode.h>
#include <glob.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <ksimpleconfig.h>
#include <qprogressbar.h>
#include <qvalidator.h>
KTranslator::KTranslator(QWidget *,const char *name = 0,QString filename = "")
  :KTopLevelWidget(name)
{
  app=KApplication::getKApplication();
  config=app->getConfig();


  statusbar = new KStatusBar(this);
  statusbar->insertItem(klocale->translate("Total ID: 0    "),2);
  statusbar->insertItem(klocale->translate("Current ID:0    "),3);
  statusbar->insertItem(klocale->translate("Old Cat. Translations:0    "),4);
  statusbar->insertItem("Fuzzy:0    ",5);
  statusbar->insertItem("Doing Nothing...                     ",6);
  QProgressBar *pb1 = new QProgressBar(statusbar);
  pb1->show();
  pb1->resize(70,20);
  statusbar->insertWidget(pb1,70,7);
  pb1->show();



  config->setGroup("Files");
  lv = new CatalogManager(0,config->readEntry("BasePath").copy(),"it"  );
  connect(lv,SIGNAL(openFile()),this,SLOT(openFromCvs()));
  connect(lv,SIGNAL(openFilePot()),this,SLOT(openPotFromCvs()));

  lv->setRootIsDecorated(true);
  lv->resize(200,400);
  //split0->addWidget(lv,0,0);


  wid = new TranslData(this ,"Trans");
  //split0->addWidget(wid,0,1);
  //split0->setColStretch(0,1);


  setView(wid  );
  setMinimumSize(600,350);
  resize(700,410);
  
  connect(wid,SIGNAL(fileOpened()),this,SLOT(updateToolbar()));
  connect(wid,SIGNAL(total(int)),this,SLOT(updateTot(int)));
  connect(wid,SIGNAL(fuzzy(int)),this,SLOT(updateFuzzy(int)));
  connect(wid,SIGNAL(upNavBar(int)),this,SLOT(updateNavBar(int)));
  connect(wid,SIGNAL(current(int)),this,SLOT(updateCur(int)));
  connect(wid,SIGNAL(tran(int)),this,SLOT(updateTran(int)));
  connect(wid,SIGNAL(setProgress(int)),pb1,SLOT(setProgress(int)));
  connect(wid,SIGNAL(setTotal(int)),pb1,SLOT(setTotalSteps(int)) );
  connect(wid,SIGNAL(resetPb()),pb1,SLOT(reset()) );
  connect(wid,SIGNAL(setStatus(int)),this,SLOT(updateStatus(int)));    
  connect(lv,SIGNAL(setProgress(int)),pb1,SLOT(setProgress(int)));
  connect(lv,SIGNAL(setTotal(int)),pb1,SLOT(setTotalSteps(int)) );
  connect(lv,SIGNAL(resetPb()),pb1,SLOT(reset()) );
  connect(lv,SIGNAL(setStatus(int)),this,SLOT(updateStatus(int)));

  menubar = new KMenuBar(this); //= menuBar();
  QPopupMenu *file = new QPopupMenu;
  file->insertItem(klocale->translate("&Open"), wid,SLOT(openPot()));
  file->insertItem(klocale->translate("&Save as.."), wid, SLOT(makeFile()));
  file->insertItem(klocale->translate("&Quit"), qApp, SLOT(quit()));
  
  QPopupMenu *search  = new QPopupMenu;  
  search->insertItem(klocale->translate("&Search..."), wid,SLOT(search()));
  search->insertItem(klocale->translate("Search &again"), wid,SLOT(searchagain()));
  search->insertItem(klocale->translate("Search and &replace..."), wid,SLOT(replace()));
  search->insertSeparator();  
  search->insertItem(klocale->translate("Go to po &line..."), wid,SLOT(gotoline()));
  search->insertItem(klocale->translate("Go to &msessage..."), wid,SLOT(gotomsg()));

  QPopupMenu *tools  = new QPopupMenu;  
  tools->insertItem(klocale->translate("&Spell Check"), wid,SLOT(spellCheck()));
  tools->insertItem(klocale->translate("&Rough translation"), wid,SLOT(roughTranslation()));
  tools->insertSeparator();  
  tools->insertItem(klocale->translate("Search a translation in .mo files"), wid,SLOT(searchInCats()));
  tools->insertItem(klocale->translate("Search a translation in .po files"), wid,SLOT(searchInMsgList()));


  QPopupMenu *options = new QPopupMenu;  
  options->insertItem(klocale->translate("&General setup"), this,SLOT(setup()));
  options->insertItem(klocale->translate("&Keys setup"), this,SLOT(setupKeys()));
  options->insertItem(klocale->translate("Spell&checker setup"), wid,SLOT(spellCheckConfig()));
  options->insertSeparator();  
  options->insertItem(klocale->translate("&Save options"), this,SLOT(saveopt()));
  
  QPopupMenu *help = new QPopupMenu;
  help->insertItem(klocale->translate("Help"), this, SLOT(HtmlHelp()) );
  help->insertItem(klocale->translate("About"), this, SLOT(about()) );
  menubar->insertItem( klocale->translate("&File"), file );
  menubar->insertItem( klocale->translate("&Search"), search );
  menubar->insertItem( klocale->translate("&Tools"), tools );
  menubar->insertItem( klocale->translate("&Options"), options );


  menubar->insertSeparator();
  menubar->insertItem( klocale->translate("&Help"), help);


  //toolBar();
  toolbar = new KToolBar(this);
  toolbar->setFullWidth(TRUE);
  toolbar->insertButton(Icon("fileopen.xpm"),1,SIGNAL(clicked()), wid,SLOT(openPot()),1,klocale->translate("open a .pot file"));
  toolbar->insertButton(Icon("filefloppy.xpm"),2,SIGNAL(clicked()), wid,SLOT(makeFile()),FALSE,klocale->translate("Make the po files"));
  toolbar->insertSeparator();
  toolbar->insertCombo("",8,FALSE,SIGNAL(activated(int)),this,SLOT(selectedLang(int)),TRUE,i18n("Language"),50);                                                     

  toolbar->insertSeparator();
  toolbar->insertButton(Icon("cvs.xpm"),9,SIGNAL(clicked()),this,SLOT(slotCatMgr()),1,klocale->translate("Show/Hide Catalog Manager"));
  toolbar->insertButton(Icon("spellcheck.xpm"),10,SIGNAL(clicked()),wid,SLOT(spellCheck()),1,klocale->translate("Check the spelling"));
  toolbar->insertButton(Icon("idea.xpm"),11,SIGNAL(clicked()),wid,SLOT(roughTranslation()),1,klocale->translate("Create a rough translation using old translation"));


  navigationbar = new KToolBar(this);
  navigationbar->setBarPos(KToolBar::Right);   
  navigationbar->setFullWidth(TRUE);
  navigationbar->insertButton(Icon("posearch.xpm"), 1,SIGNAL(clicked()), wid,SLOT(searchInMsgList()),1,klocale->translate("Look for a translation in .po files (source catalogues)"));
  navigationbar->insertButton(Icon("mosearch.xpm"),2,SIGNAL(clicked()), wid,SLOT(searchInCats()),1,klocale->translate("Look for a translation in .mo files (compiled catalogues)"));
  navigationbar->insertButton(Icon("header.xpm"),3,SIGNAL(clicked()), wid,SLOT(header()),FALSE,klocale->translate("Write header")); 
  navigationbar->insertButton(Icon("next.xpm"),4,SIGNAL(clicked()), wid,SLOT(storeAndNext()),FALSE,klocale->translate("Go to Next message & Copy OldMsgStr to NewMsgStr"));
  navigationbar->insertButton(Icon("prev.xpm"),5,SIGNAL(clicked()), wid,SLOT(storeAndPrev()),FALSE,klocale->translate("Go to Previous message & Copy OldMsgStr to NewMsgStr")); 
  navigationbar->insertButton(Icon("up.xpm"),6,SIGNAL(clicked()), wid,SLOT(prevID()),FALSE,klocale->translate("Previous message"));
  navigationbar->insertButton(Icon("down.xpm"),7,SIGNAL(clicked()), wid,SLOT(nextID()),FALSE,klocale->translate("Next message"));
  navigationbar->insertButton(Icon("copy-string.xpm"),8,SIGNAL(clicked()), wid,SLOT(storeSTR()),FALSE,klocale->translate("Copy oldmsgstr in newmsgstr"));
  navigationbar->insertButton(Icon("prev-fuzzy.xpm"),9,SIGNAL(clicked()), wid,SLOT(prevFuzzy()),FALSE,klocale->translate("Go to previous message that need a revision"));
  navigationbar->insertButton(Icon("next-fuzzy.xpm"),10,SIGNAL(clicked()), wid,SLOT(nextFuzzy()),FALSE,klocale->translate("Go to next message that need a revision"));
   
  navigationbar->alignItemRight(1,TRUE);
  navigationbar->alignItemRight(2,TRUE);
  navigationbar->alignItemRight(3,TRUE);
  navigationbar->alignItemRight(4,TRUE);  
  navigationbar->alignItemRight(5,TRUE);
  navigationbar->alignItemRight(6,TRUE);
  navigationbar->alignItemRight(7,TRUE);
 navigationbar->alignItemRight(8,TRUE);
 navigationbar->alignItemRight(9,TRUE);
 navigationbar->alignItemRight(10,TRUE);

  acc = new KAccel( wid  );
  acc->insertItem( i18n("Previous"), "PREV", "PageUp" );
  acc->connectItem( "PREV", wid, SLOT( prevID() ) );
  acc->insertItem( i18n("Next"), "NEXT", "PageDown");
  acc->connectItem( "NEXT", wid, SLOT( nextID() ) );
  
  acc->insertItem( i18n("--> (Copy OldMsgStr in NewMsgStr)"), "STORE", "CTRL+Return" );
  acc->connectItem( "STORE", wid, SLOT( storeSTR() ) );
  
  acc->insertItem( i18n("--> & Previous"), "NEXT1", "SHIFT+PageDown");
  acc->connectItem( "NEXT1", wid, SLOT( storeAndNext() ) );
  acc->insertItem( i18n("--> & Next"), "PREV1", "SHIFT+PageUp" );
  acc->connectItem( "PREV1", wid, SLOT( storeAndPrev() ) );
  
  acc->insertItem( i18n("Go to next to be revised"), "NEXT2", "CTRL+PageDown");
  acc->connectItem( "NEXT2", wid, SLOT( nextFuzzy()) );
  acc->insertItem( i18n("Go to prev to be revised"), "PREV2", "CTRL+PageUp" );
  acc->connectItem( "PREV2", wid, SLOT( prevFuzzy() ) );
  
  acc->insertItem( i18n("Look for a translation in old catalogues"), "CATSEARCH", "CTRL+S");
  acc->connectItem( "CATSEARCH", wid, SLOT( searchInCats()) );
  acc->insertItem( i18n("Look for a translation in [lang].messages"), "MSGSEARCH", "CTRL+A" );
  acc->connectItem( "MSGSEARCH", wid, SLOT( searchInMsgList() ) );
  
  acc->insertItem( i18n("Go to .po line"), "GOTOLINE", "ALT+L");
  acc->connectItem( "GOTOLINE", wid, SLOT( gotoline()) );
  acc->insertItem( i18n("Go to message"), "GOTOMESSAGE", "ALT+M" );
  acc->connectItem( "GOTOMESSAGE", wid, SLOT( gotomsg() ) );


  acc->insertStdItem( KStdAccel::Find , i18n("Search") );
  acc->connectItem( KStdAccel::Find , wid, SLOT( searchagain() ) );

  acc->insertStdItem( KStdAccel::Replace , i18n("Replace") );
  acc->connectItem( KStdAccel::Replace , wid, SLOT( replace() ) );


  acc->setEnabled(FALSE);
  acc->readSettings();
  
  //wid->

  fillCombo(toolbar->getCombo(8));
  wid->show();
  if(filename.isEmpty())
  lv->show();
  //mainw->show();
  toolbar->show();
  navigationbar->show();
  menubar->show();
  statusbar->show();

  addToolBar(toolbar);
  addToolBar(navigationbar);
  setStatusBar(statusbar);
  setMenu(menubar);

  enableStatusBar(KStatusBar::Show);
  adjustSize();
  show();

  if (!filename.isEmpty())
    wid->openFile(filename);
  lv->buildDatabase();
  wid->openMsgList(); 

 if(config->readNumEntry("SetUpDone")!=6) {
  config->writeEntry("SetUpDone",6);
  config->sync();
  setup();
 }


}
void KTranslator::slotCatMgr()
{
if(lv->isVisible()) lv->hide(); else 
  lv->show();

}
void KTranslator::updateTot(int n)
{
  QString st;
  st.sprintf(klocale->translate("Total ID:%i"),n);
  statusbar->changeItem(st,2);
}

void KTranslator::updateFuzzy(int n)
{
  QString st;
  st.sprintf(klocale->translate("Fuzzy :%i"),n);
  statusbar->changeItem(st,5);
}

void KTranslator::updateNavBar(int n)
{
  navigationbar->setItemEnabled(n&0x0F,(n>127));
}

void KTranslator::updateStatus(int n)
{
  QString st="";
  if(n==1)
    st.sprintf(klocale->translate("Loading CVS data..."));
  if(n==2)
    st.sprintf(klocale->translate("Opening file..."));
  if(n==4)
    st.sprintf(klocale->translate("Counting old translation..."));
  if(n==3)
    st.sprintf(klocale->translate("Searching ..."));
  if(n==5)
    st.sprintf(klocale->translate("Search done."));
  if(n==6)
    st.sprintf(klocale->translate("Message found!!!"));
  if(n==7)
    st.sprintf(klocale->translate("Search stopped"));
  if(n==8)
    st.sprintf(klocale->translate("Messages roughly translated :"));
  if(n==9)
    st.sprintf(klocale->translate("Spell check ..."));
  	
  statusbar->changeItem(st,6);
}

void KTranslator::openFromCvs()
{
  QString st;
  st=lv->activeMsgPath();
  warning(st);
  if (st!="")
    wid->openFile(st);
}

void KTranslator::openPotFromCvs()
{
  QString st;
  st=lv->activeTemPath();
  warning(st);
  if (st!="")
    wid->openFile(st);
}

void KTranslator::updateCur(int n)
{
  QString st;
  st.sprintf(klocale->translate("Current ID:%i"),n);
  statusbar->changeItem(st,3);
}


void KTranslator::updateFlag(const QPixmap *pix)
{
	
}


void KTranslator::updateTran(int n)
{
  QString st;
  st.sprintf(klocale->translate("Old Cat Translations :%i"),n);
  statusbar->changeItem(st,4);	
	

}
void KTranslator::updateToolbar()
{
  warning("Updating");
  int n;

  acc->setEnabled(TRUE);

  //for(n=0;n<6;n++)  
  //	 toolbar->setItemEnabled(n+1,TRUE);
  for(n=0;n<10;n++)  
    navigationbar->setItemEnabled(n+1,TRUE);


}

void KTranslator::HtmlHelp()
{ 
  KApplication::getKApplication()->invokeHTMLHelp("ktranslator/index.html", "");
}

void KTranslator::about()
{
  QPixmap pm;
  pm.load(kapp->kde_datadir()+"/ktranslator/about.gif"); 
  QString message;
  message.sprintf( "        KTranslator v. %d.%d.%d             \n\n  (C)  Andrea Rizzi <rizzi@kde.org>\n            1998-1999 \n\n   Dedicated to the \" KDE Translation Team \"   \n",0,6,0); 

  QMessageBox *b= new QMessageBox(      "About Ktranslator",message,
					QMessageBox::Warning, 0,0,  0,this);                       
  b->setIconPixmap(pm);
  b->show();

}

void KTranslator::selectedLang(int a)
{
  // warning("selected Lang");
  wid->setLang(Langs[a]);
  lv->setLang(Langs[a]); 
  lv->buildDatabase();
}

void KTranslator::fillCombo(KCombo *comboFlag)
{
  listLang = comboFlag;
  listLang->clear();	
  int n;
  int m;
  QString s;
  QString kdelang;
  kdelang="";
  config->setGroup("Files");
  kdelang=config->readEntry("Lang").copy();
  if(kdelang.isEmpty())
    {
      warning("USing Env KDE_LANG");
      kdelang=getenv("KDE_LANG");
      if(kdelang.isEmpty())
	{
	  KSimpleConfig config1(QDir::homeDirPath()+"/.kderc");
	  config1.setGroup("Locale");  	
	  if(config1.readEntry("Language","C")!="C")
	    kdelang=config1.readEntry("Language");	
	  else
	    {
	      if(getenv("LANG")!="")
		kdelang=getenv("LANG");
	    }
	}
    }
  if(kdelang.find(":")>=0)
    kdelang.truncate(kdelang.find(":") );

  QString ldir = kapp->kde_localedir()+"/*";
  s=kapp->kde_datadir()+"/kcmlocale/pics/";
  //warning(s);
  glob_t globbuf;
  globbuf.gl_offs = 0;
	
  if (glob(ldir,GLOB_DOOFFS , NULL, &globbuf)==0) warning("found!!!!");

  QPixmap pm;
  m=-1;
  for(n=0;n<globbuf.gl_pathc;n++)
    {
      ldir=globbuf.gl_pathv[n];
      ldir.remove(0,ldir.findRev("/")+1);
      if(pm.load(s+"flag_"+ldir+".gif"))
	listLang->insertItem(pm,n);
      else
	listLang->insertItem(ldir,n);	
      Langs[n]=ldir;
      if(ldir==kdelang) m=n;	
    }
  if(m!=-1) listLang->setCurrentItem(m);
  wid->setLang(kdelang);
  lv->setLang(kdelang);
}


TranslGoTo::TranslGoTo(QWidget *parent,const char* name,QString title,QString label)
	    :QDialog(parent,name,TRUE)
{
    setFixedSize(160,80);
    setCaption(title);
    //QLineEdit *
    le = new QLineEdit(this,"line");
    le->setGeometry(70,10,80,30);
    le->setValidator(new QIntValidator(le,"va"));
    connect(le,SIGNAL(returnPressed()),this,SLOT(gonow()));

    QLabel *la = new QLabel(label,this,"label");
    la->setGeometry(10,10,60,30);
    
    QPushButton *pb = new QPushButton(i18n("Go"),this,"go");
    pb->setGeometry(10,45,60,30);
    connect(pb,SIGNAL(clicked()),this,SLOT(gonow()));

    pb = new QPushButton(i18n("Cancel"),this,"canecel");
    connect(pb,SIGNAL(clicked()),this,SLOT(cancel()));
    pb->setGeometry(80,45,60,30);
    
    le->setFocus();
    
    show();
    
}

void TranslGoTo::gonow()
{
done(atoi(le->text()));
}

void TranslGoTo::cancel()
{
close();
}

TranslAskReplace::TranslAskReplace(QWidget *parent,const char* name)
	    :QDialog(parent,name,TRUE)
{
   setFixedSize(300,100);
   setCaption(i18n("Replace prompt"));
   QLabel *la =new QLabel(i18n("Replace in this msgstr ?"),this);    
   la->setGeometry(10,10,200,30);
    QPushButton *pb = new QPushButton(i18n("&Yes"),this,"go");
    pb->setGeometry(5,60,70,30);
    connect(pb,SIGNAL(clicked()),this,SLOT(yes()));
    pb = new QPushButton(i18n("&No"),this,"No");
    pb->setGeometry(80,60,70,30);
    connect(pb,SIGNAL(clicked()),this,SLOT(no()));
    pb = new QPushButton(i18n("Yes to &all"),this,"all");
    connect(pb,SIGNAL(clicked()),this,SLOT(all()));
    pb->setGeometry(155,60,70,30);    
    pb = new QPushButton(i18n("Stop"),this,"stop");
    connect(pb,SIGNAL(clicked()),this,SLOT(cancel()));
    pb->setGeometry(230,60,70,30);
  done(-1);
}

void TranslAskReplace::yes()
{
done(1);
}
void TranslAskReplace::no()
{
done(3);
}
void TranslAskReplace::all()
{
done(2);
}
void TranslAskReplace::cancel()
{
done(0);
}



TranslSearch::TranslSearch(QWidget *parent,const char* name,bool replace,int Flags)
	    :QDialog(parent,name,TRUE)
{
    flags=Flags;
    int ysize=0;
    if( replace) ysize=40;
    setFixedSize(300,140+ysize);
    
    if(replace) setCaption(i18n("Search and replace in msgstr"));
    else setCaption(i18n("Search in ..."));
    
    //QLineEdit *
    le = new QLineEdit(this,"line");
    le->setGeometry(70,10,220,30);
    if(!replace)
    connect(le,SIGNAL(returnPressed()),this,SLOT(searchnow()));
    QLabel *la;
    if(replace) 
    {
     leR = new QLineEdit(this,"line");
     leR->setGeometry(70,50,220,30);
     connect(leR,SIGNAL(returnPressed()),this,SLOT(searchnow()));
     la = new QLabel(i18n("Replace:"),this,"label");
     la->setGeometry(10,50,60,30);
    
    }
    la = new QLabel(i18n("Search:"),this,"label");
    la->setGeometry(10,10,60,30);
    
    flagBox[3] = new QCheckBox(i18n("Ignore case"),this,"first");
    flagBox[3]->setGeometry(10,50+ysize,130,30);
    flagBox[3]->setChecked(flags &   8  );
    if(replace)
    {
      flagBox[0] = new QCheckBox(i18n("Prompt on replace"),this,"first");
      flagBox[0]->setGeometry(10,80+ysize,130,30);
      flagBox[0]->setChecked(flags &   1 );
      flagBox[1] = new QCheckBox(i18n("Replace all"),this,"first");
      flagBox[1]->setGeometry(150,50+ysize,130,30);
      flagBox[1]->setChecked(flags &   2 );

   flagBox[2] = new QCheckBox(i18n("In comments"),this,"first");
    flagBox[2]->setGeometry(150,80+ysize,130,30);
    flagBox[2]->setChecked(flags &  4  );
    flagBox[2]->hide();
    }
    else
    {
   flagBox[1] = new QCheckBox(i18n("In MsgID"),this,"first");
    flagBox[1]->setGeometry(150,50+ysize,130,30);
    flagBox[1]->setChecked(flags &   2  );

   flagBox[0] = new QCheckBox(i18n("In MsgStr"),this,"first");
    flagBox[0]->setGeometry(10,80+ysize,130,30);
    flagBox[0]->setChecked(flags &  1);

   flagBox[2] = new QCheckBox(i18n("In comments"),this,"first");
    flagBox[2]->setGeometry(150,80+ysize,130,30);
    flagBox[2]->setChecked(flags &  4  );
    
    }
    QPushButton *pb = new QPushButton(i18n("Go"),this,"go");
    pb->setGeometry(5,110+ysize,70,30);

//    if(!replace)
     connect(pb,SIGNAL(clicked()),this,SLOT(searchnow()));
//    else
//    {
/*    connect(pb,SIGNAL(clicked()),this,SIGNAL(search()));
    pb = new QPushButton(i18n("&Replace"),this,"canecel");
    pb->setGeometry(80,110+ysize,70,30);
    connect(pb,SIGNAL(clicked()),this,SIGNAL(replace()));
    pb = new QPushButton(i18n("Replace &all"),this,"canecel");
    connect(pb,SIGNAL(clicked()),this,SIGNAL(replaceall()));
    pb->setGeometry(155,110+ysize,70,30);    
*/ 
//    }
    
    pb = new QPushButton(i18n("Cancel"),this,"canecel");
    connect(pb,SIGNAL(clicked()),this,SLOT(cancel()));
    pb->setGeometry(230,110+ysize,70,30);
    
    le->setFocus();
    
    show();
}

void TranslSearch::searchnow()
{
int i;
flags=0;
for(i=0;i<4;i++)
if(flagBox[i]->isChecked())
     flags+=(1<<i);
done(1);
}
void TranslSearch::cancel()
{
close();
}

int TranslSearch::getFlags()
{
return flags;
}

QString TranslSearch::getStr()
{
return le->text();
}

QString TranslSearch::getReplaceStr()
{

return leR->text();

}

TranslData::TranslData(QWidget *parent,const char* name):Inherited(parent,name)
{

  scroll=true;
  KApplication *app=KApplication::getKApplication();
  config=app->getConfig();
  nameFile="";
  doc_modif=false;
  stopSearch=false;
  mlTranslation=false;
  searchStr="";
  replaceStr="";
  fl=1;
  spellchecking=false;
  spellconf= new KSpellConfig();
  spell=0;

  Id.resize(100);
  Com.resize(100);
  Str.resize(100);
  poLine.resize(100);
  cat.resize(100);
  Com[0]=new QList<QString>;
  Com[0]->append(new QString(""));
  Id[0]=new QList<QString>;
  Id[0]->append(new QString(""));
  Str[0]=new QList<QString>;
  Str[0]->append(new QString("NO FILE OPENED"));
	
  nid=0;
  nmax=0;
  QLabel* tmpQLabel;
 
  QGridLayout *layout0,*layout1,*layout2,*layout3,*layout4;
  layout0  = new QGridLayout(this,1,2);
  layout1  = new QGridLayout(3,1);
  layout2  = new QGridLayout(4,1);
  layout3  = new QGridLayout(1,2);
  layout4  = new QGridLayout(1,2);
  layout0->addLayout(layout1,0,0);
  layout0->addLayout(layout2,0,1);
  layout2->addLayout(layout3,2,0);
  layout2->addLayout(layout4,0,0);
  
  layout0->setColStretch(0,0);
  layout1->addColSpacing(0,100);
  layout0->setColStretch(1,1);
  
  layout1->setRowStretch(0,0);
  layout1->addRowSpacing(0,180);
  layout1->setRowStretch(1,0);
  layout1->addRowSpacing(1,30 );
  layout1->setRowStretch(2,1);
  
  layout2->setRowStretch(0,0);
  layout2->addRowSpacing(0,20 );
  layout2->setRowStretch(1,1);
  
  layout2->setRowStretch(2,0);
  layout2->addRowSpacing(2,20 );
 
  layout4->setColStretch(1,0);
  layout4->addColSpacing(1,180);
  layout4->setColStretch(0,1);
 
  
  
  QFrame *monitor = new QFrame(this);
   
  monitor->setGeometry(10,30,100,200);
  layout1->addWidget(monitor,0,0);
  
  monitor->setBackgroundColor(black);
  monitor->setFontPropagation(QWidget::AllChildren);
  QColorGroup cg(green,black,black,black,black,green,black);
  QColorGroup cg1(darkGreen,black,black,black,black,darkGreen,black);

  tmpQLabel = new QLabel( monitor, "Label H" );
  tmpQLabel->setGeometry( 0, 0, 100, 20 );
  tmpQLabel->setText(klocale->translate( "Translated in:") );

  tmpQLabel = new QLabel( monitor, "Label H1" );
  tmpQLabel->setGeometry( 0, 85, 100, 20 );
  tmpQLabel->setText(klocale->translate( "Translation is:") );

  lamp[0] = new QLabel(monitor);
  lamp[0]->setGeometry(5,25,100,20);
  lamp[0]->setPalette(QPalette(cg,cg1,cg1));
  lamp[0]->setText(".po file");
  lamp[0]->setEnabled(false);
  lamp[0]->setFont(QFont("clean",12,QFont::Normal));

  lamp[1] = new QLabel(monitor);
  lamp[1]->setGeometry(5,45,100,20);
  lamp[1]->setPalette(QPalette(cg,cg1,cg1));
  lamp[1]->setText("Catalogues");
  lamp[1]->setEnabled(false);
  lamp[1]->setFont(QFont("clean",12,QFont::Normal));

  lamp[2] = new QLabel(monitor);
  lamp[2]->setGeometry(5,65,100,20);
  lamp[2]->setPalette(QPalette(cg,cg1,cg1));
  lamp[2]->setText("This cat");
  lamp[2]->setEnabled(false);
  lamp[2]->setFont(QFont("clean",12,QFont::Normal));

  lamp[3] = new QLabel(monitor);
  lamp[3]->setGeometry(5,105,100,20);
  lamp[3]->setPalette(QPalette(cg,cg1,cg1));
  lamp[3]->setText("Fuzzy");
  lamp[3]->setEnabled(false);
  lamp[3]->setFont(QFont("clean",12,QFont::Normal));

  lamp[4] = new QLabel(monitor);
  lamp[4]->setGeometry(5,125,100,20);
  lamp[4]->setPalette(QPalette(cg,cg1,cg1));
  lamp[4]->setText("C-Format");
  lamp[4]->setEnabled(false);
  lamp[4]->setFont(QFont("clean",12,QFont::Normal));

  lamp[5] = new QLabel(monitor);
  lamp[5]->setGeometry(5,145,100,20);
  lamp[5]->setPalette(QPalette(cg,cg1,cg1));
  lamp[5]->setText("Identical");
  lamp[5]->setEnabled(false);
  lamp[5]->setFont(QFont("clean",12,QFont::Normal));

    
  QSplitter *split = new QSplitter(QSplitter::Vertical,this);//,"a",0,40);
 
  layout2->addWidget(split,1,0);
 
  split->setGeometry(120,30,650,280);
  QSplitter *split1 = new QSplitter(QSplitter::Horizontal,split);//split,"b",1,40);
  split1->setGeometry(120,30,650,280);
  QSplitter *split2 = new QSplitter(QSplitter::Horizontal,split);//split,"c",1,40);
  split2->setGeometry(120,30,650,280);
 
		
  editID = new QMultiLineEdit( split1, "MultiLineEdit_1" );
  editID->setGeometry( 120, 30, 270, 120 );
  editID->resize(100,100);
  editID->insertLine( "" );
  editID->setReadOnly( TRUE );
  editID->setOverwriteMode( FALSE );

  editSTR = new QMultiLineEdit( split2, "MultiLineEdit_2" );
  editSTR->setGeometry( 120, 260, 200, 120 );
  editSTR->insertLine( "" );
  editSTR->setReadOnly( TRUE );
  editSTR->setOverwriteMode( FALSE );
	
  editC = new QMultiLineEdit( split1, "MultiLineEdit_3" );
  //	editC->setGeometry( 520, 30, 250, 120 );
  editC->insertLine( "" );
  editC->setReadOnly( FALSE );
  editC->setOverwriteMode( FALSE );

  editNSTR = new QMultiLineEdit( split2, "MultiLineEdit_3" );
  //	editNSTR->setGeometry( 520, 260, 250, 120 );
  editNSTR->insertLine( "" );
  editNSTR->setReadOnly( FALSE );
  editNSTR->setOverwriteMode( FALSE );
  editNSTR->setGeometry( 120, 260, 230, 120 );
 
  connect(editNSTR,SIGNAL(textChanged()),this,SLOT(modified()) );
  connect(editC,SIGNAL(textChanged()),this,SLOT(modified()) );


  tmpQLabel = new QLabel( this  , "Label_1" );
  tmpQLabel->setGeometry( 120, 5, 110, 20 );
  tmpQLabel->setText(klocale->translate( "Old Msgstr (search result)" ));
  tmpQLabel->setMargin( -1 );
  tmpQLabel->setAlignment(AlignLeft );
        
  layout3->addWidget(tmpQLabel,0 ,0);
  tmpQLabel = new QLabel( this  , "Label" );
  tmpQLabel->setGeometry( 660, 5, 110, 20 );
  tmpQLabel->setText( klocale->translate("New Msgstr") );
  tmpQLabel->setAlignment(AlignRight );
  layout3->addWidget(tmpQLabel,0 ,1);
  	
  tmpQLabel = new QLabel( this, "Label_2" );
  tmpQLabel->setGeometry( 120, 10, 120, 20 );
  tmpQLabel->setText(klocale->translate( "Msgid") );
  tmpQLabel->setAlignment( 289 );
  tmpQLabel->setMargin( -1 );
  layout4->addWidget(tmpQLabel,0 ,0);
  	
  listCat = new QListBox( this, "ListBox_1" );
  listCat->setGeometry( 10, 220, 100, 160 );
  connect( listCat, SIGNAL(selected(int)), SLOT(selectedCat(int)) );
  listCat->setFrameStyle( 51 );
  listCat->setLineWidth( 2 );
  layout1->addWidget(listCat,2 ,0);

  tmpQLabel = new QLabel( this, "Label_4" );
  tmpQLabel->setGeometry( 10, 200, 100, 20 );
  tmpQLabel->setText( klocale->translate("Catalogues:") );
  layout1->addWidget(tmpQLabel,1 ,0);

  /*	QPushButton* tmpQPushButton;
	PushButton[0] = new QPushButton( this, "PushButton_2" );
	PushButton[0]->setGeometry( 550, 315, 100, 30 );
	connect( PushButton[0], SIGNAL(clicked()), SLOT(prevID()) );
	PushButton[0]->setText(klocale->translate( "Previous") );
	PushButton[0]->setAutoRepeat( TRUE );
	PushButton[0]->setAutoResize( FALSE );

	PushButton[1] = new QPushButton( this, "PushButton_3" );
	PushButton[1]->setGeometry( 550, 350, 100, 30 );
	connect( PushButton[1], SIGNAL(clicked()), SLOT(nextID()) );
	PushButton[1]->setText( klocale->translate("Next") );
	PushButton[1]->setAutoRepeat( TRUE );
	PushButton[1]->setAutoResize( FALSE );

	
	
	PushButton[4] = new QPushButton( this, "PushButton_4" );
	PushButton[4]->setGeometry( 330, 315, 100, 30 );
	connect( PushButton[4], SIGNAL(clicked()), SLOT(storeSTR()) );
	PushButton[4]->setText( "-->" );
	PushButton[4]->setAutoRepeat( FALSE );
	PushButton[4]->setAutoResize( FALSE );	

	PushButton[3] = new QPushButton( this, "PushButton_5" );
	PushButton[3]->setGeometry( 440, 350, 100, 30 );
	connect( PushButton[3], SIGNAL(clicked()), SLOT(storeAndNext()));
	PushButton[3]->setText( klocale->translate("-> && Next") );
	PushButton[3]->setAutoRepeat( TRUE );
	PushButton[3]->setAutoResize( FALSE );

	labelID = new QLabel( this, "Label_5" );
	labelID->setGeometry( 130, 350, 50, 30 );
	
	labelID->setText( "000/000" );
	labelID->setAlignment( 289 );
	labelID->setMargin( -1 );

	PushButton[2] = new QPushButton( this, "PushButton_5" );
	PushButton[2]->setGeometry( 440, 315, 100, 30 );
	connect( PushButton[2], SIGNAL(clicked()),this, SLOT(storeAndPrev()) );
	PushButton[2]->setText( klocale->translate("-> && Prev") );
	
	PushButton[5] = new QPushButton( this, "PushButton_6" );
	PushButton[5]->setGeometry( 330, 350, 100, 30 );
	connect( PushButton[5], SIGNAL(clicked()),this, SLOT(header()) );
	PushButton[5]->setText( klocale->translate("Header->"));

	PushButton[6] = new QPushButton( this, "PushButton_8" );
	PushButton[6]->setGeometry( 680, 350, 80, 30 );
	connect( PushButton[6], SIGNAL(clicked()),this, SLOT(scrollOn()) );

	PushButton[6]->setText( klocale->translate("Continue!"));
  */



  PushButton[7] = new QPushButton( this, "PushButton_9" );
  PushButton[7]->setGeometry( 570, 10, 200, 20 );
  connect( PushButton[7], SIGNAL(clicked()),this, SLOT(removeFuzzy()) );
  PushButton[7]->setText( klocale->translate("Remove \"fuzzy\" string"));
  layout4->addWidget(PushButton[7],0 ,1);

  //	int i;
  resize(780,400);         
  //	 updateEd();

}


TranslData::~TranslData()
{
}


int TranslData::msgListTranslation(QString s,int fla=0)
{
 static QFile *mlf=0;
 static open=false;
 if(open) return -2;
 open=true;
  stopSearch=false;
  mlTranslation=false;
  if ((fla==1)|| (mlf==0))
   mlf=srcList.first();
 
  config->setGroup("Search");
  bool CS=config->readBoolEntry("Case");    
  bool SN=config->readBoolEntry("BackSlashN");    
  bool RDOT=config->readBoolEntry("Dots");        
  bool RAMP=config->readBoolEntry("Ampersand");
  QString iList=config->readEntry("Other");
  bool OTHER=!iList.isEmpty();
  bool CONTS=config->readBoolEntry("Contains");
  bool CONTD=config->readBoolEntry("Contained");
  bool EQUAL=config->readBoolEntry("Equal");
  bool a,b,c;
  int noth=0;

  if(OTHER)
    {
      int h;
      noth=iList.length();

      for(h=0;h<noth;h++)  
	while (s.find(iList[h])>=0)
	  s.remove(s.find(iList[h]),1);
    }
  if(!CS)
    s=s.upper();
  if(RDOT)
    while (s.find(".")>=0)
      s.remove(s.find("."),1);
  if(RAMP)
    while (s.find("&")>=0)
      s.remove(s.find("&"),1);
  if(SN)
    while (s.find("\n")>=0)
      s.remove(s.find("\n"),1);

  //warning(s);   
  QString st,sa;
  for(;mlf!=0;mlf=srcList.next())
  if(mlf->exists()){
    QTextStream t(mlf);
    emit resetPb();
    emit setStatus(3);
    emit setTotal(mlf->size());
//    emit setProgress(mlf->at());    

    while(!stopSearch && !mlTranslation && !t.eof()) 
      {
	st = t.readLine();
	while (st.find(" ")==0)
	  st = st.right(st.length()-1); 
	if(st.find("msgid")==0)
	  {
	    sa="";
	    while(!t.eof() && !(st.find("msgstr")==0)) 
	      {
		sa+=st.right(st.length()-st.find("\"")-1);
		if(sa.find("\"")!=-1)
		  sa.truncate(sa.findRev("\""));
		if(sa.length()==sa.findRev("\\n")+2)
		  sa.truncate(sa.findRev("\\n"));

		st = t.readLine();
		sa+="\n";
		while (st.find(" ")==0)
                  st = st.right(st.length()-1); 
	      }
	  } 
	if(sa.findRev("\n"))
	  sa.truncate(sa.findRev("\n"));      
   
	if (!CS)    sa=sa.upper();
	//    if(sa.contains(s.data()))
	//     warning(sa);

	if(SN)
	  while (sa.find("\n")>=0)
	    sa.remove(sa.find("\n"),1);


	if(RDOT)
	  while (sa.find(".")>=0)
	    sa.remove(sa.find("."),1);
	if(RAMP)
	  while (sa.find("&")>=0)
	    sa.remove(sa.find("&"),1);
	if(OTHER)
	  {
	    for(int k=0;k<noth;k++)
	      while (sa.find(iList[k])>=0)
		sa.remove(sa.find(iList[k]),1);
	  }

	if (CONTS)
	  a=sa.contains(s.data());
	else a=false;

	if (CONTD)
	  b=s.contains(sa.data());
	else b=false;    
	if(EQUAL)
	  c=(sa==s); 
	else c=false;
	if(a||b||c) 
	  {
	    //warning(sa);	
	    //warning(s);
	    int lines=0;
	    sa=""; 
	    while(!t.eof() && !(st.find("msgid")==0) && !(st.find("\"")<0)) 
	      {
		lines++;
		//    warning(sa);
		//    warning(st);
		sa+=st.right(st.length()-st.find("\"")-1);
		if(sa.find("\"")!=-1)
		  sa.truncate(sa.findRev("\""));
		sa+="\n";
		st = t.readLine();
		while (st.find(" ")==0)
                  st = st.right(st.length()-1); 
	      }
    
    
	    mlTranslation=true;
	    editSTR->clear();
	    if (lines>1) sa.insert(0,"\n");
	    editSTR->setText(sa);


	    updateEd();    
	  }
	emit setProgress(mlf->at());    
	KApplication::getKApplication()->processEvents();     
      }
  

    if(t.eof()) mlf->at(0);
     else if(mlTranslation) {open=false;return 1;}
      else if(stopSearch) {open=false;return 2;}

    //  emit setProgress(mlf->size());    
    //      warning("%d",mlf->at());    
  } 
  mlf=srcList.first();
  open=false;
  return 0;
}
void TranslData::openMsgList()
{
  
  QFile *mlf;
  for ( mlf=srcList.first(); mlf != 0; mlf=srcList.next() )
     mlf->close();   
  srcList.clear();
  
    config->setGroup("SourceCat");
    //if(sourceList.isEmpty());
    int num=config->readNumEntry("NumItem");
    int i; 
    QString s,name;
    for(i=0;i<num;i++)
    {
        s.sprintf("File%d",i+1);
        name=config->readEntry(s).copy();
	
  name.replace(QRegExp("%LANG%"),lang.copy());
  if(!name.isEmpty()) 
  {
  glob_t globbuf;
  globbuf.gl_offs = 0;
  int n;	 
  if (glob(name,GLOB_DOOFFS , NULL, &globbuf)!=0) warning("not found");
  for(n=0;n<globbuf.gl_pathc;n++) 
    {
      s=globbuf.gl_pathv[n];

    mlf=new QFile(s);
  if (! mlf->open(IO_ReadOnly) ) {
    warning("cannot open %s",mlf->name());
   delete mlf;
    }
    else {
         srcList.append(mlf);    
        //warning(s);
       }
   }
  }
 }
 
}

void TranslData::setLang(QString language)
{
  lang=language.copy();
  openMsgList();
  openCats(lang);
  updateEd();
}

void TranslData::scrollOn()
{
  setScroll(TRUE);
}

void TranslData::removeFuzzy()
{
  QString s;
  s=editC->text().copy();
  //warning(s);
  s.replace(QRegExp(", fuzzy"),"");
  editC->clear();
  //warning(s);
  editC->setText(s);
}

void TranslData::header()
{
  unsigned int i;
  QString s,st;
  st="";
  editNSTR->clear();
  //editNSTR->insertLine(st);
  config->setGroup("Header");
  for(i=0;i<(unsigned int)config->readNumEntry("NumLines");i++)
    {
      s.sprintf("HLine%d",i+1);    
      st=config->readEntry(s).copy();
      config->setGroup("Identity");
      st.replace(QRegExp("%TIME%"),QTime::currentTime().toString().copy());
      st.replace(QRegExp("%DATE%"),QDate::currentDate().toString().copy());
      st.replace(QRegExp("%AUTHORNAME%"),config->readEntry("Name"));
      st.replace(QRegExp("%AUTHOREMAIL%"),config->readEntry("EMail"));
      st.replace(QRegExp("%LANGLIST%"),config->readEntry("MList"));
      st.replace(QRegExp("%LANGUAGE%"),config->readEntry("Language"));
      if(i<Str[nid]->count()) st.replace(QRegExp("%ORIGINAL%"),Str[nid]->at(i)->copy());
      else  st.replace(QRegExp("%ORIGINAL%"),"");
      config->setGroup("Header");    
      editNSTR->insertLine(st);
    }      
}



void TranslData::makeFile()
{
  QFile theSaveFile;
  QString *sa;
  config->setGroup("Files");
  QString nameSaveFile;
  nameSaveFile = KFileDialog::getSaveFileName(config->readEntry("BasePath"),"*.po*");
  warning(nameSaveFile);
  if (nameSaveFile.isNull()) return;
  archive();
  doc_modif=false;
  theSaveFile.setName(nameSaveFile);
  if ((theSaveFile.open(IO_WriteOnly) ) ) { 
    QTextStream ts( &theSaveFile );        // use a text stream
    QString s,st;               
    int a,f=0,n = 0;
    a=0;   
    if(Com[0]->first()->find("# KTranslator Generated File")<0)
      ts << "# KTranslator Generated File\n";
    for(n=1;n<=nmax;n++) {       
      for ( sa=Com[n-1]->first(); sa != 0; sa=Com[n-1]->next() )
	{   
	  s=sa->copy();
	  ts << (QString) s;
	  ts <<"\n";
	} 
      //Write msgid
      f=0;
      ts<< "msgid ";			    
      if (Id[n]->isEmpty()){ ts << "\"\"\n";} else{
	for ( sa=Id[n]->first(); sa != 0; sa=Id[n]->next() )
	  {   
	    if(f>0)ts << "\"\n";  
	    ts << "\""; 
	    s=sa->copy();
	    ts << (QString) s;
				
	    f++;	
	  }
	ts << "\"\n";  }

			    
      //Write msgstr 
      f=0;
      ts<< "msgstr ";			    
      if (Str[n]->isEmpty()){ ts << "\"\"\n";} else{
	for ( sa=Str[n]->first(); sa != 0; sa=Str[n]->next() )
	  {   
	    if(f>0)ts << "\"\n";  
	    ts << "\""; 
	    s=sa->copy();
	    ts << (QString) s;
				
	    f++;	
	  }
	ts << "\"\n";  }

			    		     
      st.sprintf("%i/%i",n,n);
      // labelID->setText(st) ;		 
    }
    f=0;
    for ( sa=Com[n-1]->first(); sa != 0; sa=Com[n-1]->next() )
      {   
	if(f>0) ts <<"\n";
	f++;
	s=sa->copy();
	ts << (QString) s;
      } 
    theSaveFile.close();
  }

}


void TranslData::openPot()
{
  
  openFile(QString()); 

}

void TranslData::openFile(QString name)
{
  static bool opening=false;
  if (opening) return;
  opening=true;

  QString s,st;
  
  if (!doc_modif)
    nameFile=name.copy();
  else
    {
      int rc=QMessageBox::warning(this,i18n("File unsaved"),i18n("The current Document has been modified.\n Would you like to save it?"),
				  i18n("&Yes"),i18n("&No"),i18n("&Cancel"));
      warning("%d",rc);
      if (rc==0) 
      {
	makeFile();
	nameFile=name.copy();
      }
      if (rc==1)
	nameFile=name.copy();
      if (rc==2)
   {
        opening=false;
        return ;
       }
    }

  config->setGroup("Files");
  if(nameFile.isNull())
    nameFile=(KFileDialog::getOpenFileName(config->readEntry("BasePath"),"*.po*" )).copy();
  if(nameFile.isNull()) 
  {
  opening=false;
   return;
   }
  theFile.setName(nameFile);
  update();
  show();
  if ( theFile.open(IO_ReadOnly) ) {
    emit resetPb();
    emit setStatus(2);
    emit setTotal(theFile.size());
    KApplication::getKApplication()->processEvents();     
    int a=0,f=0,n=0,oldn = -10;
    bool fuz=false;     
    int nfu=0;
    nid=0;
    Com[0]=new QList<QString>;
    Com[0]->append(new QString(""));
    Id[0]=new QList<QString>;
    Id[0]->append(new QString(""));
    Str[0]=new QList<QString>;
    Str[0]->append(new QString("NO FILE OPENED"));

    for(a=1;a<=nmax;a++)
      {
	Com[a]->setAutoDelete(TRUE);     
	delete Com[a];
	Id[a]->setAutoDelete(TRUE);
	delete Id[a];
	Str[a]->setAutoDelete(TRUE);
	delete Str[a];
      }

    a=0;	             
    Id.resize(100);
    Com.resize(100);
    Str.resize(100);
    poLine.resize(100);
    
    QTextStream t( &theFile );        // use a text stream
    s.sprintf("KTranslator - %s",(const char *)nameFile);   
    topLevelWidget()->setCaption(s);    
    int ns=0;
	     
    int line=0;  

    while ( (!t.eof())&&(n>=0) ) {        // until end of file...                          
      s = t.readLine();       
      line++;
      emit setProgress(theFile.at());    
      /*
	Normalize process..
	I'll check if everything work well with it..
	    
      */
      while (s.find(" ")==0)
	s = s.right(s.length()-1); 


	
		
      if ((s.find("#")==0)) a=0; else {
	if (s.find("msgid")==0) { 
	  
	  a=2;
	  n++;
	  f=0; 
	  if(n % 100 == 0)
	  {
	   poLine.resize(n+100);
	   Str.resize(n+100);
	   Com.resize(n+100);
	   Id.resize(n+100);
	  }
	  Id[n]=new QList<QString>;
	  Com[n]=new QList<QString>;		
//	   Id[n]=new QList<QString>;  // ??????
	  poLine[n]=line;
	}
	if (s.find("msgstr")==0) { 
	  if (fuz){ nfu++; fuz=false; }
	  if (n==oldn) n=-60;
	  oldn=n;
	  a=1; 
	  f=0; 
	  Str[n]=new QList<QString>;
	  ns++;
	}					
		
	if ((s.find("\"")<0)) a=0;}
		
	

      if (a>0) {
	s.remove(0,s.find("\"")+1); 
	s.truncate(s.findRev("\"")); 
	if (a==1) Str[n]->append(new QString(s));
	if (a==2) Id[n]->append(new QString(s));
	f++;
      } else
	{
	  Com[n]->append(new QString(s));
	  if(s.find("fuzzy")>=0) fuz=true;
	} 
   
      st.sprintf("%i/%i",n,n); //sizeof(Str));

      //labelID->setText(st) ;
      nmax=n;      
    }
    emit setProgress(theFile.size());    
    theFile.close();
    emit fuzzy(nfu);
    //warning("%i",nfu);
    if ((n<1)||(a==2)|| (n!=ns))  {
      QMessageBox :: information( this, "KTranslator ", "It is not a valid .po/.pot file!" ,"Ok");
        for(nid=0;nid<10;nid++) 
  	upNavBar(nid);
	  Com[0]=new QList<QString>;
	  Com[0]->append(new QString(""));
	  Id[0]=new QList<QString>;
	  Id[0]->append(new QString(""));
	  Str[0]=new QList<QString>;
	  Str[0]->append(new QString("NO FILE OPENED"));
	  nid=0;
	  n=0;
	  nmax=0;
      //	  PushButton[nid]->setEnabled( FALSE );
         
    } else {
      fileOpened();
      for(n=0;n<10;n++)  
	upNavBar(nid+128);
    
      //                PushButton[n]->setEnabled( TRUE );	

      nid=1;
      //	 update();
      updateEd();
      //	 repaint();
      int k=0;
      int ni;
      emit resetPb();
      emit setStatus(4);
      emit setTotal(nmax);
      KApplication::getKApplication()->processEvents();     
      for(ni=1;ni<=nmax;ni++)
	{
	  if(isItTranslated(ni)>-1) k++;         
       KApplication::getKApplication()->processEvents();     

	  tran(k);	  
	  emit setProgress(ni);
	}
      total(nmax);
      current(nid);

    }
  }
  updateEd();

  
opening=false;
}

int TranslData::isItTranslated(int ni)
{ 

  if (ncat<0) return -1;
  int i,t=0,a;  
  a=listCat->currentItem();
  if (a<0) a=0;
  for(i=a+1;i<ncat;i++)
    if(aMsgId(ni)!=cat[i]->translate(aMsgId(ni))  )
      {t=i; return(t); }	
	  
  for(i=0;i<=a;i++)
    if(aMsgId(ni)!=cat[i]->translate(aMsgId(ni))  )
      {t=i; return(t); }	
		
  return(-1);
}

QString TranslData::aMsgId(int i)
{
  if (nmax<i) return("");
  QString s,sn;
  QString *sa;
  int n=0;
  sa=Id[i]->first();
  if(!isMulti(i)) 
    s=sa->copy(); 
  else
    for ( ;sa != 0; sa=Id[i]->next() )
      {
	sn=sa->copy();
 	if(sn.find("\\n")>=0) {          
	  sn.truncate(sn.find("\\n")); 
	   sn+="\n";  
	 }
	s+=sn;
	n++;   
      }  
  return (s);
}

bool TranslData::isMulti(int i)
{
  return((Id[i]->count()>1)||((i==1)||(Id[i]->first()->isEmpty())));
}

void TranslData::updateEd() //Update everything in Main Dialog
{
  bool old;
  old=doc_modif;
  config->setGroup("Translation");
  QString s;
  QString *sa;
  int l,i,n=0,ca;
  if (nid==1)
    upNavBar(3+128);   
  else
    upNavBar(3);
  /*
    Clear Multi Line Editors
  */
  msgEmpty=FALSE;
  msgFuzzy=FALSE;
  msgSame=FALSE;
   editID->clear();
  editC->clear();


//WARNING

  if(!mlTranslation)  editSTR->clear();
  
  editNSTR->clear();

  /*
    Copy MsgId in ID Multi Line Editor
  */
  for ( sa=Id[nid]->first(); sa != 0; sa=Id[nid]->next() )
    editID->insertLine(sa->copy());
  /*
    Insert Comment before msgid
  */
  if(nid>0) for ( sa=Com[nid-1]->first(); sa != 0; sa=Com[nid-1]->next() )
    editC->insertLine(sa->copy());
  else
    editC->insertLine("KTranslator 0.6.0\n(C) Andrea Rizzi <rizzi@kde.org>\n  1998-1999");
 
  /*
    Get The ID string
    Get Cat Number
  */
  s=aMsgId(nid);
  n=listCat->currentItem();
  ca=isItTranslated(nid);

  if(ncat>=0) {  
    if(cat[n]->translate(s)!=s) 
      {
        lamp[2]->setEnabled(true);
      }   
    else
      {
        
        if ((ca>-1)&&(config->readNumEntry("AutoSearch")==1)) {
	  n=ca;
	  listCat->setCurrentItem(n);
	  lamp[2]->setEnabled(true);
	} else {
	  setScroll(FALSE,5);
	  lamp[2]->setEnabled(false);
	}
      } 
    if(ca>-1) 
      {
        lamp[1]->setEnabled(true);
    	
      }   
    else
      {
	setScroll(FALSE,4);
        lamp[1]->setEnabled(false);
	//	setScroll(TRUE);
      }     

  }
  if(isMulti(nid))  editSTR->insertLine(""); 
  if(!mlTranslation)
    {
      if(ncat>=0)
	editSTR->insertLine(cat[n]->translate(s));
  
      l=editSTR->numLines(); 
      if(l>=2) 
	{ for(i=2;i< l;i++)
//	 if(Id[nid]->at(i)->find("\\n")>=0)
	 editSTR->insertAt("\\n",i-1,editSTR->text().length());
	}
    }
  n=0;
   
  for ( sa=Str[nid]->first(); sa != 0; sa=Str[nid]->next())  
    editNSTR->insertLine(sa->copy());
     
  if(editNSTR->text()!="") {  
    lamp[0]->setEnabled(true);
    setScroll(FALSE,6);
    
  }
  else{
    lamp[0]->setEnabled(false);
    setScroll(FALSE,3);
  msgEmpty=TRUE;
  }
  
  if(editC->text().find("fuzzy",0,FALSE)>0)  
    {
      PushButton[7]->setEnabled(TRUE);
      lamp[3]->setEnabled(true);
      setScroll(FALSE,1);
      msgFuzzy=TRUE;
 
    }
  else {
    PushButton[7]->setEnabled(FALSE);
    lamp[3]->setEnabled(false);
  }
  if(editC->text().find("c-format",0,FALSE)>0)  
    lamp[4]->setEnabled(true);
  else
    lamp[4]->setEnabled(false);
 
  if(editNSTR->text()==editID->text()){  
    lamp[5]->setEnabled(true);
    msgSame=true;
    setScroll(FALSE,2);
  }
  else{
    lamp[5]->setEnabled(false);
    msgSame=false;
  }
	
  //update();
  doc_modif=old;
}

void TranslData::selectedCat(int)
{
  updateEd();
}

void TranslData::modified()
{
  doc_modif=true;
}

void TranslData::setScroll(bool status,int event = 0)
{
//  int i;
  config->setGroup("Translation");
  if(event==0) scroll=status;
  //scroll=TRUE;
  if (!status) {
    if(event);
    /*  if (PushButton[1]->isDown() || PushButton[0]->isDown() ) //Normal 
    Scrolling 
	{
	if (  event == 1 )
	scroll=scroll&&(!(bool)config->readNumEntry("NormalFuzzy"));
	if (  event == 2 )
	scroll=scroll&&(!(bool)config->readNumEntry("NormalSame"));
	if (  event == 3 )
	scroll=scroll&&(!(bool)config->readNumEntry("NormalNull"));
	}
	else
	if (PushButton[2]->isDown() || PushButton[3]->isDown() ) //--> & Scrolling 
	{
	if (  event == 1 )
	scroll=scroll&&(!(bool)config->readNumEntry("Fuzzy"));
	if (  event == 4 )
	scroll=scroll&&(!(bool)config->readNumEntry("NoTransl"));
	if (  event == 5 )
	scroll=scroll&&(!(bool)config->readNumEntry("NoTranslHere"));
	if (  event == 6 )
	scroll=scroll&&(!(bool)config->readNumEntry("TranslPoFile"));
	}
	if(!scroll) {for (i=0;i<4;i++)
	PushButton[i]->setEnabled(FALSE);
	PushButton[6]->setEnabled(TRUE);
	}
	} else {for (i=0;i<4;i++)
	PushButton[i]->setEnabled(TRUE);
	PushButton[6]->setEnabled(FALSE);
    */
  }
   
}

void TranslData::searchInCats()
{
  int i;
  mlTranslation=false;
  i=isItTranslated(nid);
  //warning(" cat :%d",i);
  if(i>=0) 
    listCat->setCurrentItem(i); 
    

  updateEd();

}

void TranslData::searchInMsgList()
{
//  msgListTranslation(aMsgId(nid));
    emit setStatus(5+msgListTranslation(aMsgId(nid)));

}


void TranslData::prevID()
{
  scrollData(-1);
  current(nid);
  updateEd();
}

void TranslData::scrollData(int sc)
{
  if(scroll) {
  stopSearch=true;
  mlTranslation=false;
  QString st;
  archive();
    nid+=sc;
    if(nid<1) nid=1;
    if(nid>nmax) nid=nmax; 
    st.sprintf("%i/%i",nid,nmax);
    //labelID->setText(st) ;
  }


}

void TranslData::gotoId(int sc)
{
  stopSearch=true;
  mlTranslation=false;
  QString st;
  archive();
  if(scroll) {
    nid=sc;
    if(nid<0) nid=0;
    if(nid>nmax) nid=nmax; 
    st.sprintf("%i/%i",nid,nmax);
    //labelID->setText(st) ;
  }


}



void TranslData::spellCheck()
{
// static bool spellchecking=false;
 if(spellchecking) return;
 spellchecking=true;
 spellPos.resize(nmax+1);
 if(spell!=0) 
 {
  spell->cleanUp();
  delete spell;
 }
 spell= new KSpell(this,i18n("KTranslator - spell check"),this,SLOT(spellready(KSpell *)),spellconf);
}






void TranslData::spelldone(char *a)
{
warning("cleaning up");
spell->cleanUp();
connect(spell,SIGNAL(cleanDone()),this,SLOT(spellfinish()));
}

void TranslData::spellfinish()
{
warning("FINITO");
spellchecking=false;
delete spell;
spell=0;
}

void TranslData::misspelling(char *a, QStrList *,unsigned i)
{
int d;
int pos=i;
//i+=spellPos[0];
for(d=1;(d<=nmax)&&(spellPos[d]<=i);d++){ }
gotoId(d);
current(nid);
updateEd();
int line, cnt=0;
if(d>1) pos-=spellPos[d-1];
 
      for (line=0;line<editNSTR->numLines() && cnt<=pos;line++)
    	cnt+=strlen(editNSTR->textLine(line))+1;
      line--;
      
      cnt=pos-cnt+strlen(editNSTR->textLine(line))+1;
//      if(line>0) cnt++; 
 if(isMulti(d)) cnt++; 
      editNSTR->setCursorPosition (line, cnt);
      editNSTR->setCursorPosition (line,cnt+strlen(a),TRUE);
 
 
 
}

void TranslData::correct(char *a,char* b,unsigned i)
{
  int d;
  //QString s;
  int pos=i;
  //i+=spellPos[0];
  for(d=1;(d<=nmax)&&(spellPos[d]<=i);d++){
      warning("%d",spellPos[d]);
    }
  int line, cnt=0;
  if(d>1) pos-=spellPos[d-1];
  gotoId(d);
  current(nid);
  updateEd();
  if( (QString) b != (QString) a)
    {
      
      for (line=0;line<editNSTR->numLines() && cnt<=pos;line++)
    	cnt+=strlen(editNSTR->textLine(line))+1;
      line--;
       
      cnt=pos-cnt+strlen(editNSTR->textLine(line))+1;
      if(isMulti(d)) cnt++; 
      //remove old word
      editNSTR->setCursorPosition (line, cnt);
      editNSTR->setCursorPosition (line,
        	 cnt+strlen(a),TRUE);

      editNSTR->cut();
      editNSTR->insertAt (b, line, cnt);
      archive();
     
     int dif=strlen(a)-strlen(b);
     warning("Diff %d",dif);
     for(int i=d;i<=nmax;i++)
       spellPos[i]-=dif;
    }

  editNSTR->deselect(); 
 
//warning("***********CORRECT %s\n %s\n Position: %d Msg: %d",a,b,i,d);

}


void TranslData::spellnext()
{
// if(!spell->isOk()) return;
 static int n=0;
 spellPos[0]=0;
  QString s,sn;
  QString *sa;
do{
 if(nmax<1) {spellchecking=false; return;} 
 n++;
  sa=Str[n]->first();

  if(!isMulti(n)) 
    s+=sa->copy(); 
  else
    for ( ;sa != 0; sa=Str[n]->next() )
      {
	sn=sa->copy();
 	if(sn.find("\\n")>=0) {          
	  //sn.truncate(sn.find("\\n")); 
	   sn+="\n";  
	 }
	s+=sn;   
      } 
      s+="\n"; 
//     warning(s);
    spellPos[n]=s.length();
 if (n==nmax)
      n=0;

   } while(n>0); 
//     s.simplifyWhiteSpace();
//     warning(s);
     spell->check(s);
}

void TranslData::spellready(KSpell *)
{
warning("Spell checker ready");
    if (spell->isOk())
      {

	connect (spell, SIGNAL (misspelling (char *, QStrList *, unsigned)),
		 this, SLOT (misspelling (char *, QStrList *, unsigned)));
	connect (spell, SIGNAL (corrected (char *,
						 char *, unsigned)),
		 this, SLOT (correct (char *,
					char *, unsigned)));

       connect (spell, SIGNAL (progress (unsigned int)),
                this, SIGNAL (setProgress(int) ));
          emit resetPb();
	  emit setStatus(9);
          emit setTotal(100);

	connect (spell, SIGNAL (done(char *)),
		 this, SLOT (spelldone(char *)));
	
	spell->setProgressResolution (2);
	//spell->check (text().data());
         spellnext();	
      }
    else
      {
	KMsgBox::message(this,"KTranslator: Error","Error starting KSpell.\n"\
			 "Please make sure you have ISpell properly configured and in your PATH.", KMsgBox::STOP);
      }
}

void TranslData::spellCheckConfig()
{
spellconf->show();
}

void TranslData::roughTranslation()
{
static bool open=false;
if(open) return;
open=true;
    int n=listCat->currentItem();

  if(QMessageBox::warning(this,i18n("Rough Translation"),
      i18n("Doing a rough translation you\nmay lose your old translation.\n Continue ?"),
       i18n("&Yes"),i18n("&No"),0,1,1 
              )!=0 ){ open=false; return;}    
  KApplication::getKApplication()->processEvents();     
  gotoId(0);
  current(nid);
  updateEd();

    emit resetPb();
    emit setStatus(8);
    emit setTotal(nmax);
    int i,l;
    int m=0;
    n=listCat->currentItem();
//    bool changed;
    bool fuzzyow=(bool)config->readNumEntry("Fuzzy");
    bool autos=!(bool)config->readNumEntry("NoAuto");
    bool ow=!(bool)config->readNumEntry("TranslPoFile");
    bool sip=(bool)config->readNumEntry("SearchInPo");
    bool mlisfuzzy=(bool)config->readNumEntry("MlIsFuzzy");
    bool tra;
    do {
    scroll=true;
    scrollData(1);
    updateEd();
    scroll=false;
    current(nid);    
    emit setProgress(m);    
    



    current(nid);
    
    if (msgEmpty || ow || (fuzzyow && msgFuzzy))
    {
    
    if(autos)n=isItTranslated(nid);
    tra=false;
    if((n>=0)&&(ncat>=0))
    tra=(cat[n]->translate(aMsgId(nid))!=aMsgId(nid)); 
    
    if(!tra&&(sip)){
    msgListTranslation(aMsgId(nid),1);
    emit resetPb();
    emit setStatus(8);
    emit setTotal(nmax);

    }
    
    if(((tra)&&(ncat>=0))||mlTranslation)

     {
//     warning("do");	
       m++;
      Str[nid]->clear();
     if(!mlTranslation) editSTR->clear();
    editNSTR->clear();
      if(isMulti(nid))  editSTR->insertLine(""); 
     if(!mlTranslation) editSTR->insertLine(cat[n]->translate(aMsgId(nid)));  
      l=editSTR->numLines(); 
      if(l>=2) 
	{ for(i=2;i< l;i++)
	 editSTR->insertAt("\\n",i-1,editSTR->text().length());
	}
  
        if(mlTranslation && mlisfuzzy)
         {
          editC->insertLine("#, fuzzy");
         }
    	for(i=0;i<l;i++) {
              Str[nid]->append(new QString(editSTR->textLine(i))); 
          editNSTR->insertLine(editSTR->textLine(i)); 
       }
      }
     }
    } 
   while(nid<nmax);
  archive();
  current(nid);
  updateEd();
    emit setProgress(m);    

scroll=true;
open=false;
}

void TranslData::nextID()
{
  scrollData(1);
  current(nid);
  updateEd();
}

void TranslData::nextFuzzy()
{

  do
  nextID();
  while ( ((!msgFuzzy)||!((bool)config->readNumEntry("NormalFuzzy" )))
	 && ((!msgSame )||!((bool)config->readNumEntry("NormalSame" )))         
	 && ((!msgEmpty)||!((bool)config->readNumEntry("NormalNull" )))
         && (nid < nmax));

}


void TranslData::prevFuzzy()
{
  do
  prevID();
  while ( ((!msgFuzzy)||!((bool)config->readNumEntry("NormalFuzzy" )))
	 && ((!msgSame )||!((bool)config->readNumEntry("NormalSame" )))         
	 && ((!msgEmpty)||!((bool)config->readNumEntry("NormalNull" )))
         && (nid > 1  ) );

}

void TranslData::archive()
{
  Str[nid]->clear();
  int l=editNSTR->numLines();
  int i;
  for(i=0;i<l;i++) 
    Str[nid]->append(new QString(editNSTR->textLine(i))); 

  Com[nid-1]->clear();
  l=editC->numLines();
  for(i=0;i<l;i++) 
    Com[nid-1]->append(new QString(editC->textLine(i))); 

}

void TranslData::storeAndNext()
{
  if (scroll) {
    int i,l;
    editNSTR->clear();
    Str[nid]->clear();
    l=editSTR->numLines();

    for(i=0;i<l;i++) {
      Str[nid]->append(new QString(editSTR->textLine(i))); 
      editNSTR->insertLine(editSTR->textLine(i)); 
    }
    scrollData(1);
    current(nid);
    updateEd();
  }
}

void TranslData::storeAndPrev()
{
  if(scroll) {
    int i,l;
    editNSTR->clear();
    Str[nid]->clear();
    l=editSTR->numLines();

    for(i=0;i<l;i++) {
      Str[nid]->append(new QString(editSTR->textLine(i))); 
      editNSTR->insertLine(editSTR->textLine(i)); 
    }
    scrollData(-1);
    current(nid);
    updateEd();
  }
}

void KTranslator::setup()
{

  QString oldPath;
  config->setGroup("Files");
  oldPath=config->readEntry("BasePath").copy();
  new Setup();
  config->setGroup("Files");
  if(oldPath!=config->readEntry("BasePath")) 
    {
      lv->setPath(config->readEntry("BasePath").copy());
      lv->buildDatabase();
    }
  wid->openMsgList();
}
void KTranslator::setupKeys()
{
KKeyDialog::configureKeys( acc ); 
//acc->writeSettings();
}


void KTranslator::saveopt()
{
  //config->rollback();
  config->sync();
}

void TranslData::storeSTR()
{
  int i,l;
  editNSTR->clear();
  Str[nid]->clear();
  l=editSTR->numLines();

  for(i=0;i<l;i++) {
    Str[nid]->append(new QString(editSTR->textLine(i))); 
    editNSTR->insertLine(editSTR->textLine(i)); 
  }
  updateEd();
}

void TranslData::gotoline()
{
    this->clearFocus();
TranslGoTo *trgoto =  new TranslGoTo(0,"goto",i18n("Go to .po file line"),i18n("line"));
int line=trgoto->result();
if (line <0) return;
int n=1;
  while (poLine[n]<line && (n <nmax) ) 
    n++;

 gotoId(n);
  current(nid);
  updateEd();
}

void TranslData::search()
{
this->clearFocus(); 
TranslSearch *trSearch =  new TranslSearch(0,"goto",false,fl);
//warning(trSearch->getStr());
if(trSearch->result()==0) return;
int n=1;
fl=trSearch->getFlags();
QString *sa;
searchStr=trSearch->getStr();

//if (searchString->isEmpty()) return;
int oldn=nid;
bool found=false;

  while ( (n <nmax) && !found && (n>0) ) {
    if(fl & TS_MSGSTR)
     for ( sa=Str[n]->first(); sa != 0; sa=Str[n]->next())  
       if(sa->find(searchStr,0,!(fl&TS_NOCASE) )>=0) found=true;
    if(fl & TS_MSGID)
      for ( sa=Id[n]->first(); sa != 0; sa=Id[n]->next())  
        if(sa->find(searchStr,0,!(fl&TS_NOCASE))>=0) found=true;
    if(fl & TS_COM)  {
      for ( sa=Com[n-1]->first(); sa != 0; sa=Com[n-1]->next())  
        if(sa->find(searchStr,0,!(fl&TS_NOCASE))>=0) found=true;
    }
    if(!found) 
	/*{
	 if(fl & TS_BACK)    n--; else */
	 n++;
	//}
 }
if (!found)n=oldn;
  gotoId(n);
  current(nid);
  updateEd();

}

void TranslData::replace()
{

this->clearFocus(); 
TranslSearch *trSearch =  new TranslSearch(0,"goto",true,fl);
//warning(trSearch->getStr());
if(trSearch->result()==0) return;
fl=trSearch->getFlags();
searchStr=trSearch->getStr();
replaceStr=trSearch->getReplaceStr();
 int res=1;
int n=1;
QString *sa;
int oldn=nid;
bool found=false;
TranslAskReplace *ask=0;
  while ( (res!=0)&&(n <nmax) && (!found || (fl&TS_REPALL)) && (n>0)) {
     found=false;
     for ( sa=Str[n]->first(); sa != 0; sa=Str[n]->next())  
       if(sa->find(searchStr,0,!(fl&TS_NOCASE) )>=0) found=true;
    
     if(found) 
       {
        gotoId(n);
        current(nid);
        updateEd();
	if(fl&TS_PROMPT)
	  {
	   if(ask==0)
	    ask=new TranslAskReplace();
	     res=ask->exec();
	  if(res==2)
	    {
	     res=1;
	     if(fl&TS_PROMPT) fl-=TS_PROMPT;
	    }
	        
	  } else res=1;
	 if(res==1) {
	 // warning("replace");
         for ( sa=Str[n]->first(); sa != 0; sa=Str[n]->next())  
           sa->replace(QRegExp(searchStr,!(fl&TS_NOCASE)),replaceStr);
           updateEd();
	   }
	 }
	
       n++;
     }

if(res!=0) {
  n=oldn;
  gotoId(n);
  current(nid);
}
  updateEd();

}


void TranslData::searchagain()
{
if (searchStr.isEmpty()) {search(); return; }
int n=nid+1;
QString *sa;
int oldn=nid;
bool found=false;

  while ( (n <nmax) && !found && (n>0)) {

    if(fl & TS_MSGSTR)
     for ( sa=Str[n]->first(); sa != 0; sa=Str[n]->next())  
       if(sa->find(searchStr,0,!(fl&TS_NOCASE) )>=0) found=true;
    if(fl & TS_MSGID)
      for ( sa=Id[n]->first(); sa != 0; sa=Id[n]->next())  
        if(sa->find(searchStr,0,!(fl&TS_NOCASE))>=0) found=true;
    if(fl & TS_COM)
      for ( sa=Com[n-1]->first(); sa != 0; sa=Com[n]->next())  
        if(sa->find(searchStr,0,!(fl&TS_NOCASE))>=0) found=true;
    
        if(!found) 
	{
	 if(fl & TS_BACK)    n--; else n++;
	}


 }

if (!found)n=oldn;
  gotoId(n);
  current(nid);
  updateEd();

}


void TranslData::gotomsg()
{
    this->clearFocus();
TranslGoTo *trgoto =  new TranslGoTo(0,"gotomsg",i18n("Go to message.."),i18n("Number:"));

int n=trgoto->result();
 gotoId(n);
  current(nid);
  updateEd();
}

void TranslData::openCats(QString language)
{
  QString s;
  if ( language.isNull() )
    {
      QMessageBox::message( "KDE ERROR", "No Language Specfied" );
      exit(1);
    }
    
    

  setenv("KDE_LANG",language,1);
  warning(language);
  int n=language.find(":");
  if (n>0) language.truncate(n);

  QString ldir = kapp->kde_localedir()+"/"+language+"/LC_MESSAGES/*.mo";
/*    config->setGroup("CompiledCat");
    //if(sourceList.isEmpty());
    int num=config->readNumEntry("NumItem");
    int i; 
    QString ldir;
*/    ncat=-1; 
    listCat->clear(); 
  
/*    for(i=0;i<num;i++)
    {
        s.sprintf("File%d",i+1);
        ldir=config->readEntry(s).copy();
        ldir.replace(QRegExp("%LANG%"),language);
          ldir.replace(QRegExp("%KDELOCALEDIR%"),kapp->kde_localedir());
*/
  glob_t globbuf;
  globbuf.gl_offs = 0;
	 
  if (glob(ldir,GLOB_DOOFFS , NULL, &globbuf)==0) warning("found!!!!");
//  int n;
  for(n=0;n<globbuf.gl_pathc;n++) 
    {
      
      ncat++;
      s=globbuf.gl_pathv[n];
      s.truncate(s.findRev("."));
      s.remove(0,s.findRev("/")+1); 
      listCat->insertItem(s+".mo");
      if((ncat % 100)==0) cat.resize(100+ncat);
      cat[ncat] = new KLocale(s);
//    warning(s);
    }
   //}
//  if(ncat>0)ncat=n;
  listCat->setCurrentItem(0);
  warning("Catlogues loaded:  %i",ncat);

}


#include "TranslData.moc"


















