#include "equalizer.h"
#include "equalizerview.h"
#include <qlayout.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include "noatunapp.h"
#include <kdialog.h>
#include <kiconloader.h>
#include <klocale.h>

EqualizerLevel::EqualizerLevel(QWidget *parent, Band *band) : QWidget(parent)
{
	QVBoxLayout *layout=new QVBoxLayout(this);
	layout->setAutoAdd(true);

	mBand=band;
	connect(napp->equalizer(), SIGNAL(changed(Band *)), SLOT(changed(Band*)));

	mSlider=new QSlider(-200, 200, 50, 0, Qt::Vertical, this);
	connect(mSlider, SIGNAL(valueChanged(int)), SLOT(changed(int)));
	mLabel=new QLabel(band->format(), this);
	mLabel->setAlignment(AlignHCenter | AlignVCenter);

	setMinimumHeight(150);
	setMinimumWidth(30);
	changed(band);
}

void EqualizerLevel::changed(Band *b)
{
	if (b!=mBand) return;
	mSlider->blockSignals(true);
	mSlider->setValue(-(b->level()));
	mSlider->blockSignals(false);
}

void EqualizerLevel::changed(int l)
{
	mBand->setLevel(-l);
}

EqualizerView::EqualizerView()
	: KDialogBase(0, 0, false, i18n("Equalizer"), Help | Close, Close, true)
{
	QFrame *frame = makeMainWidget();
	(new QHBoxLayout(frame, KDialog::marginHint(), 10))->setAutoAdd(true);
	QList<Band> bands=napp->equalizer()->bands();
	for (Band *i=bands.first(); i!=0; i=bands.next())
		new EqualizerLevel(frame, i);

	mOn=new QCheckBox(i18n("&Enabled"), frame);
	connect( mOn, SIGNAL(toggled(bool)), napp->equalizer(), SLOT(setEnabled(bool)) );
	connect( napp->equalizer(), SIGNAL(enabled(bool)), this, SLOT(qCheckBoxIsStupid(bool)) );
	mOn->setChecked(false);
	qCheckBoxIsStupid(napp->equalizer()->isEnabled());

	setIcon(SmallIcon("noatun"));
}

void EqualizerView::qCheckBoxIsStupid(bool on)
{
	mOn->setChecked(on);
}

