#include "playlistsaver.h"


PlayListSaver::PlayListSaver(const QString &file)
	: KSimpleConfig(file)
{
	writeEntry("NoatunPlaylist", true);
	writeEntry("FormatVersion", "0.99");
}

PlayListSaver::~PlayListSaver()
{

}

QString PlayListSaver::title()
{
	setGroup("");
	return readEntry("title");
}

void PlayListSaver::setTitle(const QString &title)
{
	setGroup("");
	writeEntry("title", title);
}

QDateTime PlayListSaver::date()
{
	setGroup("");
	return readDateTimeEntry("date");
}

QString PlayListSaver::location()
{
	setGroup("");
	return readEntry("date");
}

bool PlayListSaver::isPlayList(const QString &file)
{
	KSimpleConfig f(file);
	return f.readBoolEntry("NoatunPlaylist");
}

QStringList PlayListSaver::fileList() const
{
	QStringList list=groupList().grep("File-.*");
	for(QStringList::Iterator it=list.begin(); it != list.end(); ++it )
		stripFilePre(*it);
	return list;	
}

QString &PlayListSaver::stripFilePre(QString &f)
{
	if (f.right(5)=="File-")
		return f=f.left(f.length()-5);
	return f;
}

QString PlayListSaver::file() const
{
	QString gr=group();
	return stripFilePre(gr);
}

void PlayListSaver::setFile(const QString &file)
{
	setGroup("File-"+file);
}
