#include <qiconset.h>
#include <qdialog.h>
#include <klocale.h>
#include <qpixmap.h>
#include <qdom.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kapp.h>
#include <kstdaction.h>
#include <kstddirs.h>
#include <khelpmenu.h>
#include <assert.h>

#include "kvnc.h"
#include "krfbcanvas.h"
#include "kvncaboutdlg.h"
#include "kvncoptionsdlg.h"
#include "krfbconnection.h"

#include "kvnc.moc"

// $Id: kvnc.cpp,v 1.9 2000/12/04 23:10:08 rich Exp $

const int StatusTextId = 0;

KVNC::KVNC( const char *name )
  : KMainWindow( 0, name )
{
  fullscreen = false;

  canvas = new KRFBCanvas( this, "canvas" );
  setCentralWidget( canvas );

  connect( canvas, SIGNAL( statusChanged( const QString & ) ),
           statusBar(), SLOT( message( const QString & ) ) );

  setupActions();

  setupMenuBar();
  setupStatusBar();

  conserveMemory();
}

KVNC::~KVNC()
{

}

void KVNC::openURL( const KURL &url )
{
  canvas->openURL( url );
}

void KVNC::setupActions()
{
  KStdAction::quit(kapp, SLOT(quit()), actionCollection(), "quit");

  //
  // View menu
  //

  KStdAction::redisplay(canvas, SLOT( refresh() ), actionCollection() );

  fullScreenAction = new KAction( i18n("&Full Screen"),
                                  "window_fullscreen",
                                  CTRL+SHIFT+Key_F,
                                  this, SLOT( toggleFullScreen() ),
                                  actionCollection(),
                                  "fullscreen");

  //
  // Options menu
  //
  menubarAction = KStdAction::showMenubar(
					this, SLOT( toggleShowMenu() ),
					actionCollection() );

  toolbarAction = KStdAction::showToolbar(
					this, SLOT( toggleShowToolbar() ),
					actionCollection() );

  statusbarAction = KStdAction::showStatusbar(
					this, SLOT( toggleShowStatus() ),
					actionCollection() );

  KStdAction::saveOptions(
				    this, SLOT( toggleFullScreen() ),
				    actionCollection() );

  KStdAction::preferences(
				    this, SLOT( showOptions() ),
				    actionCollection() );

  createGUI( QString::null, false );
}

void KVNC::setupMenuBar()
{
  cornerMenu = new KPopupMenu();

  QDomElement menuBar = domDocument().documentElement().namedItem( "MenuBar" ).toElement();
  QDomElement e = menuBar.firstChild().toElement();
  for (; !e.isNull(); e = e.nextSibling().toElement() )
  {
    QWidget *cont = factory()->container( e.attribute( "name" ), this );
    assert( cont->inherits( "QPopupMenu" ) );
    QPopupMenu *popup = static_cast<QPopupMenu *>( cont );
    cornerMenu->insertItem( i18n( e.namedItem( "text" ).toElement().text().latin1() ),
			    popup );
  }

  cornerButton = new QPushButton( this );
  cornerButton->setText( "K" );
  cornerButton->setPopup( cornerMenu );
  cornerButton->hide();
}

void KVNC::setupStatusBar()
{
  KStatusBar *status = statusBar();
  status->insertItem( i18n("Welcome to Keystone"), StatusTextId );
}

void KVNC::toggleFullScreen()
{
  if ( fullscreen ) {
    showNormal();
    canvas->releaseKeyboard();
    fullScreenAction->setText( i18n("&Full Screen") );
    fullScreenAction->setIcon( "window_fullscreen" );
  }
  else {
    showFullScreen();
    raise();
    canvas->setFocus();
    canvas->grabKeyboard();

    fullScreenAction->setText( i18n("Stop &Full Screen") );
    fullScreenAction->setIcon( "window_nofullscreen" );
  }

  fullscreen = !fullscreen;
}

void KVNC::showAboutApplication()
{
  KVNCAboutDlg about;
  about.exec();
}

void KVNC::toggleShowStatus()
{
  if (statusbarAction->isChecked())
    statusBar()->show();
  else
    statusBar()->hide();
}

void KVNC::toggleShowMenu()
{
  if (menubarAction->isChecked())
  {
    menuBar()->show();
    canvas->setCornerWidget( 0 );
    cornerButton->hide();
  }
  else 
  {
    menuBar()->hide();
    cornerButton->show();
    canvas->setCornerWidget( cornerButton );
  }
}

void KVNC::toggleShowToolbar()
{
  if (toolbarAction->isChecked())
    toolBar()->show();
  else
    toolBar()->hide();
}

void KVNC::showOptions()
{
  KVNCOptionsDlg *wdg = new KVNCOptionsDlg( canvas->connection()->options(),
                                            this );
  wdg->exec();
  delete wdg;
}

