/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[]="@(#)$Id: yp_xdr.c,v 0.20 1994/01/02 22:48:22 root Exp $";

/*
 *	$Author: root $
 *	$Log: yp_xdr.c,v $
 * Revision 0.20  1994/01/02  22:48:22  root
 * Added strict prototypes
 *
 * Revision 0.19  1994/01/02  20:09:39  root
 * Added GPL notice
 *
 * Revision 0.18  1994/01/02  18:06:13  root
 * Fixed another bug in xdr_ypresp_all
 *
 * Revision 0.17  1993/12/30  22:34:57  root
 * *** empty log message ***
 *
 * Revision 0.16  1993/12/29  00:37:37  root
 * Fixed a bug in xdr_ypresp_key_val
 *
 * Revision 0.15  1993/06/16  22:54:12  dok235
 * Fix a bug in ypresp_key_val
 *
 * Revision 0.14  1993/06/12  09:39:30  root
 * Align with include-4.4
 *
 * Revision 0.13  1993/06/11  21:45:00  root
 * Regenned from yp.x, that came with include-4.4
 *
 */

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <rpc/rpc.h>
#include <rpcsvc/yp.h>

#ifdef DEBUG
#define PRINTF(x) printf x
#define PRLINENO printf(__FILE__ "(%d): ", __LINE__)
#else
#define PRINTF(x)
#define PRLINENO
#endif

struct {
	union {
	int (*encoder)(char *, int, char **, int *, char **, int *);
	int (*decoder)(int, char *, int, char *, int, char *);
	} foreach;
	char *data;
} *xdr_ypall_callback;

bool_t
xdr_ypstat(XDR *xdrs, ypstat *objp)
{

	 if (!xdr_enum(xdrs, (enum_t *)objp)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypxfrstat(XDR *xdrs, ypxfrstat *objp)
{

	 if (!xdr_enum(xdrs, (enum_t *)objp)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_domainname(XDR *xdrs, domainname *objp)
{

	 if (!xdr_string(xdrs, objp, YPMAXDOMAIN)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_mapname(XDR *xdrs, mapname *objp)
{

	 if (!xdr_string(xdrs, objp, YPMAXMAP)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_peername(XDR *xdrs, peername *objp)
{

	 if (!xdr_string(xdrs, objp, YPMAXPEER)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_keydat(XDR *xdrs, keydat *objp)
{

	 if (!xdr_bytes(xdrs, (char **)&objp->keydat_val, (u_int *)&objp->keydat_len, YPMAXRECORD)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_valdat(XDR *xdrs, valdat *objp)
{

	 if (!xdr_bytes(xdrs, (char **)&objp->valdat_val, (u_int *)&objp->valdat_len, YPMAXRECORD)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypmap_parms(XDR *xdrs, ypmap_parms *objp)
{

	 if (!xdr_domainname(xdrs, &objp->domain)) {
		 return (FALSE);
	 }
	 if (!xdr_mapname(xdrs, &objp->map)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->ordernum)) {
		 return (FALSE);
	 }
	 if (!xdr_peername(xdrs, &objp->peer)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypreq_key(XDR *xdrs, ypreq_key *objp)
{

	 if (!xdr_domainname(xdrs, &objp->domain)) {
		 return (FALSE);
	 }
	 if (!xdr_mapname(xdrs, &objp->map)) {
		 return (FALSE);
	 }
	 if (!xdr_keydat(xdrs, &objp->key)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypreq_nokey(XDR *xdrs, ypreq_nokey *objp)
{

	 if (!xdr_domainname(xdrs, &objp->domain)) {
		 return (FALSE);
	 }
	 if (!xdr_mapname(xdrs, &objp->map)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypreq_xfr(XDR *xdrs, ypreq_xfr *objp)
{

	 if (!xdr_ypmap_parms(xdrs, &objp->map_parms)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->transid)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->prog)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->port)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_val(XDR *xdrs, ypresp_val *objp)
{

	 if (!xdr_ypstat(xdrs, &objp->stat)) {
		 return (FALSE);
	 }
	 if (!xdr_valdat(xdrs, &objp->val)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_key_val(XDR *xdrs, ypresp_key_val *objp)
{

	 if (!xdr_ypstat(xdrs, &objp->stat)) {
		 return (FALSE);
	 }
	 if (!xdr_valdat(xdrs, &objp->val)) {
		 return (FALSE);
	 }
	 if (!xdr_keydat(xdrs, &objp->key)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_master(XDR *xdrs, ypresp_master *objp)
{

	 if (!xdr_ypstat(xdrs, &objp->stat)) {
		 return (FALSE);
	 }
	 if (!xdr_peername(xdrs, &objp->peer)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_order(XDR *xdrs, ypresp_order *objp)
{

	 if (!xdr_ypstat(xdrs, &objp->stat)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->ordernum)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_all(XDR *xdrs, ypresp_all *objp)
{
   int CallAgain = 0;
   PRLINENO;
   if (xdrs->x_op == XDR_DECODE) {
      while(1) {
#if 1
         int s=objp->ypresp_all_u.val.stat;
         bzero((char *)objp, sizeof (*objp));
         objp->ypresp_all_u.val.stat=s;
#endif
	 if (!xdr_bool(xdrs, &objp->more)) {
	    return (FALSE);
	 }
	 switch (objp->more) {
	 case TRUE:
	    if (!xdr_ypresp_key_val(xdrs, &objp->ypresp_all_u.val)) {
	       return (FALSE);
	    }
	    if (CallAgain==0) {
	       CallAgain=(*(xdr_ypall_callback->foreach.decoder))(
	       objp->ypresp_all_u.val.stat,
	       objp->ypresp_all_u.val.key.keydat_val,
	       objp->ypresp_all_u.val.key.keydat_len,
	       objp->ypresp_all_u.val.val.valdat_val,
	       objp->ypresp_all_u.val.val.valdat_len,
	       xdr_ypall_callback->data);
	    }
            break;
	 case FALSE:
	    return TRUE;
	 }
#if 0
         xdrs->x_op=XDR_FREE;
	 if (!xdr_ypresp_all(xdrs, objp)) {
	    return FALSE;
         }
         xdrs->x_op=XDR_DECODE;
#else
	 xdr_free(xdr_ypresp_all, (char *)objp);
#endif
      }
   } else if (xdrs->x_op == XDR_ENCODE) {
      while(1) {
	 if (!xdr_bool(xdrs, &(objp->more))) {
	    return (FALSE);
	 }
	 if (!xdr_ypresp_key_val(xdrs, &objp->ypresp_all_u.val)) {
	    printf("xdr_ypresp_key_val failed\n");
	    return (FALSE);
	 }
	 if (objp->ypresp_all_u.val.stat!=YP_TRUE) {
	    objp->more=FALSE;
	    if (!xdr_bool(xdrs, &(objp->more))) {
	       return (FALSE);
	    }
	    return(TRUE);
	 }
	 objp->ypresp_all_u.val.stat =
	    (enum ypstat)(*(xdr_ypall_callback->foreach.encoder))(
	    objp->ypresp_all_u.val.key.keydat_val,
	    objp->ypresp_all_u.val.key.keydat_len,
	    &(objp->ypresp_all_u.val.key.keydat_val),
	    &(objp->ypresp_all_u.val.key.keydat_len),
	    &(objp->ypresp_all_u.val.val.valdat_val),
	    &(objp->ypresp_all_u.val.val.valdat_len));
      }
   } else {
#if 0
        bool_t more=objp->more;
	if (more==TRUE) {
	   if (!xdr_bool(xdrs, &objp->more)) {
	      return FALSE;
	   }
           if (!xdr_ypresp_key_val(xdrs, &objp->ypresp_all_u.val)) {
	      return (FALSE);
	   }
        }
#endif
	   
      return(TRUE);
   }
}

bool_t
xdr_ypresp_xfr(XDR *xdrs, ypresp_xfr *objp)
{

	 if (!xdr_u_int(xdrs, &objp->transid)) {
		 return (FALSE);
	 }
	 if (!xdr_ypxfrstat(xdrs, &objp->xfrstat)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypmaplist(XDR *xdrs, ypmaplist *objp)
{

	 if (!xdr_mapname(xdrs, &objp->map)) {
		 return (FALSE);
	 }
	 if (!xdr_pointer(xdrs, (char **)&objp->next, sizeof(ypmaplist), (xdrproc_t)xdr_ypmaplist)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypresp_maplist(XDR *xdrs, ypresp_maplist *objp)
{

	 if (!xdr_ypstat(xdrs, &objp->stat)) {
		 return (FALSE);
	 }
	 if (!xdr_pointer(xdrs, (char **)&objp->maps, sizeof(ypmaplist), (xdrproc_t)xdr_ypmaplist)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_yppush_status(XDR *xdrs, yppush_status *objp)
{

	 if (!xdr_enum(xdrs, (enum_t *)objp)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_yppushresp_xfr(XDR *xdrs, yppushresp_xfr *objp)
{

	 if (!xdr_u_int(xdrs, &objp->transid)) {
		 return (FALSE);
	 }
	 if (!xdr_yppush_status(xdrs, &objp->status)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypbind_resptype(XDR *xdrs, ypbind_resptype *objp)
{

	 if (!xdr_enum(xdrs, (enum_t *)objp)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypbind_binding(XDR *xdrs, ypbind_binding *objp)
{

	 if (!xdr_opaque(xdrs, objp->ypbind_binding_addr, 4)) {
		 return (FALSE);
	 }
	 if (!xdr_opaque(xdrs, objp->ypbind_binding_port, 2)) {
		 return (FALSE);
	 }
	return (TRUE);
}

bool_t
xdr_ypbind_resp(XDR *xdrs, ypbind_resp *objp)
{

	 if (!xdr_ypbind_resptype(xdrs, &objp->ypbind_status)) {
		 return (FALSE);
	 }
	switch (objp->ypbind_status) {
	case YPBIND_FAIL_VAL:
		 if (!xdr_u_int(xdrs, &objp->ypbind_resp_u.ypbind_error)) {
			 return (FALSE);
		 }
		break;
	case YPBIND_SUCC_VAL:
		 if (!xdr_ypbind_binding(xdrs, &objp->ypbind_resp_u.ypbind_bindinfo)) {
			 return (FALSE);
		 }
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_ypbind_setdom(XDR *xdrs, ypbind_setdom *objp)
{

	 if (!xdr_domainname(xdrs, &objp->ypsetdom_domain)) {
		 return (FALSE);
	 }
	 if (!xdr_ypbind_binding(xdrs, &objp->ypsetdom_binding)) {
		 return (FALSE);
	 }
	 if (!xdr_u_int(xdrs, &objp->ypsetdom_vers)) {
		 return (FALSE);
	 }
	return (TRUE);
}
